/*
 * Decompiled with CFR 0.152.
 */
package ru.ac.rechaos;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.server.players.PlayerList;
import org.slf4j.Logger;
import ru.ac.Protocol.Events.EventDataFromApp;
import ru.ac.ReChaosTrick.Utils;
import ru.ac.rechaos.Settings.SettingsManager;
import ru.ac.rechaostricks.Constants;

public class ChaosMod {
    public static final ChaosMod INSTANCE = new ChaosMod();
    private static final Logger logger = Constants.LOG;

    public static boolean isPlayerOp() {
        if (Minecraft.getInstance().isSingleplayer()) {
            return true;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        return player != null && player.hasPermissions(2);
    }

    public static void addEvents(List<EventDataFromApp> events) {
    }

    private void setupGriefing() {
        Utils.sendCommand("gamerule mobGriefing " + SettingsManager.INSTANCE.get().getIsGriefingAllowed());
    }

    public void setGamerules() {
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            logger.info("Settings world gamerules...");
            this.setupLocalServerEnvironment();
            logger.info("Setuped local server environment");
            Utils.safeSilentVoidRunner(() -> Utils.setGameRules(false, "sendCommandFeedback", "logAdminCommands"));
            Utils.safeSilentVoidRunner(this::setupGriefing);
        } else {
            logger.info("No world present, skipping gamerules");
        }
    }

    private void setupLocalServerEnvironment() {
        IntegratedServer singlePlayerServer = Minecraft.getInstance().getSingleplayerServer();
        if (singlePlayerServer != null) {
            PlayerList players = singlePlayerServer.getPlayerList();
            if (players.isAllowCommandsForAllPlayers()) {
                players.setAllowCommandsForAllPlayers(true);
            }
            if (Minecraft.getInstance().player.hasPermissions(4)) {
                Minecraft.getInstance().player.setPermissionLevel(4);
            }
        }
    }
}

