/*
 * Decompiled with CFR 0.152.
 */
package ru.ac.ReChaosTrick;

import com.google.gson.Gson;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.io.File;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.phys.Vec3;
import ru.ac.rechaostricks.Constants;

public class Utils {
    public static final Supplier<LocalPlayer> localPlayer = () -> Minecraft.getInstance().player;
    public static final Supplier<ClientPacketListener> minecraftConnection = () -> Minecraft.getInstance().getConnection();
    public static final String minecraftCommandPrefix = "minecraft:";
    public static final Gson json = new Gson();

    public static BlockPos round(Vec3 val) {
        return BlockPos.containing((Position)val);
    }

    public static LiteralArgumentBuilder<?> ofSecondLevelPermissions(String name) {
        return Commands.literal((String)name);
    }

    public static void forEachHostileMob(CommandSourceStack _for, Consumer<Entity> hostileConsumer) {
        Utils.forEachHostileMob(_for.getLevel().getAllEntities(), hostileConsumer);
    }

    public static void forEachHostileMob(Iterable<Entity> entities, Consumer<Entity> hostileConsumer) {
        entities.forEach(entity -> {
            if (Utils.isHostileToPlayer(entity)) {
                hostileConsumer.accept((Entity)entity);
            }
        });
    }

    public static boolean isHostileToPlayer(Entity entity) {
        return entity instanceof Enemy;
    }

    public static void sendCommand(String commandText) {
        LocalPlayer player = localPlayer.get();
        if (player != null) {
            Constants.LOG.info("Sending server command: {}", (Object)commandText);
            player.connection.sendCommand(commandText);
        } else {
            Constants.LOG.warn("Tried to send command, while local player is null");
        }
    }

    public static void sendCommand(List<String> commandsText) {
        LocalPlayer player = localPlayer.get();
        if (player != null) {
            Utils.safeSilentVoidIterator((T commandText) -> {
                switch (commandText.split(" ")[0]) {
                    case "wait": {
                        Utils.safeVoidRunner(() -> Thread.sleep(Integer.parseInt(commandText.split(" ", 2)[1])));
                        break;
                    }
                    case "dropAllItems": {
                        Minecraft.getInstance().player.getInventory().items.stream().forEach(e -> Minecraft.getInstance().player.drop(e, true));
                        break;
                    }
                    default: {
                        if (commandText.isBlank()) break;
                        Constants.LOG.info("Sending server command: {}", commandText);
                        player.connection.sendCommand(commandText);
                    }
                }
            }, commandsText);
        } else {
            Constants.LOG.warn("Tried to send command, while local player is null");
        }
    }

    public static String sanitizeDefaultMinecraftCommand(String dirty) {
        if (dirty.startsWith("/")) {
            dirty = dirty.substring(1);
        }
        return minecraftCommandPrefix + dirty;
    }

    public static void sendMinecraftCommand(String commandText) {
        Utils.sendCommand(minecraftCommandPrefix + commandText);
    }

    public static void sendSanitizedMinecraftCommand(String commandText) {
        Utils.sendCommand(Utils.sanitizeDefaultMinecraftCommand(commandText));
    }

    public static void setGameRule(GameRules.Key<?> gamerule, boolean desiredStatus) {
        Utils.setGameRule(gamerule.getId(), desiredStatus);
    }

    public static void setGameRule(String gamerule, boolean desiredStatus) {
        Utils.sendMinecraftCommand("gamerule " + gamerule + " " + desiredStatus);
    }

    public static void setGameRules(boolean desiredStatus, String ... gamerules) {
        for (String rule : gamerules) {
            Utils.sendCommand("gamerule " + rule + " " + desiredStatus);
        }
    }

    public static boolean isPlayerOperator() {
        LocalPlayer player = localPlayer.get();
        return player != null && player.hasPermissions(2);
    }

    public static void safeVoidRunner(ThrowingRunnable toCall) {
        try {
            toCall.run();
        }
        catch (Exception ex) {
            Constants.LOG.error("Exception occured", (Throwable)ex);
        }
    }

    public static void safeSilentVoidRunner(ThrowingRunnable toCall) {
        try {
            toCall.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static <T, U> U safeSilentFunctionRunner(ThrowingFunction<T, U> function, T param) {
        try {
            return function.run(param);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> void safeSilentVoidIterator(ThrowingConsumer<T> toCall, T ... values) {
        Utils.safeSilentVoidIterator(toCall, List.of(values));
    }

    public static <T> void safeSilentVoidIterator(ThrowingConsumer<T> toCall, List<T> values) {
        try {
            for (T value : values) {
                toCall.run(value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static <T> void safeVoidIterator(ThrowingConsumer<T> toCall, List<T> values) {
        try {
            for (T value : values) {
                toCall.run(value);
            }
        }
        catch (Exception ex) {
            Constants.LOG.error("Exception occurred", (Throwable)ex);
        }
    }

    public static <T> T safeRunner(RetThrowingRunnable<T> toCall) {
        return Utils.safeRunner(toCall, null);
    }

    public static <T> T safeRunner(RetThrowingRunnable<T> toCall, T defaultValue) {
        try {
            return toCall.run();
        }
        catch (Exception ex) {
            Constants.LOG.error("Exception occured", (Throwable)ex);
            return defaultValue;
        }
    }

    public static <T> T safeSilentRunner(RetThrowingRunnable<T> toCall, T defaultValue) {
        try {
            return toCall.run();
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static boolean deleteFile(File file) {
        return Boolean.TRUE.equals(Utils.safeRunner(() -> {
            if (file.exists() && file.delete()) {
                return true;
            }
            Constants.LOG.info("Failed to delete file {}", (Object)file.getAbsolutePath());
            return false;
        }));
    }

    public static <T> T fromJson(String input, Class<T> cast) {
        return Utils.safeRunner(() -> json.fromJson(input, cast), null);
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<T> {
        public void run(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowingRunnable {
        public void run() throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowingFunction<T, U> {
        public U run(T var1);
    }

    @FunctionalInterface
    public static interface RetThrowingRunnable<T> {
        public T run() throws Exception;
    }
}

