/*
 * Decompiled with CFR 0.152.
 */
package ru.ac.ReChaosTrick.ChaosBlocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import ru.ac.Protocol.Events.EventDataFromApp;
import ru.ac.ReChaosTrick.ChaosBlocks.CommandChaosBlock;
import ru.ac.ReChaosTrick.Interfaces.IChaosBlock;
import ru.ac.ReChaosTrick.Utilities.ChaosUtils;

public class RandomChaosBlock
implements IChaosBlock {
    private final List<IChaosBlock> randomSet;
    private int randomElements = 1;

    public RandomChaosBlock(IChaosBlock ... set) {
        this.randomSet = new ArrayList<IChaosBlock>(List.of(set));
    }

    public RandomChaosBlock(int amountOfElementsToInvoke, IChaosBlock ... set) {
        this.randomSet = new ArrayList<IChaosBlock>(List.of(set));
        this.randomElements = amountOfElementsToInvoke;
    }

    public RandomChaosBlock(List<IChaosBlock> set) {
        this.randomSet = new ArrayList<IChaosBlock>(set);
    }

    public static RandomChaosBlock ofCommands(String ... commands) {
        return new RandomChaosBlock(Stream.of(commands).map(CommandChaosBlock::of).map(e -> e).toList());
    }

    public static RandomChaosBlock ofSameDeltaCommands(int dX, int dY, int dZ, String ... commands) {
        return new RandomChaosBlock(Stream.of(commands).map(e -> CommandChaosBlock.of(e, dX, dY, dZ)).map(e -> e).toList());
    }

    public static RandomChaosBlock ofCommands(CommandChaosBlock ... commands) {
        return new RandomChaosBlock(List.of(commands));
    }

    public RandomChaosBlock shuffleSet() {
        Collections.shuffle(this.randomSet);
        return this;
    }

    @Override
    public void run(EventDataFromApp evt) throws Exception {
        for (int i = 0; i < this.randomElements; ++i) {
            this.randomSet.get((int)(ChaosUtils.chaosRandom.nextDouble() % 1.0 * (double)this.randomSet.size())).safeRunWithin(evt);
        }
    }
}

