/*
 * Decompiled with CFR 0.152.
 */
package ru.ac.ReChaosTrick.ChaosBlocks;

import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import ru.ac.Protocol.Events.EventDataFromApp;
import ru.ac.ReChaosTrick.Interfaces.IChaosBlock;
import ru.ac.ReChaosTrick.Utils;
import ru.ac.rechaostricks.Constants;

public class CreativeFlightBlock
implements IChaosBlock {
    private final long ms;

    public CreativeFlightBlock(long milliseconds) {
        this.ms = milliseconds;
    }

    public static CreativeFlightBlock of(long durationMS) {
        return new CreativeFlightBlock(durationMS);
    }

    public static void allowFlight() {
        Minecraft.getInstance().player.getAbilities().mayfly = true;
    }

    public static void disableFlight() {
        if (Minecraft.getInstance().player != null && Minecraft.getInstance().getCurrentServer() != null) {
            if (!Minecraft.getInstance().player.isCreative()) {
                Minecraft.getInstance().player.getAbilities().mayfly = false;
                Constants.LOG.info("Creative flight disabled");
            } else {
                Constants.LOG.info("Creative flight was not disabled cos not in survival!");
            }
        }
    }

    @Override
    public void run(EventDataFromApp object) throws Exception {
        if (Minecraft.getInstance().player.isCreative()) {
            Constants.LOG.info("Creative flight not enabled, cos player in creative gamemode");
            return;
        }
        CreativeFlightBlock.allowFlight();
        Constants.LOG.info("Creative flight enabled");
        CompletableFuture.runAsync(() -> {
            Utils.safeVoidRunner(() -> Thread.sleep(this.ms));
            CreativeFlightBlock.disableFlight();
        });
    }
}

