/*
 * Decompiled with CFR 0.152.
 */
package ru.ac.ReChaosTrick.ChaosBlocks;

import ru.ac.Protocol.Events.EventDataFromApp;
import ru.ac.ReChaosTrick.Interfaces.IChaosBlock;
import ru.ac.ReChaosTrick.Utilities.ChaosUtils;
import ru.ac.ReChaosTrick.Utils;
import ru.ac.rechaos.Settings.SettingsManager;

public class CommandChaosBlock
implements IChaosBlock {
    private final String command;
    private int dX = 0;
    private int dY = 0;
    private int dZ = 0;

    public CommandChaosBlock(String commandText) {
        this.command = commandText;
    }

    public CommandChaosBlock(String commandText, int maxDeltaX, int maxDeltaY, int maxDeltaZ) {
        this.command = commandText;
        this.dX = maxDeltaX;
        this.dY = maxDeltaY;
        this.dZ = maxDeltaZ;
    }

    public static CommandChaosBlock of(String command) {
        return new CommandChaosBlock(command);
    }

    public static CommandChaosBlock of(String command, int maxDeltaX, int maxDeltaY, int maxDeltaZ) {
        return new CommandChaosBlock(command, maxDeltaX, maxDeltaY, maxDeltaZ);
    }

    public static String formatCommand(CommandChaosBlock command, EventDataFromApp event) {
        String out = command.command.replace("%target%", SettingsManager.INSTANCE.get().getAffectedPlayers()).replace("%name%", event.username());
        if (out.contains("%rand_pos%")) {
            out = out.replace("%target%", ChaosUtils.toCoordinates(ChaosUtils.getRandomBlockPos()));
        }
        if (out.contains("%rand_pos_around%")) {
            out = out.replace("%rand_pos_around%", ChaosUtils.toCoordinates(ChaosUtils.getEmptySpacesAroundPlayerOfSingle(command.dX, command.dY, command.dZ)));
        }
        return out;
    }

    @Override
    public void run(EventDataFromApp event) throws Exception {
        Utils.sendCommand(CommandChaosBlock.formatCommand(this, event));
    }
}

