/*
 * Decompiled with CFR 0.152.
 */
package ru.ac.Protocol.Events;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import ru.ac.Protocol.Events.EventDataFromApp;
import ru.ac.ReChaosTrick.Utils;
import ru.ac.rechaos.ChaosMod;

public class EventReader {
    public static final EventReader instance = new EventReader();

    public List<String> readFileInList(String filePath, boolean isNeededCleared) {
        return Utils.safeRunner(() -> {
            Path target = Path.of(filePath, new String[0]);
            if (Files.exists(target, new LinkOption[0])) {
                if (isNeededCleared) {
                    Files.writeString(target, (CharSequence)"", StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                }
                return Files.readAllLines(target);
            }
            Files.createFile(target, new FileAttribute[0]);
            return Collections.emptyList();
        });
    }

    public boolean readEvent(String filePath, boolean isNeedClear) {
        List<String> read = this.readFileInList(filePath, isNeedClear);
        List<EventDataFromApp> events = read.parallelStream().map(String::trim).filter(str -> !str.isEmpty()).map(EventDataFromApp::fromString).toList();
        if (!events.isEmpty()) {
            ChaosMod.addEvents(events);
            return true;
        }
        return false;
    }
}

