/*
 * Decompiled with CFR 0.152.
 */
package ru.ac.Protocol;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;
import ru.ac.Protocol.Data.EventManager;
import ru.ac.Protocol.Data.SocketMessage;
import ru.ac.ReChaosTrick.Utils;
import ru.ac.rechaos.Settings.SettingsManager;
import ru.ac.rechaostricks.Constants;

public class ChaosTricksWSLib {
    public static final String configRequest = "{\"type\":\"config\",\"data\":\"\"}";
    public static final ChaosTricksWSLib INSTANCE = new ChaosTricksWSLib();
    public static final String endPoint = "ws://127.0.0.1:13715/chaostricks";
    public static final Component connectedString = Component.literal((String)"[ChaosTricks] Connected to local WS!");
    private static final Map<String, Consumer<SocketMessage>> objectRouter = new HashMap<String, Consumer<SocketMessage>>();
    public static CompletableFuture<Void> disconnectWaiters;
    private WSClient connection = null;

    private ChaosTricksWSLib() {
    }

    private void onConnected(ServerHandshake handshake) {
        Constants.LOG.info("Connected to ChaosTricks - Minecraft WS");
        this.connection.send(configRequest);
    }

    private void onMsg(String str) {
        SocketMessage msg = Utils.fromJson(str, SocketMessage.class);
        if (objectRouter.containsKey(msg.type())) {
            objectRouter.get(msg.type()).accept(msg);
        } else {
            Constants.LOG.info("Could not route message with type: {}", (Object)msg.type());
        }
    }

    public void reconnect() {
        if (this.isConnected()) {
            this.disconnect();
        }
        this.connection = new WSClient(URI.create(endPoint), this::onConnected, this::onMsg);
        this.connection.setReuseAddr(true);
        this.connection.setTcpNoDelay(true);
        this.connection.setConnectionLostTimeout(5000);
        this.connection.setDaemon(true);
        disconnectWaiters = new CompletableFuture();
        this.connection.connect();
        Utils.safeSilentVoidRunner(() -> Minecraft.getInstance().player.sendSystemMessage(connectedString));
    }

    public void disconnect() {
        if (this.connection != null && this.connection.isOpen()) {
            this.connection.close(1000, "Bye");
            disconnectWaiters.complete(null);
        }
    }

    public boolean isConnected() {
        if (this.connection != null) {
            return this.connection.isOpen();
        }
        return false;
    }

    static {
        objectRouter.put("config", SettingsManager::init);
        objectRouter.put("event", EventManager.INSTANCE::onEvent);
    }

    private static class WSClient
    extends WebSocketClient {
        private final Consumer<String> onMsg;
        private Consumer<ServerHandshake> onOpen;

        public WSClient(URI serverUri, Consumer<String> msg) {
            super(serverUri);
            this.onMsg = msg;
        }

        public WSClient(URI serverUri, Consumer<ServerHandshake> onOpenListener, Consumer<String> msg) {
            super(serverUri);
            this.onOpen = onOpenListener;
            this.onMsg = msg;
        }

        @Override
        public void onOpen(ServerHandshake serverHandshake) {
            if (this.onOpen != null) {
                this.onOpen.accept(serverHandshake);
            }
        }

        @Override
        public void onMessage(String s) {
            Constants.LOG.info("Received: {}", (Object)s);
            this.onMsg.accept(s);
        }

        @Override
        public void onClose(int i, String s, boolean b) {
            Constants.LOG.info("WS closed: {} - {}", (Object)i, (Object)s);
        }

        @Override
        public void onError(Exception e) {
            Constants.LOG.error("WS error", (Throwable)e);
        }
    }
}

