/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.util.version;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.NonNull;
import su.plo.voice.libs.kotlin.text.StringsKt;

public final class SemanticVersion {
    private static final Pattern VERSION_PATTERN = Pattern.compile(".*((-)?(\\d+)\\.(\\d+)\\.(\\d+).*)");
    private final String string;
    private final int major;
    private final int minor;
    private final int patch;
    private final Branch branch;

    public static SemanticVersion parse(@NonNull String strVersion) {
        int patch;
        int minor;
        int major;
        if (strVersion == null) {
            throw new NullPointerException("strVersion is marked non-null but is null");
        }
        Matcher matcher = VERSION_PATTERN.matcher(strVersion);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Bad version. Valid format: X.X.X");
        }
        try {
            major = Integer.parseInt(matcher.group(3));
            minor = Integer.parseInt(matcher.group(4));
            patch = Integer.parseInt(matcher.group(5));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Bad version. Valid format: X.X.X", e);
        }
        if (StringsKt.endsWith(strVersion, "-SNAPSHOT", true)) {
            strVersion = strVersion.substring(0, strVersion.length() - "-SNAPSHOT".length());
        }
        return new SemanticVersion(strVersion, major, minor, patch, strVersion.contains("+") || strVersion.toLowerCase().contains("snapshot") ? Branch.ALPHA : Branch.RELEASE);
    }

    public boolean isOutdated(@NonNull SemanticVersion version) {
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        if (this.major != version.major) {
            return this.major < version.major;
        }
        if (this.minor != version.minor) {
            return this.minor < version.minor;
        }
        if (this.patch != version.patch) {
            return this.patch < version.patch;
        }
        return this.branch == Branch.ALPHA && version.branch == Branch.RELEASE;
    }

    public boolean isRelease() {
        return this.branch == Branch.RELEASE;
    }

    public int asInt() {
        return this.major * 100 + this.minor * 10 + this.patch;
    }

    public String prettyString() {
        Matcher matcher = VERSION_PATTERN.matcher(this.string);
        if (!matcher.matches()) {
            return this.string;
        }
        return matcher.group(1);
    }

    public String toString() {
        return this.prettyString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SemanticVersion)) {
            return false;
        }
        SemanticVersion version = (SemanticVersion)o;
        return this.toString().equals(version.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String string() {
        return this.string;
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int patch() {
        return this.patch;
    }

    public Branch branch() {
        return this.branch;
    }

    public SemanticVersion(String string, int major, int minor, int patch, Branch branch) {
        this.string = string;
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.branch = branch;
    }

    public static enum Branch {
        RELEASE,
        ALPHA;

    }
}

