/*
 * Decompiled with CFR 0.152.
 */
package su.plo.voice.server;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import su.plo.config.provider.ConfigurationProvider;
import su.plo.config.provider.toml.TomlConfiguration;
import su.plo.slib.api.command.McCommand;
import su.plo.slib.api.command.McCommandManager;
import su.plo.slib.api.language.ServerTranslator;
import su.plo.slib.api.permission.PermissionDefault;
import su.plo.slib.api.permission.PermissionManager;
import su.plo.slib.api.server.McServerLib;
import su.plo.slib.api.server.channel.McServerChannelManager;
import su.plo.slib.api.server.event.command.McServerCommandsRegisterEvent;
import su.plo.voice.BaseVoice;
import su.plo.voice.api.addon.ServerAddonsLoader;
import su.plo.voice.api.audio.codec.AudioDecoder;
import su.plo.voice.api.audio.codec.AudioEncoder;
import su.plo.voice.api.encryption.Encryption;
import su.plo.voice.api.server.PlasmoVoiceServer;
import su.plo.voice.api.server.audio.capture.ServerActivationManager;
import su.plo.voice.api.server.audio.line.ServerSourceLineManager;
import su.plo.voice.api.server.connection.TcpServerPacketManager;
import su.plo.voice.api.server.connection.UdpServerConnectionManager;
import su.plo.voice.api.server.event.config.VoiceServerConfigReloadedEvent;
import su.plo.voice.api.server.event.socket.UdpServerCreateEvent;
import su.plo.voice.api.server.event.socket.UdpServerStartedEvent;
import su.plo.voice.api.server.event.socket.UdpServerStoppedEvent;
import su.plo.voice.api.server.mute.MuteManager;
import su.plo.voice.api.server.mute.storage.MuteStorage;
import su.plo.voice.api.server.socket.UdpServer;
import su.plo.voice.api.server.socket.UdpServerConnection;
import su.plo.voice.proto.data.audio.codec.opus.OpusDecoderInfo;
import su.plo.voice.proto.data.audio.codec.opus.OpusEncoderInfo;
import su.plo.voice.proto.data.audio.codec.opus.OpusMode;
import su.plo.voice.server.audio.capture.ProximityServerActivation;
import su.plo.voice.server.audio.capture.VoiceServerActivationManager;
import su.plo.voice.server.audio.line.VoiceServerSourceLineManager;
import su.plo.voice.server.command.VoiceListCommand;
import su.plo.voice.server.command.VoiceMuteCommand;
import su.plo.voice.server.command.VoiceMuteListCommand;
import su.plo.voice.server.command.VoiceReconnectCommand;
import su.plo.voice.server.command.VoiceReloadCommand;
import su.plo.voice.server.command.VoiceUnmuteCommand;
import su.plo.voice.server.config.VoiceServerConfig;
import su.plo.voice.server.connection.ServerChannelHandler;
import su.plo.voice.server.connection.ServerServiceChannelHandler;
import su.plo.voice.server.connection.VoiceTcpServerConnectionManager;
import su.plo.voice.server.connection.VoiceUdpServerConnectionManager;
import su.plo.voice.server.language.VoiceServerLanguages;
import su.plo.voice.server.mute.VoiceMuteManager;
import su.plo.voice.server.mute.storage.MuteStorageFactory;
import su.plo.voice.server.player.LuckPermsListener;
import su.plo.voice.server.player.VoiceServerPlayerManagerImpl;
import su.plo.voice.server.socket.NettyUdpServer;
import su.plo.voice.util.version.ModrinthVersion;
import su.plo.voice.util.version.PlatformLoader;

public abstract class BaseVoiceServer
extends BaseVoice
implements PlasmoVoiceServer {
    public static final String CHANNEL_STRING = "plasmo:voice/v2";
    public static final String FLAG_CHANNEL_STRING = "plasmo:voice/v2/installed";
    public static final String SERVICE_CHANNEL_STRING = "plasmo:voice/v2/service";
    public static final int BSTATS_PROJECT_ID = 10928;
    protected static final ConfigurationProvider TOML = (ConfigurationProvider)ConfigurationProvider.getProvider(TomlConfiguration.class);
    protected final TcpServerPacketManager tcpPacketManager = new VoiceTcpServerConnectionManager(this);
    protected final UdpServerConnectionManager udpConnectionManager = new VoiceUdpServerConnectionManager(this);
    protected UdpServer udpServer;
    protected VoiceServerPlayerManagerImpl playerManager;
    protected ServerActivationManager activationManager;
    protected final ProximityServerActivation proximityActivation = new ProximityServerActivation(this);
    protected ServerSourceLineManager sourceLineManager;
    protected MuteStorage muteStorage;
    protected MuteManager muteManager;
    protected LuckPermsListener luckPermsListener;
    protected VoiceServerConfig config;
    protected VoiceServerLanguages languages;
    private Encryption defaultEncryption;
    private final ServerChannelHandler channelHandler = new ServerChannelHandler(this);
    private final ServerServiceChannelHandler serviceChannelHandler = new ServerServiceChannelHandler(this);

    protected BaseVoiceServer(@NotNull PlatformLoader loader) {
        super(loader);
        ServerAddonsLoader.INSTANCE.setAddonManager(this.getAddonManager());
        McServerCommandsRegisterEvent.INSTANCE.registerListener(this::registerDefaultCommandsAndPermissions);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        McServerChannelManager channelManager = this.getMinecraftServer().getChannelManager();
        channelManager.registerChannelHandler(CHANNEL_STRING, this.channelHandler);
        channelManager.registerChannelHandler(SERVICE_CHANNEL_STRING, this.serviceChannelHandler);
        this.eventBus.register(this, this.udpConnectionManager);
        this.eventBus.register(this, this.getMinecraftServer());
        this.eventBus.register(this, this.proximityActivation);
        this.playerManager = new VoiceServerPlayerManagerImpl(this, this.getMinecraftServer());
        this.playerManager.registerPermission("pv.allow_freecam");
        this.eventBus.register(this, this.playerManager);
        this.activationManager = new VoiceServerActivationManager(this, this.tcpPacketManager, activationName -> this.config.voice().weights().getActivationWeight((String)activationName));
        this.eventBus.register(this, this.activationManager);
        this.sourceLineManager = new VoiceServerSourceLineManager(this);
        MuteStorageFactory muteStorageFactory = new MuteStorageFactory(this, this.backgroundExecutor);
        this.muteStorage = muteStorageFactory.createStorage("json");
        try {
            this.muteStorage.init();
        }
        catch (Exception e) {
            LOGGER.error("Failed to initialize mute storage: {}", e.toString());
            e.printStackTrace();
            return;
        }
        this.muteManager = new VoiceMuteManager(this, this.muteStorage, this.backgroundExecutor);
        if (LuckPermsListener.Companion.hasLuckPerms()) {
            this.luckPermsListener = new LuckPermsListener(this, this.backgroundExecutor);
            this.luckPermsListener.subscribe();
            LOGGER.info("LuckPerms permissions listener attached", new Object[0]);
        }
        this.languages = new VoiceServerLanguages(this.getMinecraftServer().getServerTranslator(), true);
        this.loadConfig(false);
        this.checkForUpdates();
    }

    @Override
    protected void onShutdown() {
        if (this.luckPermsListener != null) {
            this.luckPermsListener.unsubscribe();
            this.luckPermsListener = null;
        }
        if (this.muteStorage != null) {
            try {
                this.muteStorage.close();
            }
            catch (Exception e) {
                LOGGER.error("Failed to close mute storage: {}", e.toString());
                e.printStackTrace();
            }
        }
        this.stopUdpServer();
        this.getMinecraftServer().getChannelManager().clear();
        this.sourceLineManager.clear();
        this.activationManager.clear();
        this.playerManager.clear();
        this.channelHandler.clear();
        this.config = null;
        this.eventBus.unregister(this);
        super.onShutdown();
    }

    public void loadConfig(boolean reload2) {
        boolean restartUdpServer = true;
        try {
            byte[] aesKey;
            File configFile = new File(this.getConfigFolder(), "config.toml");
            VoiceServerConfig oldConfig = this.config;
            this.config = TOML.load(VoiceServerConfig.class, configFile, false);
            TOML.save(this.config, configFile);
            if (oldConfig != null) {
                restartUdpServer = !this.config.host().equals(oldConfig.host());
            }
            ServerTranslator serverTranslator = this.getMinecraftServer().getServerTranslator();
            this.languages.setCrowdinEnabled(this.config.useCrowdinTranslations());
            this.languages.register(URI.create("https://github.com/plasmoapp/plasmo-voice-crowdin/archive/refs/heads/pv.zip").toURL(), "server.toml", this::getResource, new File(this.getConfigFolder(), "languages"));
            if (this.config.forcedLanguage() != null) {
                serverTranslator.setDefaultLanguage(this.config.forcedLanguage());
                serverTranslator.setForcedLanguage(this.config.forcedLanguage());
            } else {
                serverTranslator.setDefaultLanguage(this.config.defaultLanguage());
                serverTranslator.setForcedLanguage(null);
            }
            File forwardingSecretFile = System.getenv().containsKey("PLASMO_VOICE_FORWARDING_SECRET_FILE") ? new File(System.getenv("PLASMO_VOICE_FORWARDING_SECRET_FILE")) : new File(this.getConfigFolder(), "forwarding-secret");
            try {
                UUID forwardingSecret;
                if (System.getenv("PLASMO_VOICE_FORWARDING_SECRET") != null) {
                    forwardingSecret = UUID.fromString(System.getenv("PLASMO_VOICE_FORWARDING_SECRET"));
                    this.config.host().forwardingSecret(forwardingSecret);
                } else if (forwardingSecretFile.exists()) {
                    forwardingSecret = UUID.fromString(new String(Files.readAllBytes(forwardingSecretFile.toPath())));
                    this.config.host().forwardingSecret(forwardingSecret);
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to read secret", e);
            }
            if (System.getenv("PLASMO_VOICE_SERVER_ID") != null) {
                this.config.serverId(System.getenv("PLASMO_VOICE_SERVER_ID"));
            }
            try {
                UUID.fromString(this.config.serverId());
            }
            catch (IllegalArgumentException ignored) {
                this.config.serverId(UUID.randomUUID().toString());
            }
            if (oldConfig != null && oldConfig.voice().aesEncryptionKey() != null) {
                aesKey = oldConfig.voice().aesEncryptionKey();
            } else {
                UUID aesEncryptionKey = UUID.randomUUID();
                ByteArrayDataOutput out = ByteStreams.newDataOutput();
                out.writeLong(aesEncryptionKey.getMostSignificantBits());
                out.writeLong(aesEncryptionKey.getLeastSignificantBits());
                aesKey = out.toByteArray();
            }
            this.updateAesEncryptionKey(aesKey);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load config", e);
        }
        DEBUG_LOGGER.enabled(this.config.debug() || System.getProperty("plasmovoice.debug") != null);
        this.proximityActivation.register(this.config);
        if (reload2) {
            this.eventBus.fire(new VoiceServerConfigReloadedEvent(this, this.config));
        } else {
            this.addons.initializeLoadedAddons();
        }
        if (restartUdpServer) {
            this.startUdpServer();
        }
    }

    public synchronized void updateAesEncryptionKey(byte[] aesKey) {
        this.config.voice().aesEncryptionKey(aesKey);
        if (this.defaultEncryption == null) {
            this.defaultEncryption = this.encryption.create("AES/CBC/PKCS5Padding", aesKey);
        } else if (this.defaultEncryption.getName().equals("AES/CBC/PKCS5Padding")) {
            this.defaultEncryption.updateKeyData(aesKey);
        }
    }

    public void startUdpServer() {
        Collection connectedPlayers = null;
        if (this.udpServer != null) {
            connectedPlayers = this.udpConnectionManager.getConnections().stream().map(UdpServerConnection::getPlayer).collect(Collectors.toList());
            this.stopUdpServer();
        }
        UdpServer server = new NettyUdpServer(this);
        UdpServerCreateEvent createUdpServerEvent = new UdpServerCreateEvent(server);
        this.eventBus.fire(createUdpServerEvent);
        server = createUdpServerEvent.getServer();
        try {
            int port = this.config.host().port();
            if (port == 0 && (port = this.getMinecraftServer().getPort()) <= 0) {
                port = 0;
            }
            server.start(this.config.host().ip(), port);
            this.udpServer = server;
            this.eventBus.fire(new UdpServerStartedEvent(server));
            if (connectedPlayers != null) {
                connectedPlayers.forEach(this.tcpPacketManager::requestPlayerInfo);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to start the udp server", e);
        }
    }

    private void stopUdpServer() {
        if (this.udpServer != null) {
            this.udpServer.stop();
            this.eventBus.fire(new UdpServerStoppedEvent(this.udpServer));
            this.udpServer = null;
        }
    }

    private void checkForUpdates() {
        if (this.config.checkForUpdates()) {
            this.backgroundExecutor.execute(() -> {
                try {
                    ModrinthVersion.checkForUpdates(this.getVersion(), this.getMinecraftServer().getVersion(), this.loader).ifPresent(version -> LOGGER.warn("New version available {}: {}", version.version(), version.downloadLink()));
                }
                catch (IOException e) {
                    LOGGER.error("Failed to check for updates", e);
                }
            });
        }
    }

    protected void registerDefaultCommandsAndPermissions(@NotNull McCommandManager<McCommand> commandManager, @NotNull McServerLib minecraftServer) {
        PermissionManager permissions = minecraftServer.getPermissionManager();
        permissions.register("pv.list", PermissionDefault.TRUE);
        permissions.register("pv.reconnect", PermissionDefault.TRUE);
        permissions.register("pv.allow_freecam", PermissionDefault.TRUE);
        commandManager.register("vlist", new VoiceListCommand(this), new String[0]);
        commandManager.register("vrc", new VoiceReconnectCommand(this), new String[0]);
        commandManager.register("vreload", new VoiceReloadCommand(this), new String[0]);
        commandManager.register("vmute", new VoiceMuteCommand(this, this.getMinecraftServer()), new String[0]);
        commandManager.register("vunmute", new VoiceUnmuteCommand(this, this.getMinecraftServer()), new String[0]);
        commandManager.register("vmutelist", new VoiceMuteListCommand(this, this.getMinecraftServer()), new String[0]);
    }

    @Override
    public Optional<UdpServer> getUdpServer() {
        return Optional.ofNullable(this.udpServer);
    }

    @Override
    @NotNull
    public AudioEncoder createOpusEncoder(boolean stereo) {
        if (this.config == null) {
            throw new IllegalStateException("server is not initialized yet");
        }
        int sampleRate = this.config.voice().sampleRate();
        return this.codecs.createEncoder(new OpusEncoderInfo(OpusMode.valueOf(this.config.voice().opus().mode()), this.config.voice().opus().bitrate()), sampleRate, stereo, this.config.voice().mtuSize());
    }

    @Override
    @NotNull
    public AudioDecoder createOpusDecoder(boolean stereo) {
        if (this.config == null) {
            throw new IllegalStateException("server is not initialized yet");
        }
        int sampleRate = this.config.voice().sampleRate();
        return this.codecs.createDecoder(new OpusDecoderInfo(), sampleRate, stereo, sampleRate / 1000 * 20);
    }

    @Override
    public TcpServerPacketManager getTcpPacketManager() {
        return this.tcpPacketManager;
    }

    @Override
    public UdpServerConnectionManager getUdpConnectionManager() {
        return this.udpConnectionManager;
    }

    @Override
    public VoiceServerPlayerManagerImpl getPlayerManager() {
        return this.playerManager;
    }

    @Override
    public ServerActivationManager getActivationManager() {
        return this.activationManager;
    }

    @Override
    public ServerSourceLineManager getSourceLineManager() {
        return this.sourceLineManager;
    }

    public MuteStorage getMuteStorage() {
        return this.muteStorage;
    }

    @Override
    public MuteManager getMuteManager() {
        return this.muteManager;
    }

    @Override
    public VoiceServerConfig getConfig() {
        return this.config;
    }

    @Override
    public VoiceServerLanguages getLanguages() {
        return this.languages;
    }

    @Override
    public Encryption getDefaultEncryption() {
        return this.defaultEncryption;
    }
}

