/*
 * Decompiled with CFR 0.152.
 */
package su.plo.slib.libs.adventure.adventure.text;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.slib.libs.adventure.adventure.text.Component;
import su.plo.slib.libs.adventure.adventure.text.ComponentLike;
import su.plo.slib.libs.adventure.adventure.text.PatternReplacementResult;
import su.plo.slib.libs.adventure.adventure.text.TextComponent;
import su.plo.slib.libs.adventure.adventure.text.TextReplacementConfig;
import su.plo.slib.libs.adventure.adventure.text.TranslatableComponent;
import su.plo.slib.libs.adventure.adventure.text.TranslationArgument;
import su.plo.slib.libs.adventure.adventure.text.event.HoverEvent;
import su.plo.slib.libs.adventure.adventure.text.event.HoverEventSource;
import su.plo.slib.libs.adventure.adventure.text.format.Style;
import su.plo.slib.libs.adventure.adventure.text.format.StyleSetter;
import su.plo.slib.libs.adventure.adventure.text.renderer.ComponentRenderer;

final class TextReplacementRenderer
implements ComponentRenderer<State> {
    static final TextReplacementRenderer INSTANCE = new TextReplacementRenderer();

    private TextReplacementRenderer() {
    }

    @Override
    @NotNull
    public Component render(@NotNull Component component, @NotNull State state) {
        if (!state.running) {
            return component;
        }
        boolean prevFirstMatch = state.firstMatch;
        state.firstMatch = true;
        List<Component> oldChildren = component.children();
        int oldChildrenSize = oldChildren.size();
        StyleSetter<Style> oldStyle = component.style();
        ArrayList<TextComponent> children2 = null;
        Component modified = component;
        if (component instanceof TextComponent) {
            String content = ((TextComponent)component).content();
            Matcher matcher = state.pattern.matcher(content);
            int replacedUntil = 0;
            while (matcher.find()) {
                PatternReplacementResult result2;
                if ((result2 = state.continuer.shouldReplace(matcher, ++state.matchCount, state.replaceCount)) == PatternReplacementResult.CONTINUE) continue;
                if (result2 == PatternReplacementResult.STOP) {
                    state.running = false;
                    break;
                }
                if (matcher.start() == 0) {
                    if (matcher.end() == content.length()) {
                        ComponentLike replacement = state.replacement.apply(matcher, (TextComponent.Builder)Component.text().content(matcher.group()).style(component.style()));
                        Component component2 = modified = replacement == null ? Component.empty() : replacement.asComponent();
                        if (modified.style().hoverEvent() != null) {
                            oldStyle = oldStyle.hoverEvent((HoverEventSource)null);
                        }
                        modified = modified.style(modified.style().merge(component.style(), Style.Merge.Strategy.IF_ABSENT_ON_TARGET));
                        if (children2 == null) {
                            children2 = new ArrayList(oldChildrenSize + modified.children().size());
                            children2.addAll(modified.children());
                        }
                    } else {
                        modified = Component.text("", component.style());
                        ComponentLike child = state.replacement.apply(matcher, Component.text().content(matcher.group()));
                        if (child != null) {
                            if (children2 == null) {
                                children2 = new ArrayList(oldChildrenSize + 1);
                            }
                            children2.add((TextComponent)child.asComponent());
                        }
                    }
                } else {
                    if (children2 == null) {
                        children2 = new ArrayList(oldChildrenSize + 2);
                    }
                    if (state.firstMatch) {
                        modified = ((TextComponent)component).content(content.substring(0, matcher.start()));
                    } else if (replacedUntil < matcher.start()) {
                        children2.add(Component.text(content.substring(replacedUntil, matcher.start())));
                    }
                    ComponentLike builder = state.replacement.apply(matcher, Component.text().content(matcher.group()));
                    if (builder != null) {
                        children2.add((TextComponent)builder.asComponent());
                    }
                }
                ++state.replaceCount;
                state.firstMatch = false;
                replacedUntil = matcher.end();
            }
            if (replacedUntil < content.length() && replacedUntil > 0) {
                if (children2 == null) {
                    children2 = new ArrayList<TextComponent>(oldChildrenSize);
                }
                children2.add(Component.text(content.substring(replacedUntil)));
            }
        } else if (modified instanceof TranslatableComponent) {
            List<TranslationArgument> args2 = ((TranslatableComponent)modified).arguments();
            ArrayList<TranslationArgument> newArgs = null;
            int size = args2.size();
            for (int i = 0; i < size; ++i) {
                TranslationArgument replaced;
                TranslationArgument original = args2.get(i);
                TranslationArgument translationArgument = replaced = original.value() instanceof Component ? TranslationArgument.component(this.render((Component)original.value(), state)) : original;
                if (replaced != original && newArgs == null) {
                    newArgs = new ArrayList<TranslationArgument>(size);
                    if (i > 0) {
                        newArgs.addAll(args2.subList(0, i));
                    }
                }
                if (newArgs == null) continue;
                newArgs.add(replaced);
            }
            if (newArgs != null) {
                modified = ((TranslatableComponent)modified).arguments(newArgs);
            }
        }
        if (state.running) {
            HoverEvent<?> rendered;
            HoverEvent<?> event;
            if (state.replaceInsideHoverEvents && (event = oldStyle.hoverEvent()) != null && event != (rendered = event.withRenderedValue(this, state))) {
                modified = modified.style(s -> s.hoverEvent(rendered));
            }
            boolean first2 = true;
            for (int i = 0; i < oldChildrenSize; ++i) {
                Component child = oldChildren.get(i);
                Component replaced = this.render(child, state);
                if (replaced != child) {
                    if (children2 == null) {
                        children2 = new ArrayList(oldChildrenSize);
                    }
                    if (first2) {
                        children2.addAll(oldChildren.subList(0, i));
                    }
                    first2 = false;
                }
                if (children2 == null) continue;
                children2.add((TextComponent)replaced);
                first2 = false;
            }
        } else if (children2 != null) {
            children2.addAll(oldChildren);
        }
        state.firstMatch = prevFirstMatch;
        if (children2 != null) {
            return modified.children((List<? extends ComponentLike>)children2);
        }
        return modified;
    }

    static final class State {
        final Pattern pattern;
        final BiFunction<MatchResult, TextComponent.Builder, @Nullable ComponentLike> replacement;
        final TextReplacementConfig.Condition continuer;
        final boolean replaceInsideHoverEvents;
        boolean running = true;
        int matchCount = 0;
        int replaceCount = 0;
        boolean firstMatch = true;

        State(@NotNull Pattern pattern, @NotNull BiFunction<MatchResult, TextComponent.Builder, @Nullable ComponentLike> replacement, @NotNull TextReplacementConfig.Condition continuer, boolean replaceInsideHoverEvents) {
            this.pattern = pattern;
            this.replacement = replacement;
            this.continuer = continuer;
            this.replaceInsideHoverEvents = replaceInsideHoverEvents;
        }
    }
}

