/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.render.particle;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import su.plo.lib.mod.client.render.particle.SpriteBillboardParticle2D;

public class BlockDustParticle2D
extends SpriteBillboardParticle2D {
    private final float sampleU;
    private final float sampleV;

    public BlockDustParticle2D(double x, double y, double velocityX, double velocityY, BlockState state) {
        super(x, y, velocityX, velocityY);
        Minecraft client = Minecraft.getInstance();
        this.setSprite(client.getBlockRenderer().getBlockModelShaper().getParticleIcon(state));
        this.gravityStrength = 1.0f;
        this.colorRed = 0.8f;
        this.colorGreen = 0.8f;
        this.colorBlue = 0.8f;
        if (!state.is(Blocks.GRASS_BLOCK)) {
            int i = state.getMapColor((BlockGetter)client.level, (BlockPos)client.player.blockPosition()).col;
            this.colorRed *= (float)(i >> 16 & 0xFF) / 255.0f;
            this.colorGreen *= (float)(i >> 8 & 0xFF) / 255.0f;
            this.colorBlue *= (float)(i & 0xFF) / 255.0f;
        }
        this.sampleU = this.random.nextFloat() * 3.0f;
        this.sampleV = this.random.nextFloat() * 3.0f;
    }

    public void setGravityStrength(float gravityStrength) {
        this.gravityStrength = gravityStrength;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    @Override
    protected float getMinU() {
        return this.sprite.getU((this.sampleU + 1.0f) / 4.0f);
    }

    @Override
    protected float getMaxU() {
        return this.sprite.getU(this.sampleU / 4.0f);
    }

    @Override
    protected float getMinV() {
        return this.sprite.getV(this.sampleV / 4.0f);
    }

    @Override
    protected float getMaxV() {
        return this.sprite.getV((this.sampleV + 1.0f) / 4.0f);
    }

    @Override
    public int getBrightness(float tint) {
        return 15;
    }
}

