/*
 * Decompiled with CFR 0.152.
 */
package su.plo.lib.mod.client.gui.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.plo.lib.mod.client.Inputs;
import su.plo.lib.mod.client.gui.screen.GuiScreen;
import su.plo.lib.mod.client.render.RenderUtil;
import su.plo.lib.mod.client.render.gui.GuiRenderContext;
import su.plo.slib.api.chat.component.McTextComponent;
import su.plo.voice.client.ModVoiceClient;

public final class ScreenWrapper
extends Screen {
    private final GuiScreen screen;
    private boolean ignoreFirstMove = true;
    @Nullable
    private GuiGraphics currentContext;
    private int lastMouseX;
    private int lastMouseY;
    private float lastPartialTicks;

    public static void openScreen(@Nullable GuiScreen screen) {
        ScreenWrapper wrapped;
        if (screen == null) {
            Minecraft.getInstance().execute(() -> Minecraft.getInstance().setScreen(null));
            return;
        }
        wrapped.screen.screen = wrapped = new ScreenWrapper(screen);
        Minecraft.getInstance().execute(() -> Minecraft.getInstance().setScreen((Screen)wrapped));
    }

    public static Optional<ScreenWrapper> getCurrentWrappedScreen() {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof ScreenWrapper) {
            return Optional.of((ScreenWrapper)screen);
        }
        return Optional.empty();
    }

    private ScreenWrapper(@NotNull GuiScreen screen) {
        super(RenderUtil.getTextConverter().convert(screen.getTitle()));
        this.screen = screen;
    }

    @NotNull
    public Component getTitle() {
        if (this.screen == null) {
            return super.getTitle();
        }
        return RenderUtil.getTextConverter().convert(this.screen.getTitle());
    }

    public void tick() {
        this.screen.tick();
    }

    protected void init() {
        this.screen.init();
        ModVoiceClient.INSTANCE.getEventBus().unregister((Object)ModVoiceClient.INSTANCE, (Object)this);
        ModVoiceClient.INSTANCE.getEventBus().register(ModVoiceClient.INSTANCE, (Object)this);
    }

    public void removed() {
        ModVoiceClient.INSTANCE.getEventBus().unregister((Object)ModVoiceClient.INSTANCE, (Object)this);
        this.screen.removed();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        RenderUtil.preserveGlState();
        this.currentContext = guiGraphics;
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        this.lastPartialTicks = partialTicks;
        GuiRenderContext context = new GuiRenderContext(guiGraphics);
        this.screen.render(context, mouseX, mouseY, partialTicks);
        this.currentContext = null;
        RenderUtil.restoreGlState();
    }

    public void renderBackground(@NotNull GuiRenderContext context) {
        if (this.currentContext == null) {
            return;
        }
        super.renderBackground(this.currentContext, this.lastMouseX, this.lastMouseY, this.lastPartialTicks);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        this.screen.mouseClicked(mouseX, mouseY, mouseButton);
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.screen.mouseReleased(mouseX, mouseY, button);
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        this.screen.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double delta) {
        this.screen.mouseScrolled(mouseX, mouseY, delta);
        return false;
    }

    public boolean charTyped(char typedChar, int modifiers) {
        return this.screen.charTyped(typedChar, modifiers);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return this.innerKeyPressed(keyCode, scanCode, modifiers);
    }

    private boolean innerKeyPressed(int keyCode, int scanCode, int modifiers) {
        boolean shiftKeyDown;
        if (keyCode == 0) {
            return false;
        }
        if (this.screen.keyPressed(keyCode, modifiers)) {
            return true;
        }
        if (this.shouldCloseOnEsc() && keyCode == 256) {
            this.onClose();
            return true;
        }
        if (keyCode == 258 && !this.screen.changeFocus(shiftKeyDown = Inputs.hasShiftDown())) {
            this.screen.changeFocus(shiftKeyDown);
        }
        return false;
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (this.screen.keyReleased(keyCode, '\u0000', modifiers)) {
            return false;
        }
        super.keyReleased(keyCode, 0, modifiers);
        return false;
    }

    public boolean shouldCloseOnEsc() {
        return this.screen.shouldCloseOnEsc();
    }

    public void onClose() {
        Minecraft.getInstance().execute(() -> Minecraft.getInstance().setScreen(null));
    }

    public void renderTooltipWrapped(@NotNull GuiRenderContext context, @NotNull List<McTextComponent> tooltip, int mouseX, int mouseY) {
        this.setTooltipForNextRenderPass(Language.getInstance().getVisualOrder(new ArrayList(RenderUtil.getTextConverter().convert(tooltip))));
    }

    public String toString() {
        return "ScreenWrapper(screen=" + String.valueOf(this.getScreen()) + ", ignoreFirstMove=" + this.ignoreFirstMove + ", currentContext=" + String.valueOf(this.currentContext) + ", lastMouseX=" + this.lastMouseX + ", lastMouseY=" + this.lastMouseY + ", lastPartialTicks=" + this.lastPartialTicks + ")";
    }

    public GuiScreen getScreen() {
        return this.screen;
    }
}

