/*
 * Decompiled with CFR 0.152.
 */
package pigcart.particlerain.particle;

import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import pigcart.particlerain.VersionUtil;
import pigcart.particlerain.WeatherParticleManager;
import pigcart.particlerain.config.ConfigData;
import pigcart.particlerain.config.ConfigManager;

public abstract class WeatherParticle
extends TextureSheetParticle {
    protected BlockPos.MutableBlockPos pos;
    protected BlockPos.MutableBlockPos oPos;
    boolean doCollisionAnim = false;
    float baseTemp;
    float targetOpacity;
    float oQuadSize;
    float distance;

    protected WeatherParticle(ClientLevel level, double x, double y, double z, TextureAtlasSprite sprite) {
        super(level, x, y, z);
        this.setSprite(sprite);
        this.hasPhysics = false;
        this.setSize(this.quadSize, this.quadSize);
        this.lifetime = ConfigManager.config.perf.particleDistance * 100;
        this.pos = new BlockPos.MutableBlockPos(x, y, z);
        this.oPos = new BlockPos.MutableBlockPos(x, y, z);
        this.baseTemp = ((Biome)level.getBiome((BlockPos)this.pos).value()).getBaseTemperature();
        ++WeatherParticleManager.particleCount;
    }

    public void remove() {
        if (this.isAlive()) {
            --WeatherParticleManager.particleCount;
        }
        super.remove();
    }

    public ParticleRenderType getRenderType() {
        return ConfigData.RenderType.TRANSLUCENT.get();
    }

    public void tick() {
        super.tick();
        this.oQuadSize = this.quadSize;
        this.distance = (float)VersionUtil.camPos(Minecraft.getInstance().gameRenderer.getMainCamera()).distanceTo(new Vec3(this.x, this.y, this.z));
        this.pos.set(this.x, this.y, this.z);
        if (!this.pos.equals((Object)this.oPos)) {
            this.onPositionUpdate();
            this.oPos.set((Vec3i)this.pos);
        }
        if (this.doCollisionAnim) {
            this.tickCollisionAnim();
        }
        this.tickDistanceFade();
    }

    public void onPositionUpdate() {
        if (!ConfigManager.config.compat.crossBiomeBorder && (double)Mth.abs((float)(((Biome)this.level.getBiome((BlockPos)this.pos).value()).getBaseTemperature() - this.baseTemp)) > 0.4) {
            this.doCollisionAnim = true;
        }
        if (this.level.getBlockState((BlockPos)this.pos).isCollisionShapeFullBlock((BlockGetter)this.level, (BlockPos)this.pos) || !this.level.getFluidState((BlockPos)this.pos).isEmpty()) {
            this.remove();
        }
    }

    public void tickDistanceFade() {
        float renderDistance = ConfigManager.config.perf.particleDistance;
        if (this.distance > renderDistance) {
            this.remove();
        } else {
            this.alpha = Mth.lerp((float)(this.distance / renderDistance), (float)this.targetOpacity, (float)0.0f);
        }
    }

    public float getQuadSize(float scaleFactor) {
        return Mth.lerp((float)scaleFactor, (float)this.oQuadSize, (float)this.quadSize);
    }

    public void tickCollisionAnim() {
        float deltaMovement = (float)new Vec3(this.xd, this.yd, this.zd).length();
        this.quadSize -= deltaMovement;
        if (this.quadSize <= 0.0f) {
            this.remove();
        }
    }

    public Quaternionf turnBackfaceFlipways(Quaternionf quaternion, Vector3f cameraOffset) {
        Vector3f normal = new Vector3f(0.0f, 0.0f, 1.0f);
        normal.rotate((Quaternionfc)quaternion).normalize();
        float dot = normal.dot((Vector3fc)cameraOffset);
        if (dot > 0.0f) {
            return quaternion.mul((Quaternionfc)Axis.YP.rotation((float)Math.PI));
        }
        return quaternion;
    }
}

