/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.inventory.sorting.mixin;

import com.nemonotfound.nemos.inventory.sorting.Constants;
import com.nemonotfound.nemos.inventory.sorting.client.ModKeyMappings;
import com.nemonotfound.nemos.inventory.sorting.client.config.ComponentConfig;
import com.nemonotfound.nemos.inventory.sorting.client.config.ConfigUtil;
import com.nemonotfound.nemos.inventory.sorting.client.gui.components.AbstractSortButton;
import com.nemonotfound.nemos.inventory.sorting.factory.ButtonCreator;
import com.nemonotfound.nemos.inventory.sorting.factory.DropAllButtonFactory;
import com.nemonotfound.nemos.inventory.sorting.factory.MoveAllButtonFactory;
import com.nemonotfound.nemos.inventory.sorting.factory.MoveSameButtonFactory;
import com.nemonotfound.nemos.inventory.sorting.factory.SortAlphabeticallyButtonFactory;
import com.nemonotfound.nemos.inventory.sorting.factory.SortAlphabeticallyDescendingButtonFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.ShulkerBoxScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ShulkerBoxMenu;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={ShulkerBoxScreen.class})
public abstract class ShulkerBoxScreenMixin
extends AbstractContainerScreen<ShulkerBoxMenu> {
    @Unique
    private final Map<KeyMapping, AbstractSortButton> nemosInventorySorting$keyMappingButtonMap = new HashMap<KeyMapping, AbstractSortButton>();

    public ShulkerBoxScreenMixin(ShulkerBoxMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    public void init() {
        super.init();
        int yOffsetInventory = 71;
        SortAlphabeticallyButtonFactory sortAlphabeticallyButtonFactory = SortAlphabeticallyButtonFactory.getInstance();
        SortAlphabeticallyDescendingButtonFactory sortAlphabeticallyDescendingButtonFactory = SortAlphabeticallyDescendingButtonFactory.getInstance();
        DropAllButtonFactory dropAllButtonFactory = DropAllButtonFactory.getInstance();
        MoveSameButtonFactory moveSameButtonFactory = MoveSameButtonFactory.getInstance();
        MoveAllButtonFactory moveAllButtonFactory = MoveAllButtonFactory.getInstance();
        List<ComponentConfig> configs = ConfigUtil.readConfigs();
        this.nemosInventorySorting$createContainerButton(configs, Constants.SORT_ALPHABETICALLY_CONTAINER, ModKeyMappings.SORT_ALPHABETICALLY.get(), sortAlphabeticallyButtonFactory, Constants.X_OFFSET_SORT_ALPHABETICALLY_CONTAINER, Constants.Y_OFFSET_CONTAINER, Constants.BUTTON_SIZE, Constants.BUTTON_SIZE);
        this.nemosInventorySorting$createContainerButton(configs, Constants.SORT_ALPHABETICALLY_DESCENDING_CONTAINER, ModKeyMappings.SORT_ALPHABETICALLY_DESCENDING.get(), sortAlphabeticallyDescendingButtonFactory, Constants.X_OFFSET_SORT_ALPHABETICALLY_DESCENDING_CONTAINER, Constants.Y_OFFSET_CONTAINER, Constants.BUTTON_SIZE, Constants.BUTTON_SIZE);
        this.nemosInventorySorting$createContainerButton(configs, Constants.MOVE_SAME_CONTAINER, ModKeyMappings.MOVE_SAME.get(), moveSameButtonFactory, Constants.X_OFFSET_MOVE_SAME_CONTAINER, Constants.Y_OFFSET_CONTAINER, Constants.BUTTON_SIZE, Constants.BUTTON_SIZE);
        this.nemosInventorySorting$createContainerButton(configs, Constants.MOVE_ALL_CONTAINER, ModKeyMappings.MOVE_ALL.get(), moveAllButtonFactory, Constants.X_OFFSET_MOVE_ALL_CONTAINER, Constants.Y_OFFSET_CONTAINER, Constants.BUTTON_SIZE, Constants.BUTTON_SIZE);
        this.nemosInventorySorting$createContainerButton(configs, Constants.DROP_ALL_CONTAINER, ModKeyMappings.DROP_ALL.get(), dropAllButtonFactory, Constants.X_OFFSET_DROP_ALL_CONTAINER, Constants.Y_OFFSET_CONTAINER, Constants.BUTTON_SIZE, Constants.BUTTON_SIZE);
        this.nemosInventorySorting$createInventoryButton(configs, Constants.SORT_ALPHABETICALLY_CONTAINER_INVENTORY, ModKeyMappings.SORT_ALPHABETICALLY_INVENTORY.get(), sortAlphabeticallyButtonFactory, Constants.X_OFFSET_SORT_ALPHABETICALLY_CONTAINER, yOffsetInventory, Constants.BUTTON_SIZE, Constants.BUTTON_SIZE);
        this.nemosInventorySorting$createInventoryButton(configs, Constants.SORT_ALPHABETICALLY_DESCENDING_CONTAINER_INVENTORY, ModKeyMappings.SORT_ALPHABETICALLY_DESCENDING_INVENTORY.get(), sortAlphabeticallyDescendingButtonFactory, Constants.X_OFFSET_SORT_ALPHABETICALLY_DESCENDING_CONTAINER, yOffsetInventory, Constants.BUTTON_SIZE, Constants.BUTTON_SIZE);
        this.nemosInventorySorting$createInventoryButton(configs, Constants.MOVE_SAME_CONTAINER_INVENTORY, ModKeyMappings.MOVE_SAME_INVENTORY.get(), moveSameButtonFactory, Constants.X_OFFSET_MOVE_SAME_CONTAINER, yOffsetInventory, Constants.BUTTON_SIZE, Constants.BUTTON_SIZE);
        this.nemosInventorySorting$createInventoryButton(configs, Constants.MOVE_ALL_CONTAINER_INVENTORY, ModKeyMappings.MOVE_ALL_INVENTORY.get(), moveAllButtonFactory, Constants.X_OFFSET_MOVE_ALL_CONTAINER, yOffsetInventory, Constants.BUTTON_SIZE, Constants.BUTTON_SIZE);
        this.nemosInventorySorting$createInventoryButton(configs, Constants.DROP_ALL_CONTAINER_INVENTORY, ModKeyMappings.DROP_ALL_INVENTORY.get(), dropAllButtonFactory, Constants.X_OFFSET_DROP_ALL_CONTAINER, yOffsetInventory, Constants.BUTTON_SIZE, Constants.BUTTON_SIZE);
        for (AbstractSortButton button : this.nemosInventorySorting$keyMappingButtonMap.values()) {
            this.addRenderableWidget((GuiEventListener)button);
        }
    }

    @Unique
    private void nemosInventorySorting$createInventoryButton(List<ComponentConfig> configs, String componentName, KeyMapping keyMapping, ButtonCreator buttonCreator, int defaultXOffset, int defaultYOffset, int defaultWidth, int defaultHeight) {
        int startIndex = 27;
        int endIndex = 54;
        this.nemosInventorySorting$createButton(configs, componentName, keyMapping, buttonCreator, startIndex, endIndex, defaultXOffset, defaultYOffset, defaultWidth, defaultHeight);
    }

    @Unique
    private void nemosInventorySorting$createContainerButton(List<ComponentConfig> configs, String componentName, KeyMapping keyMapping, ButtonCreator buttonCreator, int defaultXOffset, int defaultYOffset, int defaultWidth, int defaultHeight) {
        int startIndex = 0;
        int endIndex = 27;
        this.nemosInventorySorting$createButton(configs, componentName, keyMapping, buttonCreator, startIndex, endIndex, defaultXOffset, defaultYOffset, defaultWidth, defaultHeight);
    }

    @Unique
    private void nemosInventorySorting$createButton(List<ComponentConfig> configs, String componentName, KeyMapping keyMapping, ButtonCreator buttonCreator, int startIndex, int endIndex, int defaultXOffset, int defaultYOffset, int defaultWidth, int defaultHeight) {
        Optional<ComponentConfig> optionalComponentConfig = ConfigUtil.getConfigs(configs, componentName);
        if (optionalComponentConfig.isEmpty()) {
            this.nemosInventorySorting$createButton(keyMapping, buttonCreator, startIndex, endIndex, defaultXOffset, defaultYOffset, defaultWidth, defaultHeight);
            return;
        }
        ComponentConfig config = optionalComponentConfig.get();
        if (!config.isEnabled()) {
            return;
        }
        int yOffset = config.yOffset() != null ? config.yOffset() : defaultYOffset;
        this.nemosInventorySorting$createButton(keyMapping, buttonCreator, startIndex, endIndex, config.xOffset(), yOffset, config.width(), config.height());
    }

    @Unique
    private void nemosInventorySorting$createButton(KeyMapping keyMapping, ButtonCreator buttonCreator, int startIndex, int endIndex, int xOffset, int yOffset, int width, int height) {
        AbstractSortButton sortButton = buttonCreator.createButton(startIndex, endIndex, this.leftPos, this.topPos, xOffset, yOffset, width, height, this);
        this.nemosInventorySorting$keyMappingButtonMap.put(keyMapping, sortButton);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        Optional<Map.Entry> optionalButtonEntry = this.nemosInventorySorting$keyMappingButtonMap.entrySet().stream().filter(entry -> ((KeyMapping)entry.getKey()).matches(keyCode, scanCode)).findFirst();
        if (keyCode == 340) {
            this.nemosInventorySorting$updateToolTips(true);
        } else {
            optionalButtonEntry.ifPresent(entry -> {
                AbstractSortButton button = (AbstractSortButton)((Object)((Object)entry.getValue()));
                button.playDownSound(Minecraft.getInstance().getSoundManager());
                button.onClick(0.0, 0.0);
            });
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340) {
            this.nemosInventorySorting$updateToolTips(false);
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Optional<Map.Entry> optionalButtonEntry = this.nemosInventorySorting$keyMappingButtonMap.entrySet().stream().filter(entry -> ((KeyMapping)entry.getKey()).matchesMouse(button)).findFirst();
        optionalButtonEntry.ifPresent(entry -> {
            AbstractSortButton sortButton = (AbstractSortButton)((Object)((Object)entry.getValue()));
            sortButton.playDownSound(Minecraft.getInstance().getSoundManager());
            sortButton.onClick(0.0, 0.0);
        });
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Unique
    private void nemosInventorySorting$updateToolTips(boolean isShiftDown) {
        for (AbstractSortButton button : this.nemosInventorySorting$keyMappingButtonMap.values()) {
            button.setIsShiftKeyDown(isShiftDown);
            button.setTooltip(this.getMenu());
        }
    }
}

