/*
 * Decompiled with CFR 0.152.
 */
package com.nemonotfound.nemos.inventory.sorting.mixin;

import com.nemonotfound.nemos.inventory.sorting.Constants;
import com.nemonotfound.nemos.inventory.sorting.client.ModKeyMappings;
import com.nemonotfound.nemos.inventory.sorting.client.config.ComponentConfig;
import com.nemonotfound.nemos.inventory.sorting.client.config.ConfigUtil;
import com.nemonotfound.nemos.inventory.sorting.client.gui.components.AbstractSortButton;
import com.nemonotfound.nemos.inventory.sorting.factory.ButtonCreator;
import com.nemonotfound.nemos.inventory.sorting.factory.DropAllButtonFactory;
import com.nemonotfound.nemos.inventory.sorting.factory.SortAlphabeticallyButtonFactory;
import com.nemonotfound.nemos.inventory.sorting.factory.SortAlphabeticallyDescendingButtonFactory;
import com.nemonotfound.nemos.inventory.sorting.interfaces.GuiPosition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={InventoryScreen.class})
public abstract class InventoryScreenMixin
extends EffectRenderingInventoryScreen<InventoryMenu>
implements GuiPosition {
    @Unique
    private final Map<KeyMapping, AbstractSortButton> nemosInventorySorting$keyMappingButtonMap = new HashMap<KeyMapping, AbstractSortButton>();

    public InventoryScreenMixin(InventoryMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    @Inject(method={"init"}, at={@At(value="RETURN")})
    public void init(CallbackInfo ci) {
        SortAlphabeticallyButtonFactory sortAlphabeticallyButtonFactory = SortAlphabeticallyButtonFactory.getInstance();
        SortAlphabeticallyDescendingButtonFactory sortAlphabeticallyDescendingButtonFactory = SortAlphabeticallyDescendingButtonFactory.getInstance();
        DropAllButtonFactory dropAllButtonFactory = DropAllButtonFactory.getInstance();
        List<ComponentConfig> configs = ConfigUtil.readConfigs();
        this.nemosInventorySorting$createButton(configs, Constants.SORT_ALPHABETICALLY_DESCENDING_INVENTORY, ModKeyMappings.SORT_ALPHABETICALLY_DESCENDING_INVENTORY.get(), sortAlphabeticallyDescendingButtonFactory, Constants.X_OFFSET_SORT_ALPHABETICALLY_DESCENDING_INVENTORY, Constants.Y_OFFSET_INVENTORY, Constants.BUTTON_SIZE, Constants.BUTTON_SIZE);
        this.nemosInventorySorting$createButton(configs, Constants.SORT_ALPHABETICALLY_INVENTORY, ModKeyMappings.SORT_ALPHABETICALLY_INVENTORY.get(), sortAlphabeticallyButtonFactory, Constants.X_OFFSET_SORT_ALPHABETICALLY_INVENTORY, Constants.Y_OFFSET_INVENTORY, Constants.BUTTON_SIZE, Constants.BUTTON_SIZE);
        this.nemosInventorySorting$createButton(configs, Constants.DROP_ALL_INVENTORY, ModKeyMappings.DROP_ALL_INVENTORY.get(), dropAllButtonFactory, Constants.X_OFFSET_DROP_ALL_INVENTORY, Constants.Y_OFFSET_INVENTORY, Constants.BUTTON_SIZE, Constants.BUTTON_SIZE);
        for (AbstractSortButton button : this.nemosInventorySorting$keyMappingButtonMap.values()) {
            this.addRenderableWidget((GuiEventListener)button);
        }
    }

    @Unique
    private void nemosInventorySorting$createButton(List<ComponentConfig> configsList, String componentName, KeyMapping keyMapping, ButtonCreator buttonCreator, int defaultXOffset, int defaultYOffset, int defaultWidth, int defaultHeight) {
        Optional<ComponentConfig> optionalComponentConfig = ConfigUtil.getConfigs(configsList, componentName);
        if (optionalComponentConfig.isEmpty()) {
            this.nemosInventorySorting$createButton(keyMapping, buttonCreator, defaultXOffset, defaultYOffset, defaultWidth, defaultHeight);
            return;
        }
        ComponentConfig config = optionalComponentConfig.get();
        if (!config.isEnabled()) {
            return;
        }
        int yOffset = config.yOffset() != null ? config.yOffset() : defaultYOffset;
        this.nemosInventorySorting$createButton(keyMapping, buttonCreator, config.xOffset(), yOffset, config.width(), config.height());
    }

    @Unique
    private void nemosInventorySorting$createButton(KeyMapping keyMapping, ButtonCreator buttonCreator, int xOffset, int yOffset, int width, int height) {
        int nemosInventorySorting$startIndex = 9;
        int nemosInventorySorting$endIndex = 36;
        AbstractSortButton sortButton = buttonCreator.createButton(nemosInventorySorting$startIndex, nemosInventorySorting$endIndex, this.leftPos, this.topPos, xOffset, yOffset, width, height, (AbstractContainerScreen<?>)this);
        this.nemosInventorySorting$keyMappingButtonMap.put(keyMapping, sortButton);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        Optional<Map.Entry> optionalButtonEntry = this.nemosInventorySorting$keyMappingButtonMap.entrySet().stream().filter(entry -> ((KeyMapping)entry.getKey()).matches(keyCode, scanCode)).findFirst();
        if (keyCode == 340) {
            this.nemosInventorySorting$updateToolTips(true);
        } else {
            optionalButtonEntry.ifPresent(entry -> {
                AbstractSortButton button = (AbstractSortButton)((Object)((Object)entry.getValue()));
                button.playDownSound(Minecraft.getInstance().getSoundManager());
                button.onClick(0.0, 0.0);
            });
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340) {
            this.nemosInventorySorting$updateToolTips(false);
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Optional<Map.Entry> optionalButtonEntry = this.nemosInventorySorting$keyMappingButtonMap.entrySet().stream().filter(entry -> ((KeyMapping)entry.getKey()).matchesMouse(button)).findFirst();
        optionalButtonEntry.ifPresent(entry -> {
            AbstractSortButton sortButton = (AbstractSortButton)((Object)((Object)entry.getValue()));
            sortButton.playDownSound(Minecraft.getInstance().getSoundManager());
            sortButton.onClick(0.0, 0.0);
        });
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Unique
    private void nemosInventorySorting$updateToolTips(boolean isShiftDown) {
        for (AbstractSortButton button : this.nemosInventorySorting$keyMappingButtonMap.values()) {
            button.setIsShiftKeyDown(isShiftDown);
            button.setTooltip(this.getMenu());
        }
    }

    @Override
    public int nemosInventorySorting$getLeftPos() {
        return this.leftPos;
    }
}

