/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.worldgen;

import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.concurrent.atomic.AtomicReference;
import net.mehvahdjukaar.moonlight.api.worldgen.ISpecialSpawnsStructure;
import net.mehvahdjukaar.moonlight.api.worldgen.SpawnBoxSettings;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.worldgen.SpawnBoxStructurePiece;
import net.minecraft.core.BlockPos;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ISpawnBoxStructure
extends ISpecialSpawnsStructure {
    @Override
    @Nullable
    default public WeightedRandomList<MobSpawnSettings.SpawnerData> ml$getSpecialSpawns(StructureManager structureManager, Structure structure, BlockPos pos, LongSet chunkPosReferences, MobCategory category) {
        SpawnBoxSettings settings = this.ml$getSpawnBoxSettings();
        if (settings == SpawnBoxSettings.EMPTY) {
            return null;
        }
        if (!settings.hasCategory(category)) {
            return null;
        }
        AtomicReference boxName = new AtomicReference();
        structureManager.fillStartsForStructure(structure, chunkPosReferences, structureStart -> {
            if (boxName.get() != null) {
                return;
            }
            String foundName = SpawnBoxStructurePiece.getNamedBoxesAt(structureStart, pos);
            if (foundName != null) {
                boxName.set(foundName);
            }
        });
        String boxID = (String)boxName.get();
        if (boxID != null) {
            WeightedRandomList<MobSpawnSettings.SpawnerData> found = settings.get(boxID, category);
            if (found == null) {
                Moonlight.LOGGER.warn("Spawn Box in structure '{}' is missing spawns settings for name '{}' and category '{}'", (Object)structure.type(), (Object)boxID, (Object)category.getName());
            }
            return found;
        }
        return null;
    }

    @NotNull
    public SpawnBoxSettings ml$getSpawnBoxSettings();

    default public void ml$setSpawnBoxSettings(@NotNull SpawnBoxSettings settings) {
    }
}

