/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.position;

import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.util.StringUtils;
import io.netty.buffer.ByteBuf;
import java.util.function.IntFunction;
import net.minecraft.core.Direction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Rotation;

public enum BlockRotation implements IConfigOptionListEntry,
StringRepresentable
{
    NONE(0, Rotation.NONE, "none"),
    CW_90(1, Rotation.CLOCKWISE_90, "rotate_90"),
    CW_180(2, Rotation.CLOCKWISE_180, "rotate_180"),
    CCW_90(3, Rotation.COUNTERCLOCKWISE_90, "rotate_270");

    public static final StringRepresentable.EnumCodec<BlockRotation> CODEC;
    public static final IntFunction<BlockRotation> INDEX_TO_VALUE;
    public static final StreamCodec<ByteBuf, BlockRotation> PACKET_CODEC;
    public static final BlockRotation[] VALUES;
    private final int index;
    private final String configString;
    private final String translationKey;
    private final Rotation vanillaRotation;

    private BlockRotation(int index, Rotation vanillaRotation, String name) {
        this.index = index;
        this.vanillaRotation = vanillaRotation;
        this.configString = name;
        this.translationKey = "malilib.label.block_rotation." + name;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    public String getStringValue() {
        return this.configString;
    }

    @Override
    public String getDisplayName() {
        return StringUtils.translate(this.translationKey, new Object[0]);
    }

    public String getSerializedName() {
        return this.configString;
    }

    public BlockRotation add(BlockRotation rotation) {
        int index = this.index + rotation.index & 3;
        return VALUES[index];
    }

    public Direction rotate(Direction direction) {
        if (direction.getAxis() != Direction.Axis.Y) {
            switch (this.ordinal()) {
                case 1: {
                    return direction.getClockWise();
                }
                case 2: {
                    return direction.getOpposite();
                }
                case 3: {
                    return direction.getCounterClockWise();
                }
            }
        }
        return direction;
    }

    public BlockRotation getReverseRotation() {
        switch (this.ordinal()) {
            case 3: {
                return CW_90;
            }
            case 1: {
                return CCW_90;
            }
            case 2: {
                return CW_180;
            }
        }
        return this;
    }

    @Override
    public BlockRotation cycle(boolean reverse) {
        int index = this.index + (reverse ? -1 : 1) & 3;
        return VALUES[index];
    }

    @Override
    public IConfigOptionListEntry fromString(String value) {
        return BlockRotation.byName(value);
    }

    public Rotation getVanillaRotation() {
        return this.vanillaRotation;
    }

    public static BlockRotation byName(String name) {
        for (BlockRotation rot : VALUES) {
            if (!rot.configString.equalsIgnoreCase(name)) continue;
            return rot;
        }
        return NONE;
    }

    static {
        CODEC = StringRepresentable.fromEnum(BlockRotation::values);
        INDEX_TO_VALUE = ByIdMap.continuous(BlockRotation::getIndex, (Object[])BlockRotation.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        PACKET_CODEC = ByteBufCodecs.idMapper(INDEX_TO_VALUE, BlockRotation::getIndex);
        VALUES = BlockRotation.values();
    }
}

