/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util.log;

import fi.dy.masa.malilib.util.log.IAnsiLogger;

public class AnsiLogger
implements IAnsiLogger {
    private final String log;
    private boolean debug;
    private boolean ansiColor;

    public AnsiLogger(Class<?> clazz) {
        this(clazz, false, false);
    }

    public AnsiLogger(Class<?> clazz, boolean debug) {
        this(clazz, debug, false);
    }

    public AnsiLogger(Class<?> clazz, boolean debug, boolean ansiColor) {
        this.log = clazz.getName();
        this.debug = debug;
        this.ansiColor = ansiColor;
    }

    public void toggleDebug(boolean toggle) {
        this.debug = toggle;
    }

    public void toggleAnsiColor(boolean toggle) {
        this.ansiColor = toggle;
    }

    @Override
    public void info(String fmt, Object ... args) {
        if (this.log != null) {
            String msg = this.format(fmt, args);
            if (this.ansiColor) {
                System.out.printf("\u001b[0;37m[INFO/" + this.log + "]: %s\u001b[0m\n", msg);
            } else {
                System.out.printf("[INFO/" + this.log + "]: %s\n", msg);
            }
        }
    }

    @Override
    public void debug(String fmt, Object ... args) {
        if (this.log != null && this.debug) {
            String msg = this.format(fmt, args);
            if (this.ansiColor) {
                System.out.printf("\u001b[1;35m[DEBUG/" + this.log + "]: %s\u001b[0m\n", msg);
            } else {
                System.out.printf("[DEBUG/" + this.log + "]: %s\n", msg);
            }
        }
    }

    @Override
    public void warn(String fmt, Object ... args) {
        if (this.log != null) {
            String msg = this.format(fmt, args);
            if (this.ansiColor) {
                System.out.printf("\u001b[1;33m[WARN/" + this.log + "]: %s\u001b[0m\n", msg);
            } else {
                System.out.printf("[WARN/" + this.log + "]: %s\n", msg);
            }
        }
    }

    @Override
    public void error(String fmt, Object ... args) {
        if (this.log != null) {
            String msg = this.format(fmt, args);
            if (this.ansiColor) {
                System.out.printf("\u001b[1;31m[ERROR/" + this.log + "]: %s\u001b[0m\n", msg);
            } else {
                System.out.printf("[ERROR/" + this.log + "]: %s\n", msg);
            }
        }
    }

    @Override
    public void fatal(String fmt, Object ... args) {
        if (this.log != null) {
            String msg = this.format(fmt, args);
            if (this.ansiColor) {
                System.out.printf("\u001b[1;91m[FATAL/" + this.log + "]: %s\u001b[0m\n", msg);
            } else {
                System.out.printf("[FATAL/" + this.log + "]: %s\n", msg);
            }
        }
    }
}

