/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.MaLiLibConfigs;
import fi.dy.masa.malilib.gui.LeftRight;
import fi.dy.masa.malilib.util.FileNameUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.malilib.util.time.DurationFormat;
import java.io.File;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforgespi.language.IModInfo;
import org.jetbrains.annotations.NotNull;
import team.cagayakegirls.mafglib.utils.ModPlatform;

public class StringUtils {
    @Nullable
    public static ResourceLocation identifier(String fullPath) {
        try {
            return ResourceLocation.parse((String)fullPath);
        }
        catch (Exception e) {
            MaLiLib.LOGGER.error("Exception while trying to create a ResourceLocation: {}", (Object)e.getMessage());
            return null;
        }
    }

    @Nullable
    public static ResourceLocation identifier(String nameSpace, String path) {
        try {
            return ResourceLocation.fromNamespaceAndPath((String)nameSpace, (String)path);
        }
        catch (Exception e) {
            MaLiLib.LOGGER.error("Exception while trying to create a ResourceLocation: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static String getModVersionString(String modId) {
        for (IModInfo modInfo : ModPlatform.getAllMods()) {
            if (!modInfo.getModId().equals(modId)) continue;
            return modInfo.getVersion().toString();
        }
        return "?";
    }

    public static String stripExtensionIfMatches(String str, String extension) {
        if (str.endsWith(extension) && str.length() > extension.length()) {
            return str.substring(0, str.length() - extension.length());
        }
        return str;
    }

    public static int getColor(String colorStr, int defaultColor) {
        Pattern pattern = Pattern.compile("(?:0x|#)([a-fA-F0-9]{1,8})");
        Matcher matcher = pattern.matcher(colorStr);
        if (matcher.matches()) {
            try {
                return (int)Long.parseLong(matcher.group(1), 16);
            }
            catch (NumberFormatException e) {
                return defaultColor;
            }
        }
        try {
            return Integer.parseInt(colorStr, 10);
        }
        catch (NumberFormatException e) {
            return defaultColor;
        }
    }

    public static String splitCamelCase(String str) {
        if (((String)(str = ((String)str).replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), " "))).length() > 1 && ((String)str).charAt(0) > 'Z') {
            str = ((String)str).substring(0, 1).toUpperCase(Locale.ROOT) + ((String)str).substring(1);
        }
        return str;
    }

    public static boolean containsOrderedCharacters(String needle, String haystack) {
        int needleLength = needle.length();
        int startIndex = 0;
        for (int i = 0; i < needleLength; ++i) {
            startIndex = haystack.indexOf(needle.charAt(i), startIndex);
            if (startIndex == -1) {
                return false;
            }
            ++startIndex;
        }
        return true;
    }

    public static void sendOpenFileChatMessage(Player sender, String messageKey, File file) {
        MutableComponent name = Component.literal((String)file.getName()).withStyle(ChatFormatting.UNDERLINE).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.getAbsolutePath())));
        sender.displayClientMessage((Component)Component.translatable((String)messageKey, (Object[])new Object[]{name}), false);
    }

    public static void sendOpenFileChatMessage(Player sender, String messageKey, Path file) {
        MutableComponent name = Component.literal((String)file.getFileName().toString()).withStyle(ChatFormatting.UNDERLINE).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_FILE, file.toAbsolutePath().toString())));
        sender.displayClientMessage((Component)Component.translatable((String)messageKey, (Object[])new Object[]{name}), false);
    }

    public static int getMaxStringRenderWidth(String ... strings) {
        return StringUtils.getMaxStringRenderWidth(Arrays.asList(strings));
    }

    public static int getMaxStringRenderWidth(List<String> lines) {
        return StringUtils.getMaxStringRenderWidth(lines, (String l) -> l);
    }

    public static int getMaxStringRenderWidth(Function<String, String> translator, String ... strings) {
        return StringUtils.getMaxStringRenderWidth(Arrays.asList(strings), translator);
    }

    public static int getMaxStringRenderWidth(List<String> lines, Function<String, String> translator) {
        int width = 0;
        for (String line : lines) {
            width = Math.max(width, StringUtils.getStringWidth(translator.apply(line)));
        }
        return width;
    }

    public static <T> int getMaxStringRenderWidthOfObjects(List<T> list, Function<T, String> translator) {
        int width = 0;
        for (T item : list) {
            width = Math.max(width, StringUtils.getStringWidth(translator.apply(item)));
        }
        return width;
    }

    public static void addTranslatedLines(List<String> linesOut, String translationKey) {
        String[] parts = StringUtils.translate(translationKey, new Object[0]).split("\\\\n|\\n");
        Collections.addAll(linesOut, parts);
    }

    public static void splitTextToLines(List<String> linesOut, String textIn, int maxLineLength) {
        String[] lines = textIn.split("\\\\n|\\n");
        String activeColor = null;
        for (String line : lines) {
            String[] parts = line.split(" ");
            StringBuilder sb = new StringBuilder(256);
            int spaceWidth = StringUtils.getStringWidth(" ");
            int lineWidth = 0;
            for (String str : parts) {
                int width = StringUtils.getStringWidth(str);
                if (lineWidth + width + spaceWidth > maxLineLength) {
                    if (lineWidth > 0) {
                        linesOut.add(sb.toString());
                        sb = new StringBuilder(256);
                        lineWidth = 0;
                    }
                    if (width > maxLineLength) {
                        int chars = str.length();
                        for (int i = 0; i < chars; ++i) {
                            String c = str.substring(i, i + 1);
                            if (c.equals("\u00a7") && i < chars - 1) {
                                activeColor = str.substring(i, i + 2);
                                sb.append(activeColor);
                                ++i;
                                continue;
                            }
                            if ((lineWidth += StringUtils.getStringWidth(c)) > maxLineLength) {
                                linesOut.add(sb.toString());
                                sb = new StringBuilder(256);
                                lineWidth = 0;
                                if (activeColor != null) {
                                    sb.append(activeColor);
                                }
                            }
                            sb.append(c);
                        }
                        linesOut.add(sb.toString());
                        sb = new StringBuilder(256);
                        lineWidth = 0;
                    }
                }
                if (lineWidth > 0) {
                    sb.append(" ");
                }
                if (width > maxLineLength) continue;
                sb.append(str);
                lineWidth += width + spaceWidth;
            }
            linesOut.add(sb.toString());
        }
    }

    public static String getClampedDisplayStringStrlen(List<String> list, int maxWidth, String prefix, String suffix) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(prefix);
        int width = prefix.length() + suffix.length();
        int size = list.size();
        if (size > 0) {
            for (int i = 0; i < size && width < maxWidth; ++i) {
                String str;
                int len;
                int end;
                if (i > 0) {
                    sb.append(", ");
                    width += 2;
                }
                if ((end = Math.min(len = (str = list.get(i)).length(), maxWidth - width)) < len) {
                    end = Math.max(0, Math.min(len, maxWidth - width - 3));
                    if (end >= 1) {
                        sb.append(str.substring(0, end));
                    }
                    sb.append("...");
                    width += end + 3;
                    continue;
                }
                sb.append(str);
                width += len;
            }
        } else {
            sb.append("<empty>");
        }
        sb.append(suffix);
        return sb.toString();
    }

    public static String getDisplayStringForList(List<String> list, int maxWidth, String quote, String prefix, String suffix) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(prefix);
        String entrySep = ", ";
        String dots = " ...";
        int listSize = list.size();
        int widthQuotes = StringUtils.getStringWidth(quote) * 2;
        int widthSep = StringUtils.getStringWidth(entrySep);
        int widthDots = StringUtils.getStringWidth(dots);
        int widthNextMin = widthSep + widthDots;
        int width = StringUtils.getStringWidth(prefix) + StringUtils.getStringWidth(suffix);
        if (listSize > 0) {
            int len;
            for (int listIndex = 0; listIndex < listSize && width < maxWidth; width += len, ++listIndex) {
                int widthNext;
                if (listIndex > 0) {
                    sb.append(entrySep);
                    width += widthSep;
                }
                String str = list.get(listIndex);
                len = StringUtils.getStringWidth(str) + widthQuotes;
                int n = widthNext = listIndex < listSize - 1 ? widthNextMin : 0;
                if (width + len + widthNext <= maxWidth) {
                    sb.append(quote).append(str).append(quote);
                    continue;
                }
                if (width + StringUtils.getStringWidth(str.substring(0, 1)) + widthDots <= maxWidth) {
                    String c;
                    int charWidth;
                    sb.append(quote);
                    width += widthQuotes;
                    for (int i = 0; i < str.length() && width + (charWidth = StringUtils.getStringWidth(c = str.substring(i, i + 1))) + widthDots <= maxWidth; ++i) {
                        sb.append(c);
                        width += charWidth;
                    }
                    sb.append(quote);
                }
                sb.append(dots);
                break;
            }
        } else {
            sb.append("<empty>");
        }
        sb.append(suffix);
        return sb.toString();
    }

    public static String getClampedDisplayStringRenderlen(List<String> list, int maxWidth, String prefix, String suffix) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(prefix);
        String entrySep = ", ";
        String dots = " ...";
        int listSize = list.size();
        int widthSep = StringUtils.getStringWidth(entrySep);
        int widthDots = StringUtils.getStringWidth(dots);
        int width = StringUtils.getStringWidth(prefix) + StringUtils.getStringWidth(suffix);
        if (listSize > 0) {
            int len;
            for (int listIndex = 0; listIndex < listSize && width < maxWidth; width += len, ++listIndex) {
                String c;
                int charWidth;
                String str;
                if (listIndex > 0) {
                    sb.append(entrySep);
                    width += widthSep;
                }
                if (width + (len = StringUtils.getStringWidth(str = list.get(listIndex))) <= maxWidth) {
                    sb.append(str);
                    continue;
                }
                for (int i = 0; i < str.length() && width + (charWidth = StringUtils.getStringWidth(c = str.substring(i, i + 1))) + widthDots <= maxWidth; ++i) {
                    sb.append(c);
                    width += charWidth;
                }
                sb.append(dots);
                width += widthDots;
                break;
            }
        } else {
            sb.append("<empty>");
        }
        sb.append(suffix);
        return sb.toString();
    }

    public static String clampTextToRenderLength(String text, int maxWidth, LeftRight side, String indicator) {
        String chr;
        int charWidth;
        if (StringUtils.getStringWidth(text) <= maxWidth) {
            return text;
        }
        StringBuilder sb = new StringBuilder(128);
        int indicatorWidth = StringUtils.getStringWidth(indicator);
        int stringLen = text.length();
        int usedWidth = indicatorWidth;
        int index = 0;
        int lastIndex = stringLen - 1;
        int indexIncrement = 1;
        if (side == LeftRight.LEFT) {
            index = stringLen - 1;
            lastIndex = 0;
            indexIncrement = -1;
        }
        while (usedWidth < maxWidth && usedWidth + (charWidth = StringUtils.getStringWidth(chr = text.substring(index, index + 1))) <= maxWidth) {
            sb.append(chr);
            usedWidth += charWidth;
            if (index == lastIndex) break;
            index += indexIncrement;
        }
        if (side == LeftRight.LEFT) {
            return indicator + String.valueOf(sb.reverse());
        }
        sb.append(indicator);
        return sb.toString();
    }

    @Nullable
    public static String getWorldOrServerNameOrDefault(String defaultStr) {
        String name = StringUtils.getWorldOrServerName();
        return name != null ? name : defaultStr;
    }

    @Nullable
    public static String getWorldOrServerName() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.hasSingleplayerServer()) {
            IntegratedServer server = mc.getSingleplayerServer();
            if (server != null) {
                String name = server.getWorldData().getLevelName();
                return FileNameUtils.generateSafeFileName(name);
            }
        } else {
            ServerData server;
            if (mc.getCurrentServer() != null && mc.getCurrentServer().isRealm()) {
                Connection connection;
                if (MaLiLibConfigs.Generic.REALMS_COMMON_CONFIG.getBooleanValue()) {
                    return "realms";
                }
                ClientPacketListener handler = mc.getConnection();
                Connection connection2 = connection = handler != null ? handler.getConnection() : null;
                if (connection != null) {
                    return "realms_" + StringUtils.stringifyAddress(connection.getRemoteAddress());
                }
            }
            if ((server = mc.getCurrentServer()) != null) {
                return server.ip.replace(':', '_');
            }
            return "multiplayer_fallback";
        }
        return null;
    }

    public static String getStorageFileName(boolean globalData, String prefix, String suffix, String defaultName) {
        Object name = StringUtils.getWorldOrServerName();
        if (name != null) {
            if (globalData) {
                return prefix + (String)name + suffix;
            }
            ClientLevel world = Minecraft.getInstance().level;
            if (world != null) {
                return prefix + (String)name + "_dim_" + WorldUtils.getDimensionId((Level)world) + suffix;
            }
        } else {
            name = prefix + defaultName + suffix;
        }
        return FileNameUtils.generateSafeFileName((String)name) + suffix;
    }

    public static String stringifyAddress(SocketAddress address) {
        String str = address.toString();
        if (str.contains("/")) {
            str = str.substring(str.indexOf(47) + 1);
        }
        return str.replace(':', '_');
    }

    public static String getPrettyFileSizeText(long fileSize, int decimalPlaces) {
        String[] units = new String[]{"B", "KiB", "MiB", "GiB", "TiB"};
        String unitStr = "";
        double size = fileSize;
        String[] stringArray = units;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String unit;
            unitStr = unit = stringArray[i];
            if (size < 1024.0) break;
            size /= 1024.0;
        }
        String fmt = "%." + decimalPlaces + "f %s";
        return String.format(fmt, size, unitStr);
    }

    public static List<String> translateAndLineSplit(String translationKey, Object ... args) {
        String translated = StringUtils.translate(translationKey, args);
        return Arrays.asList(translated.split("\\\\n|\\n"));
    }

    public static void translateAndLineSplit(Consumer<String> lineConsumer, String translationKey, Object ... args) {
        String translated = StringUtils.translate(translationKey, args);
        for (String line : translated.split("\\\\n|\\n")) {
            lineConsumer.accept(line);
        }
    }

    @Nullable
    public static String getTranslatedOrFallback(String key, @Nullable String fallback) {
        String translated = StringUtils.translate(key, new Object[0]);
        if (!key.equals(translated)) {
            return translated;
        }
        return fallback;
    }

    public static Component getTranslatedAsTextOrFallback(String key, @Nullable String fallback) {
        String result = StringUtils.getTranslatedOrFallback(key, fallback);
        if (result == null) {
            return Component.empty();
        }
        return Component.nullToEmpty((String)result);
    }

    public static String translate(String translationKey, Object ... args) {
        try {
            if (MaLiLibConfigs.Debug.PRINT_TRANSLATION_KEYS.getBooleanValue() && StringUtils.hasTranslation(translationKey)) {
                MaLiLib.LOGGER.info("Translation key: {}", (Object)translationKey);
            }
            return I18n.get((String)translationKey, (Object[])args);
        }
        catch (Exception e) {
            return translationKey;
        }
    }

    public static Component translateAsText(String translationKey, Object ... args) {
        return Component.nullToEmpty((String)StringUtils.translate(translationKey, args));
    }

    public static MutableComponent translateable(String translationKey) {
        return Component.translatable((String)translationKey);
    }

    public static MutableComponent translateable(String translationKey, Object ... args) {
        return Component.translatable((String)translationKey, (Object[])args);
    }

    public static boolean hasTranslation(String translationKey) {
        return I18n.exists((String)translationKey);
    }

    public static String prettifyRawTranslationPath(@NotNull String translationPath) {
        return Arrays.stream(translationPath.split("_")).map(word -> word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase()).collect(Collectors.joining(" "));
    }

    public static int getFontHeight() {
        Objects.requireNonNull(Minecraft.getInstance().font);
        return 9;
    }

    public static int getStringWidth(String text) {
        return Minecraft.getInstance().font.width(text);
    }

    public static void drawString(int x, int y, int color, String text, GuiGraphics drawContext) {
        drawContext.drawString(Minecraft.getInstance().font, text, x, y, color, false);
    }

    public static String getDurationString(long durationMs) {
        return DurationFormat.PRETTY.format(durationMs);
    }
}

