/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class PositionUtils {
    public static final Direction[] ALL_DIRECTIONS = new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    public static final Direction[] HORIZONTAL_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    public static final Direction[] VERTICAL_DIRECTIONS = new Direction[]{Direction.DOWN, Direction.UP};

    public static Vec3 modifyValue(CoordinateType type, Vec3 valueIn, double amount) {
        switch (type.ordinal()) {
            case 0: {
                return new Vec3(valueIn.x + amount, valueIn.y, valueIn.z);
            }
            case 1: {
                return new Vec3(valueIn.x, valueIn.y + amount, valueIn.z);
            }
            case 2: {
                return new Vec3(valueIn.x, valueIn.y, valueIn.z + amount);
            }
        }
        return valueIn;
    }

    public static BlockPos modifyValue(CoordinateType type, BlockPos valueIn, int amount) {
        switch (type.ordinal()) {
            case 0: {
                return BlockPos.containing((double)(valueIn.getX() + amount), (double)valueIn.getY(), (double)valueIn.getZ());
            }
            case 1: {
                return BlockPos.containing((double)valueIn.getX(), (double)(valueIn.getY() + amount), (double)valueIn.getZ());
            }
            case 2: {
                return BlockPos.containing((double)valueIn.getX(), (double)valueIn.getY(), (double)(valueIn.getZ() + amount));
            }
        }
        return valueIn;
    }

    public static Vec3 setValue(CoordinateType type, Vec3 valueIn, double newValue) {
        switch (type.ordinal()) {
            case 0: {
                return new Vec3(newValue, valueIn.y, valueIn.z);
            }
            case 1: {
                return new Vec3(valueIn.x, newValue, valueIn.z);
            }
            case 2: {
                return new Vec3(valueIn.x, valueIn.y, newValue);
            }
        }
        return valueIn;
    }

    public static BlockPos setValue(CoordinateType type, BlockPos valueIn, int newValue) {
        switch (type.ordinal()) {
            case 0: {
                return BlockPos.containing((double)newValue, (double)valueIn.getY(), (double)valueIn.getZ());
            }
            case 1: {
                return BlockPos.containing((double)valueIn.getX(), (double)newValue, (double)valueIn.getZ());
            }
            case 2: {
                return BlockPos.containing((double)valueIn.getX(), (double)valueIn.getY(), (double)newValue);
            }
        }
        return valueIn;
    }

    public static BlockPos getEntityBlockPos(Entity entity) {
        return BlockPos.containing((double)Math.floor(entity.getX()), (double)Math.floor(entity.getY()), (double)Math.floor(entity.getZ()));
    }

    public static Direction getClosestLookingDirection(Entity entity) {
        return PositionUtils.getClosestLookingDirection(entity, 60.0f);
    }

    public static Direction getClosestLookingDirection(Entity entity, float verticalThreshold) {
        if (entity.getXRot() >= verticalThreshold) {
            return Direction.DOWN;
        }
        if (entity.getYRot() <= -verticalThreshold) {
            return Direction.UP;
        }
        return entity.getDirection();
    }

    public static BlockPos getPositionInfrontOfEntity(Entity entity) {
        return PositionUtils.getPositionInfrontOfEntity(entity, 60.0f);
    }

    public static BlockPos getPositionInfrontOfEntity(Entity entity, float verticalThreshold) {
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        double w = entity.getBbWidth();
        BlockPos pos = BlockPos.containing((double)x, (double)y, (double)z);
        if (entity.getXRot() >= verticalThreshold) {
            return pos.below(1);
        }
        if (entity.getXRot() <= -verticalThreshold) {
            return BlockPos.containing((double)x, (double)Math.ceil(entity.getBoundingBox().maxY), (double)z);
        }
        y = Math.floor(y + (double)entity.getEyeHeight());
        switch (entity.getDirection()) {
            case EAST: {
                return BlockPos.containing((double)((int)Math.ceil(x + w / 2.0)), (double)((int)y), (double)((int)Math.floor(z)));
            }
            case WEST: {
                return BlockPos.containing((double)((int)Math.floor(x - w / 2.0) - 1), (double)((int)y), (double)((int)Math.floor(z)));
            }
            case SOUTH: {
                return BlockPos.containing((double)((int)Math.floor(x)), (double)((int)y), (double)((int)Math.ceil(z + w / 2.0)));
            }
            case NORTH: {
                return BlockPos.containing((double)((int)Math.floor(x)), (double)((int)y), (double)((int)Math.floor(z - w / 2.0) - 1));
            }
        }
        return pos;
    }

    public static Vec3 getHitVecCenter(BlockPos basePos, Direction facing) {
        int x = basePos.getX();
        int y = basePos.getY();
        int z = basePos.getZ();
        switch (facing) {
            case UP: {
                return new Vec3((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
            }
            case DOWN: {
                return new Vec3((double)x + 0.5, (double)y, (double)z + 0.5);
            }
            case NORTH: {
                return new Vec3((double)x + 0.5, (double)y + 0.5, (double)z);
            }
            case SOUTH: {
                return new Vec3((double)x + 0.5, (double)y + 0.5, (double)(z + 1));
            }
            case WEST: {
                return new Vec3((double)x, (double)y + 0.5, (double)z);
            }
            case EAST: {
                return new Vec3((double)(x + 1), (double)y + 0.5, (double)(z + 1));
            }
        }
        return new Vec3((double)x, (double)y, (double)z);
    }

    public static HitPart getHitPart(Direction originalSide, Direction playerFacingH, BlockPos pos, Vec3 hitVec) {
        Vec3 positions = PositionUtils.getHitPartPositions(originalSide, playerFacingH, pos, hitVec);
        double posH = positions.x;
        double posV = positions.y;
        double offH = Math.abs(posH - 0.5);
        double offV = Math.abs(posV - 0.5);
        if (offH > 0.25 || offV > 0.25) {
            if (offH > offV) {
                return posH < 0.5 ? HitPart.LEFT : HitPart.RIGHT;
            }
            return posV < 0.5 ? HitPart.BOTTOM : HitPart.TOP;
        }
        return HitPart.CENTER;
    }

    private static Vec3 getHitPartPositions(Direction originalSide, Direction playerFacingH, BlockPos pos, Vec3 hitVec) {
        double x = hitVec.x - (double)pos.getX();
        double y = hitVec.y - (double)pos.getY();
        double z = hitVec.z - (double)pos.getZ();
        double posH = 0.0;
        double posV = 0.0;
        switch (originalSide) {
            case UP: 
            case DOWN: {
                switch (playerFacingH) {
                    case NORTH: {
                        posH = x;
                        posV = 1.0 - z;
                        break;
                    }
                    case SOUTH: {
                        posH = 1.0 - x;
                        posV = z;
                        break;
                    }
                    case WEST: {
                        posH = 1.0 - z;
                        posV = 1.0 - x;
                        break;
                    }
                    case EAST: {
                        posH = z;
                        posV = x;
                        break;
                    }
                }
                if (originalSide != Direction.DOWN) break;
                posV = 1.0 - posV;
                break;
            }
            case SOUTH: 
            case NORTH: {
                posH = originalSide.getAxisDirection() == Direction.AxisDirection.POSITIVE ? x : 1.0 - x;
                posV = y;
                break;
            }
            case EAST: 
            case WEST: {
                posH = originalSide.getAxisDirection() == Direction.AxisDirection.NEGATIVE ? z : 1.0 - z;
                posV = y;
            }
        }
        return new Vec3(posH, posV, 0.0);
    }

    public static Direction getTargetedDirection(Direction side, Direction playerFacingH, BlockPos pos, Vec3 hitVec) {
        Vec3 positions = PositionUtils.getHitPartPositions(side, playerFacingH, pos, hitVec);
        double posH = positions.x;
        double posV = positions.y;
        double offH = Math.abs(posH - 0.5);
        double offV = Math.abs(posV - 0.5);
        if (offH > 0.25 || offV > 0.25) {
            if (side.getAxis() == Direction.Axis.Y) {
                if (offH > offV) {
                    return posH < 0.5 ? playerFacingH.getCounterClockWise() : playerFacingH.getClockWise();
                }
                if (side == Direction.DOWN) {
                    return posV > 0.5 ? playerFacingH.getOpposite() : playerFacingH;
                }
                return posV < 0.5 ? playerFacingH.getOpposite() : playerFacingH;
            }
            if (offH > offV) {
                return posH < 0.5 ? side.getClockWise() : side.getCounterClockWise();
            }
            return posV < 0.5 ? Direction.DOWN : Direction.UP;
        }
        return side;
    }

    public static enum CoordinateType {
        X,
        Y,
        Z;

    }

    public static enum HitPart {
        CENTER,
        LEFT,
        RIGHT,
        BOTTOM,
        TOP;

    }
}

