/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.util.nbt.NbtBlockUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

@Deprecated
public class BlockUtils
extends NbtBlockUtils {
    @Nullable
    public static DirectionProperty getFirstDirectionProperty(BlockState state) {
        for (Property prop : state.getProperties()) {
            if (!(prop instanceof DirectionProperty)) continue;
            return (DirectionProperty)prop;
        }
        return null;
    }

    @Nullable
    public static Direction getFirstPropertyFacingValue(BlockState state) {
        DirectionProperty prop = BlockUtils.getFirstDirectionProperty(state);
        return prop != null ? (Direction)state.getValue((Property)prop) : null;
    }

    @Nullable
    public static Direction getPropertyFacingValue(BlockState state) {
        return state.hasProperty((Property)BlockStateProperties.FACING) ? (Direction)state.getValue((Property)BlockStateProperties.FACING) : null;
    }

    @Nullable
    public static Direction getPropertyHopperFacingValue(BlockState state) {
        return state.hasProperty((Property)BlockStateProperties.FACING_HOPPER) ? (Direction)state.getValue((Property)BlockStateProperties.FACING_HOPPER) : null;
    }

    @Nullable
    public static Direction getPropertyHorizontalFacingValue(BlockState state) {
        return state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING) ? (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) : null;
    }

    @Nullable
    public static FrontAndTop getPropertyOrientationValue(BlockState state) {
        return state.hasProperty((Property)BlockStateProperties.ORIENTATION) ? (FrontAndTop)state.getValue((Property)BlockStateProperties.ORIENTATION) : null;
    }

    @Nullable
    public static Direction getPropertyOrientationFacing(BlockState state) {
        FrontAndTop o = BlockUtils.getPropertyOrientationValue(state);
        return o != null ? o.front() : null;
    }

    @Nullable
    public static Direction getPropertyOrientationRotation(BlockState state) {
        FrontAndTop o = BlockUtils.getPropertyOrientationValue(state);
        return o != null ? o.top() : null;
    }

    public static boolean isFacingValidForDirection(ItemStack stack, Direction facing) {
        Item item = stack.getItem();
        if (!stack.isEmpty() && item instanceof BlockItem) {
            Block block = ((BlockItem)item).getBlock();
            BlockState state = block.defaultBlockState();
            if (state.hasProperty((Property)BlockStateProperties.FACING)) {
                return true;
            }
            if (state.hasProperty((Property)BlockStateProperties.FACING_HOPPER) && !facing.equals((Object)Direction.UP)) {
                return true;
            }
            if (state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING) && !facing.equals((Object)Direction.UP) && !facing.equals((Object)Direction.DOWN)) {
                return true;
            }
        }
        return false;
    }

    public static int getDirectionFacingIndex(ItemStack stack, Direction facing) {
        if (BlockUtils.isFacingValidForDirection(stack, facing)) {
            return facing.get3DDataValue();
        }
        return -1;
    }

    public static boolean isFacingValidForOrientation(ItemStack stack, Direction facing) {
        Item item = stack.getItem();
        if (!stack.isEmpty() && item instanceof BlockItem) {
            Block block = ((BlockItem)item).getBlock();
            BlockState state = block.defaultBlockState();
            return state.hasProperty((Property)BlockStateProperties.ORIENTATION);
        }
        return false;
    }

    public static int getOrientationFacingIndex(ItemStack stack, Direction facing) {
        BlockItem blockItem;
        BlockState defaultState;
        Item item = stack.getItem();
        if (item instanceof BlockItem && (defaultState = (blockItem = (BlockItem)item).getBlock().defaultBlockState()).hasProperty((Property)BlockStateProperties.ORIENTATION)) {
            List<FrontAndTop> list = Arrays.stream(FrontAndTop.values()).toList();
            for (int i = 0; i < list.size(); ++i) {
                FrontAndTop o = list.get(i);
                if (!o.front().equals((Object)facing)) continue;
                return i;
            }
        }
        return -1;
    }

    public static List<String> getFormattedBlockStateProperties(BlockState state) {
        return BlockUtils.getFormattedBlockStateProperties(state, ": ");
    }

    public static List<String> getFormattedBlockStateProperties(BlockState state, String separator) {
        Collection properties = state.getProperties();
        if (properties.size() > 0) {
            ArrayList<String> lines = new ArrayList<String>();
            for (Property prop : properties) {
                Comparable val = state.getValue(prop);
                if (prop instanceof BooleanProperty) {
                    String pre = val.equals(Boolean.TRUE) ? GuiBase.TXT_GREEN : GuiBase.TXT_RED;
                    lines.add(prop.getName() + separator + pre + val.toString());
                    continue;
                }
                if (prop instanceof DirectionProperty) {
                    lines.add(prop.getName() + separator + GuiBase.TXT_GOLD + val.toString());
                    continue;
                }
                if (prop instanceof EnumProperty) {
                    EnumProperty enumProperty = (EnumProperty)prop;
                    if (enumProperty.getValueClass().equals(Direction.class)) {
                        lines.add(prop.getName() + separator + GuiBase.TXT_GOLD + val.toString());
                        continue;
                    }
                    if (!enumProperty.getValueClass().equals(FrontAndTop.class)) continue;
                    lines.add(prop.getName() + separator + GuiBase.TXT_LIGHT_PURPLE + val.toString());
                    continue;
                }
                if (prop instanceof IntegerProperty) {
                    lines.add(prop.getName() + separator + GuiBase.TXT_AQUA + val.toString());
                    continue;
                }
                lines.add(prop.getName() + separator + val.toString());
            }
            return lines;
        }
        return Collections.emptyList();
    }

    public static Set<Integer> getDisabledSlots(CrafterBlockEntity ce) {
        HashSet<Integer> list = new HashSet<Integer>();
        if (ce != null) {
            for (int i = 0; i < 9; ++i) {
                if (!ce.isSlotDisabled(i)) continue;
                list.add(i);
            }
        }
        return list;
    }

    public static Holder<Block> getBlockEntry(ResourceLocation id, @Nonnull RegistryAccess registry) {
        try {
            return registry.registry(BuiltInRegistries.BLOCK.key()).flatMap(optional -> optional.getHolder(id)).orElse(null);
        }
        catch (Exception e) {
            return null;
        }
    }
}

