/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.render;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.mixin.entity.IMixinMerchantEntity;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.malilib.util.game.BlockUtils;
import fi.dy.masa.malilib.util.nbt.NbtBlockUtils;
import fi.dy.masa.malilib.util.nbt.NbtEntityUtils;
import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.PlayerEnderChestContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;

public class InventoryOverlayScreen
extends Screen
implements Renderable {
    String modId;
    private InventoryOverlay.Context previewData;
    private final boolean shulkerBGColors;
    private final boolean villagerBGColors;
    private int ticks;

    public InventoryOverlayScreen(String modId, @Nullable InventoryOverlay.Context previewData) {
        this(modId, previewData, true, false);
    }

    public InventoryOverlayScreen(String modId, @Nullable InventoryOverlay.Context previewData, boolean shulkerBGColors) {
        this(modId, previewData, shulkerBGColors, false);
    }

    public InventoryOverlayScreen(String modId, @Nullable InventoryOverlay.Context previewData, boolean shulkerBGColors, boolean villagerBGColors) {
        super(StringUtils.translateAsText("malilib.gui.title.inventory_overlay", modId));
        this.modId = modId;
        this.previewData = previewData;
        this.shulkerBGColors = shulkerBGColors;
        this.villagerBGColors = villagerBGColors;
    }

    public void render(GuiGraphics drawContext, int mouseX, int mouseY, float delta) {
        ++this.ticks;
        Minecraft mc = Minecraft.getInstance();
        Level world = WorldUtils.getBestWorld(mc);
        if (this.previewData != null && world != null) {
            BlockEntity blockEntity;
            int xCenter = GuiUtils.getScaledWindowWidth() / 2;
            int yCenter = GuiUtils.getScaledWindowHeight() / 2;
            int x = xCenter - 26;
            int y = yCenter - 92;
            int startSlot = 0;
            int totalSlots = this.previewData.inv() == null ? 0 : this.previewData.inv().getContainerSize();
            ArrayList<ItemStack> armourItems = new ArrayList<ItemStack>();
            if (this.previewData.entity() instanceof AbstractHorse) {
                if (this.previewData.inv() == null) {
                    MaLiLib.LOGGER.warn("InventoryOverlayScreen(): Horse inv() = null");
                    return;
                }
                armourItems.add(this.previewData.entity().getItemBySlot(EquipmentSlot.BODY));
                armourItems.add(this.previewData.inv().getItem(0));
                startSlot = 1;
                totalSlots = this.previewData.inv().getContainerSize() - 1;
            } else if (this.previewData.entity() instanceof Wolf) {
                armourItems.add(this.previewData.entity().getItemBySlot(EquipmentSlot.BODY));
            }
            InventoryOverlay.InventoryRenderType type = this.previewData.entity() instanceof Villager ? InventoryOverlay.InventoryRenderType.VILLAGER : InventoryOverlay.getBestInventoryType(this.previewData.inv(), this.previewData.nbt() != null ? this.previewData.nbt() : new CompoundTag(), this.previewData);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp(type, totalSlots);
            int rows = (int)Math.ceil((double)totalSlots / (double)props.slotsPerRow);
            HashSet<Integer> lockedSlots = new HashSet();
            int xInv = xCenter - props.width / 2;
            int yInv = yCenter - props.height - 6;
            if (rows > 6) {
                yInv -= (rows - 6) * 18;
                y -= (rows - 6) * 18;
            }
            if (this.previewData.entity() != null) {
                x = xCenter - 55;
                xInv = xCenter + 2;
                yInv = Math.min(yInv, yCenter - 92);
            }
            if ((blockEntity = this.previewData.be()) instanceof CrafterBlockEntity) {
                CrafterBlockEntity cbe = (CrafterBlockEntity)blockEntity;
                lockedSlots = BlockUtils.getDisabledSlots(cbe);
            } else if (this.previewData.nbt() != null && this.previewData.nbt().contains("disabled_slots")) {
                lockedSlots = NbtBlockUtils.getDisabledSlotsFromNbt(this.previewData.nbt());
            }
            if (!armourItems.isEmpty()) {
                SimpleContainer horseInv = new SimpleContainer(armourItems.toArray(new ItemStack[0]));
                InventoryOverlay.renderInventoryBackground(type, xInv, yInv, 1, horseInv.getContainerSize(), mc);
                InventoryOverlay.renderInventoryBackgroundSlots(type, (Container)horseInv, xInv + props.slotOffsetX, yInv + props.slotOffsetY, drawContext);
                InventoryOverlay.renderInventoryStacks(type, (Container)horseInv, xInv + props.slotOffsetX, yInv + props.slotOffsetY, 1, 0, horseInv.getContainerSize(), mc, drawContext, mouseX, mouseY);
                xInv += 36;
            }
            if (this.previewData.be() != null && (blockEntity = this.previewData.be().getBlockState().getBlock()) instanceof ShulkerBoxBlock) {
                ShulkerBoxBlock sbb = (ShulkerBoxBlock)blockEntity;
                RenderUtils.setShulkerboxBackgroundTintColor(sbb, this.shulkerBGColors);
            }
            if (totalSlots > 0 && this.previewData.inv() != null) {
                InventoryOverlay.renderInventoryBackground(type, xInv, yInv, props.slotsPerRow, totalSlots, mc);
                InventoryOverlay.renderInventoryStacks(type, this.previewData.inv(), xInv + props.slotOffsetX, yInv + props.slotOffsetY, props.slotsPerRow, startSlot, totalSlots, lockedSlots, mc, drawContext, mouseX, mouseY);
            }
            if (this.previewData.type() == InventoryOverlay.InventoryRenderType.PLAYER && this.previewData.nbt() != null && this.previewData.nbt().contains("EnderItems")) {
                enderItems = InventoryUtils.getPlayerEnderItemsFromNbt(this.previewData.nbt(), (HolderLookup.Provider)world.registryAccess());
                if (enderItems == null) {
                    enderItems = new PlayerEnderChestContainer();
                }
                yInv = yCenter + 6;
                InventoryOverlay.renderInventoryBackground(InventoryOverlay.InventoryRenderType.GENERIC, xInv, yInv, 9, 27, mc);
                InventoryOverlay.renderInventoryStacks(InventoryOverlay.InventoryRenderType.GENERIC, (Container)enderItems, xInv + props.slotOffsetX, yInv + props.slotOffsetY, 9, 0, 27, mc, drawContext, mouseX, mouseY);
            } else {
                enderItems = this.previewData.entity();
                if (enderItems instanceof Player) {
                    Player player = (Player)enderItems;
                    yInv = yCenter + 6;
                    InventoryOverlay.renderInventoryBackground(InventoryOverlay.InventoryRenderType.GENERIC, xInv, yInv, 9, 27, mc);
                    InventoryOverlay.renderInventoryStacks(InventoryOverlay.InventoryRenderType.GENERIC, (Container)player.getEnderChestInventory(), xInv + props.slotOffsetX, yInv + props.slotOffsetY, 9, 0, 27, mc, drawContext, mouseX, mouseY);
                }
            }
            if (type == InventoryOverlay.InventoryRenderType.VILLAGER && this.previewData.nbt() != null && this.previewData.nbt().contains("Offers")) {
                offers = InventoryUtils.getSellingItemsFromNbt(this.previewData.nbt(), world.registryAccess());
                Container tradeOffers = InventoryUtils.getAsInventory(offers);
                if (tradeOffers != null && !tradeOffers.isEmpty()) {
                    int xInvOffset = xCenter - 55 - props.width / 2;
                    int offerSlotCount = 9;
                    yInv = yCenter + 6;
                    if (offers.size() > 9) {
                        offerSlotCount = 18;
                    }
                    RenderUtils.setVillagerBackgroundTintColor(NbtEntityUtils.getVillagerDataFromNbt(this.previewData.nbt()), this.villagerBGColors);
                    InventoryOverlay.renderInventoryBackground(InventoryOverlay.InventoryRenderType.GENERIC, xInvOffset - props.slotOffsetX, yInv, 9, offerSlotCount, mc);
                    InventoryOverlay.renderInventoryStacks(InventoryOverlay.InventoryRenderType.GENERIC, tradeOffers, xInvOffset, yInv + props.slotOffsetY, 9, 0, offerSlotCount, mc, drawContext, mouseX, mouseY);
                }
            } else {
                AbstractVillager merchant;
                MerchantOffers trades;
                NonNullList<ItemStack> offers;
                Container tradeOffers;
                offers = this.previewData.entity();
                if (offers instanceof AbstractVillager && (tradeOffers = InventoryUtils.getAsInventory(offers = (trades = ((IMixinMerchantEntity)(merchant = (AbstractVillager)offers)).malilib_offers()) != null ? InventoryUtils.getSellingItems(trades) : NonNullList.create())) != null && !tradeOffers.isEmpty()) {
                    int xInvOffset = xCenter - 55 - props.width / 2;
                    int offerSlotCount = 9;
                    yInv = yCenter + 6;
                    if (offers.size() > 9) {
                        offerSlotCount = 18;
                    }
                    if (merchant instanceof Villager) {
                        Villager villager = (Villager)merchant;
                        RenderUtils.setVillagerBackgroundTintColor(villager.getVillagerData(), this.villagerBGColors);
                    }
                    InventoryOverlay.renderInventoryBackground(InventoryOverlay.InventoryRenderType.GENERIC, xInvOffset - props.slotOffsetX, yInv, 9, offerSlotCount, mc);
                    InventoryOverlay.renderInventoryStacks(InventoryOverlay.InventoryRenderType.GENERIC, tradeOffers, xInvOffset, yInv + props.slotOffsetY, 9, 0, offerSlotCount, mc, drawContext, mouseX, mouseY);
                }
            }
            if (this.previewData.entity() != null) {
                InventoryOverlay.renderEquipmentOverlayBackground(x, y, this.previewData.entity(), drawContext);
                InventoryOverlay.renderEquipmentStacks(this.previewData.entity(), x, y, mc, drawContext, mouseX, mouseY);
            }
            if (this.ticks % 4 == 0) {
                this.previewData = this.previewData.handler().onContextRefresh(this.previewData, world);
            }
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void dumpOffers(NonNullList<ItemStack> offers, @Nonnull RegistryAccess registry) {
        System.out.print("dumpOffers(): DUMP OFFERS -->\n");
        if (offers == null || offers.isEmpty()) {
            System.out.print("EMPTY!\n");
            return;
        }
        int i = 0;
        for (ItemStack entry : offers) {
            if (entry.isEmpty()) {
                System.out.printf("[%d]: EMPTY!\n", i);
            } else {
                System.out.printf("[%d] Item Nbt: [%s]\n", i, entry.save((HolderLookup.Provider)registry));
            }
            ++i;
        }
        System.out.print("END!\n");
    }
}

