/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.network;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.network.IClientPayloadData;
import fi.dy.masa.malilib.network.MaLiLibBuf;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public interface IPluginClientPlayHandler<T extends CustomPacketPayload>
extends ClientPlayNetworking.PlayPayloadHandler<T> {
    public static final int FROM_SERVER = 1;
    public static final int TO_SERVER = 2;
    public static final int BOTH_SERVER = 3;
    public static final int TO_CLIENT = 4;
    public static final int FROM_CLIENT = 5;
    public static final int BOTH_CLIENT = 6;

    public ResourceLocation getPayloadChannel();

    public boolean isPlayRegistered(ResourceLocation var1);

    public void setPlayRegistered(ResourceLocation var1);

    public void reset(ResourceLocation var1);

    default public void registerPlayPayload(@Nonnull CustomPacketPayload.Type<T> id, @Nonnull StreamCodec<? super RegistryFriendlyByteBuf, T> codec, int direction) {
        if (!this.isPlayRegistered(this.getPayloadChannel())) {
            try {
                switch (direction) {
                    case 2: 
                    case 5: {
                        PayloadTypeRegistry.playC2S().register(id, codec);
                        break;
                    }
                    case 1: 
                    case 4: {
                        PayloadTypeRegistry.playS2C().register(id, codec);
                        break;
                    }
                    default: {
                        PayloadTypeRegistry.playC2S().register(id, codec);
                        PayloadTypeRegistry.playS2C().register(id, codec);
                        break;
                    }
                }
            }
            catch (IllegalArgumentException e) {
                MaLiLib.LOGGER.error("registerPlayPayload: channel ID [{}] is is already registered", (Object)this.getPayloadChannel());
            }
            this.setPlayRegistered(this.getPayloadChannel());
            return;
        }
        MaLiLib.LOGGER.error("registerPlayPayload: channel ID [{}] is invalid, or it is already registered", (Object)this.getPayloadChannel());
    }

    default public boolean registerPlayReceiver(@Nonnull CustomPacketPayload.Type<T> id, @Nullable ClientPlayNetworking.PlayPayloadHandler<T> receiver) {
        if (this.isPlayRegistered(this.getPayloadChannel())) {
            try {
                return ClientPlayNetworking.registerGlobalReceiver(id, (ClientPlayNetworking.PlayPayloadHandler)Objects.requireNonNullElse(receiver, this::receivePlayPayload));
            }
            catch (IllegalArgumentException e) {
                MaLiLib.LOGGER.error("registerPlayReceiver: Channel ID [{}] payload has not been registered", (Object)this.getPayloadChannel());
                return false;
            }
        }
        MaLiLib.LOGGER.error("registerPlayReceiver: Channel ID [{}] is invalid, or not registered", (Object)this.getPayloadChannel());
        return false;
    }

    default public void unregisterPlayReceiver() {
        ClientPlayNetworking.unregisterGlobalReceiver((ResourceLocation)this.getPayloadChannel());
    }

    public void receivePlayPayload(T var1, ClientPlayNetworking.Context var2);

    default public void receivePlayPayload(T payload, ClientPacketListener handler, CallbackInfo ci) {
    }

    default public void decodeNbtCompound(ResourceLocation channel, CompoundTag data) {
    }

    default public void decodeByteBuf(ResourceLocation channel, MaLiLibBuf data) {
    }

    default public <D> void decodeObject(ResourceLocation channel, D data1) {
    }

    default public <P extends IClientPayloadData> void decodeClientData(ResourceLocation channel, P data) {
    }

    default public void encodeNbtCompound(CompoundTag data) {
    }

    default public void encodeByteBuf(MaLiLibBuf data) {
    }

    default public <D> void encodeObject(D data1) {
    }

    default public <P extends IClientPayloadData> void encodeClientData(P data) {
    }

    public void encodeWithSplitter(FriendlyByteBuf var1, ClientPacketListener var2);

    default public boolean sendPlayPayload(@Nonnull T payload) {
        if (payload.type().id().equals((Object)this.getPayloadChannel()) && this.isPlayRegistered(this.getPayloadChannel())) {
            if (ClientPlayNetworking.canSend((CustomPacketPayload.Type)payload.type())) {
                ClientPlayNetworking.send(payload);
                return true;
            }
        } else {
            MaLiLib.LOGGER.warn("sendPlayPayload: [Fabric-API] error sending payload for channel: {}, check if channel is registered", (Object)payload.type().id().toString());
        }
        return false;
    }

    default public boolean sendPlayPayload(@Nonnull ClientPacketListener handler, @Nonnull T payload) {
        if (payload.type().id().equals((Object)this.getPayloadChannel()) && this.isPlayRegistered(this.getPayloadChannel())) {
            ServerboundCustomPayloadPacket packet = new ServerboundCustomPayloadPacket(payload);
            if (handler.shouldHandleMessage((Packet)packet)) {
                handler.send((Packet)packet);
                return true;
            }
        } else {
            MaLiLib.LOGGER.warn("sendPlayPayload: [NetworkHandler] error sending payload for channel: {}, check if channel is registered", (Object)payload.type().id().toString());
        }
        return false;
    }
}

