/*
 * Decompiled with CFR 0.152.
 */
package journeymap.api.client.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.mojang.blaze3d.platform.NativeImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.api.v2.client.IClientPlugin;
import journeymap.api.v2.client.display.DisplayType;
import journeymap.api.v2.client.display.Displayable;
import journeymap.api.v2.client.display.ImageOverlay;
import journeymap.api.v2.client.display.MarkerOverlay;
import journeymap.api.v2.client.display.Overlay;
import journeymap.api.v2.client.display.PolygonOverlay;
import journeymap.api.v2.client.model.ShapeProperties;
import journeymap.api.v2.client.util.UIState;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.client.data.DataCache;
import journeymap.client.render.draw.DrawImageStep;
import journeymap.client.render.draw.DrawMarkerStep;
import journeymap.client.render.draw.DrawPolygonStep;
import journeymap.client.render.draw.OverlayDrawStep;
import journeymap.client.texture.ImageUtil;
import journeymap.client.texture.TextureAccess;
import journeymap.client.texture.TextureCache;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.CommonConstants;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.log.LogFormatter;
import journeymap.common.waypoint.WaypointIcon;
import journeymap.common.waypoint.WaypointImpl;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;

@ParametersAreNonnullByDefault
class PluginWrapper {
    private final IClientPlugin plugin;
    private final String modId;
    private final HashMap<String, HashBasedTable<String, Overlay, OverlayDrawStep>> dimensionOverlays = new HashMap();

    public PluginWrapper(IClientPlugin plugin) {
        this.modId = plugin.getModId();
        this.plugin = plugin;
    }

    public HashBasedTable<String, Overlay, OverlayDrawStep> getOverlays(ResourceKey<Level> dimension) {
        String dimName = DimensionHelper.getDimKeyName(dimension);
        HashBasedTable table = this.dimensionOverlays.get(dimName);
        if (table == null) {
            table = HashBasedTable.create();
            this.dimensionOverlays.put(dimName, (HashBasedTable<String, Overlay, OverlayDrawStep>)table);
        }
        return table;
    }

    public void show(Displayable displayable) throws Exception {
        String displayId = displayable.getId();
        switch (displayable.getDisplayType()) {
            case Polygon: {
                PolygonOverlay polygon = (PolygonOverlay)displayable;
                DrawPolygonStep polygonStep = DataCache.INSTANCE.getDrawPolygonStep(polygon);
                ShapeProperties prop = polygon.getShapeProperties();
                if (prop.getImage() != null || prop.getImageLocation() != null) {
                    polygonStep.setTextureResource(this.getPolygonImageResource(polygon));
                }
                polygonStep.setEnabled(true);
                this.getOverlays((ResourceKey<Level>)polygon.getDimension()).put((Object)displayId, (Object)polygon, (Object)polygonStep);
                break;
            }
            case Marker: {
                MarkerOverlay marker = (MarkerOverlay)displayable;
                DrawMarkerStep markerStep = DataCache.INSTANCE.getDrawMakerStep(marker);
                markerStep.setEnabled(true);
                this.getOverlays((ResourceKey<Level>)marker.getDimension()).put((Object)displayId, (Object)marker, (Object)markerStep);
                break;
            }
            case Image: {
                ImageOverlay imageOverlay = (ImageOverlay)displayable;
                DrawImageStep imageStep = DataCache.INSTANCE.getDrawImageStep(imageOverlay);
                imageStep.setEnabled(true);
                this.getOverlays((ResourceKey<Level>)imageOverlay.getDimension()).put((Object)displayId, (Object)imageOverlay, (Object)imageStep);
                break;
            }
        }
    }

    @Nullable
    public Waypoint getWaypoint(String guid) {
        ClientWaypointImpl waypoint = WaypointStore.getInstance().get(guid);
        if (waypoint != null && this.modId.equals(waypoint.getModId())) {
            return waypoint;
        }
        return null;
    }

    public List<Waypoint> getWaypoints() {
        return WaypointStore.getInstance().getAll().stream().filter(waypoint -> this.modId.equals(waypoint.getModId())).collect(Collectors.toList());
    }

    private ResourceLocation convertToFakeIcon(Waypoint waypoint) {
        ResourceLocation fakeLocation;
        TextureManager manager;
        WaypointIcon image = ((WaypointImpl)waypoint).getIcon();
        ResourceLocation resourceLocation = image.getResourceLocation();
        if (resourceLocation != null && (manager = Minecraft.getInstance().getTextureManager()).getTexture(fakeLocation = ResourceLocation.fromNamespaceAndPath((String)"fake", (String)resourceLocation.getPath()), null) == null) {
            try (NativeImage nativeImage = TextureCache.resolveImage(resourceLocation);){
                NativeImage img = ImageUtil.getScaledImage(4.0f, nativeImage, false);
                DynamicTexture scaledTexture = new DynamicTexture(img);
                manager.register(fakeLocation, (AbstractTexture)scaledTexture);
                ((TextureAccess)scaledTexture).journeymap$setDisplayHeight(image.getTextureHeight());
                ((TextureAccess)scaledTexture).journeymap$setDisplayWidth(image.getTextureWidth());
                TextureCache.modTextureMap.put(resourceLocation, fakeLocation);
            }
        }
        return resourceLocation;
    }

    private ResourceLocation getPolygonImageResource(PolygonOverlay polygon) {
        ResourceLocation oldLocation;
        TextureManager manager;
        ShapeProperties prop = polygon.getShapeProperties();
        NativeImage image = prop.getImage();
        ResourceLocation resourceLocation = prop.getImageLocation();
        if (image != null) {
            resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"fake", (String)CommonConstants.getSafeString(polygon.getGuid(), "-").toLowerCase(Locale.ROOT));
            NativeImage clonedImage = new NativeImage(image.getWidth(), image.getHeight(), false);
            clonedImage.copyFrom(image);
            DynamicTexture texture = new DynamicTexture(clonedImage);
            Minecraft.getInstance().getTextureManager().register(resourceLocation, (AbstractTexture)texture);
        } else if (resourceLocation != null && (manager = Minecraft.getInstance().getTextureManager()).getTexture(resourceLocation = ResourceLocation.fromNamespaceAndPath((String)"fake", (String)(oldLocation = resourceLocation).getPath()), null) == null) {
            try (NativeImage nativeImage = TextureCache.resolveImage(oldLocation);){
                NativeImage clonedImage = new NativeImage(nativeImage.getWidth(), nativeImage.getHeight(), false);
                clonedImage.copyFrom(nativeImage);
                DynamicTexture dynamicTexture = new DynamicTexture(clonedImage);
                manager.register(resourceLocation, (AbstractTexture)dynamicTexture);
            }
        }
        return resourceLocation;
    }

    public void remove(Displayable displayable) {
        String displayId = displayable.getId();
        try {
            Overlay overlay = (Overlay)displayable;
            OverlayDrawStep drawStep = (OverlayDrawStep)this.getOverlays((ResourceKey<Level>)overlay.getDimension()).remove((Object)displayId, (Object)displayable);
            if (drawStep != null) {
                drawStep.setEnabled(false);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error removing DrawMarkerStep: {}", (Object)LogFormatter.toString(t), (Object)t);
        }
    }

    public void remove(Waypoint wp) {
        ClientWaypointImpl waypoint = WaypointStore.getInstance().get(wp.getGuid());
        if (waypoint != null && wp.getModId().equals(waypoint.getModId())) {
            WaypointStore.getInstance().remove(waypoint, true);
        }
    }

    public void add(Waypoint waypoint) {
        if (((WaypointImpl)waypoint).getIcon() != null && !"journeymap".equals(((WaypointImpl)waypoint).getIcon().getResourceLocation().getNamespace())) {
            WaypointIcon icon = new WaypointIcon(this.convertToFakeIcon(waypoint));
            icon.setColor(((WaypointImpl)waypoint).getIcon().getColor());
            ((WaypointImpl)waypoint).setIcon(icon);
        }
        ((WaypointImpl)waypoint).setDirty(true);
        WaypointStore.getInstance().save((ClientWaypointImpl)waypoint, true);
    }

    public void removeAll(DisplayType displayType) {
        for (HashBasedTable<String, Overlay, OverlayDrawStep> overlays : this.dimensionOverlays.values()) {
            ArrayList list = new ArrayList(overlays.columnKeySet());
            for (Displayable displayable : list) {
                if (displayable.getDisplayType() != displayType) continue;
                this.remove(displayable);
                if (!(displayable instanceof PolygonOverlay)) continue;
                PolygonOverlay polygonOverlay = (PolygonOverlay)displayable;
                DataCache.INSTANCE.invalidatePolygon(polygonOverlay);
            }
        }
    }

    public void removeAllWaypoints() {
        List<ClientWaypointImpl> waypoints = WaypointStore.getInstance().getAll(this.modId);
        for (Waypoint waypoint : waypoints) {
            this.remove(waypoint);
        }
        if (!this.dimensionOverlays.isEmpty()) {
            this.dimensionOverlays.clear();
        }
    }

    public boolean exists(Displayable displayable) {
        String displayId = displayable.getId();
        if (displayable instanceof Overlay) {
            ResourceKey dimension = ((Overlay)displayable).getDimension();
            return this.getOverlays((ResourceKey<Level>)dimension).containsRow((Object)displayId);
        }
        return false;
    }

    public void getDrawSteps(List<OverlayDrawStep> list, UIState uiState) {
        HashBasedTable<String, Overlay, OverlayDrawStep> table = this.getOverlays((ResourceKey<Level>)uiState.dimension);
        for (Table.Cell cell : table.cellSet()) {
            if (!((Overlay)cell.getColumnKey()).isActiveIn(uiState)) continue;
            list.add((OverlayDrawStep)cell.getValue());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PluginWrapper)) {
            return false;
        }
        PluginWrapper that = (PluginWrapper)o;
        return Objects.equal((Object)this.modId, (Object)that.modId);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.modId});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this.plugin).add("modId", (Object)this.modId).toString();
    }
}

