/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.resources;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.conczin.immersive_paintings.Main;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import owens.oobjloader.Builder;
import owens.oobjloader.Face;

public class ObjectLoader
extends SimplePreparableReloadListener<Map<ResourceLocation, Resource>> {
    protected static final ResourceLocation ID = Main.locate("objects");
    public static final Map<ResourceLocation, List<Face>> objects = new HashMap<ResourceLocation, List<Face>>();

    protected Map<ResourceLocation, Resource> prepare(ResourceManager manager, ProfilerFiller profiler) {
        return manager.listResources("objects", n -> n.getPath().endsWith(".obj"));
    }

    protected void apply(Map<ResourceLocation, Resource> o, ResourceManager manager, ProfilerFiller profiler) {
        objects.clear();
        o.forEach((id, res) -> {
            try {
                InputStream stream = res.open();
                ArrayList<Face> faces = new Builder((BufferedReader)new BufferedReader((Reader)new InputStreamReader((InputStream)stream))).faces;
                ResourceLocation newId = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)id.getPath());
                objects.put(newId, faces);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

