/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Optional;
import net.conczin.immersive_paintings.ClientPaintingManager;
import net.conczin.immersive_paintings.Main;
import net.conczin.immersive_paintings.Painting;
import net.conczin.immersive_paintings.config.ClientConfig;
import net.conczin.immersive_paintings.entity.ImmersivePaintingEntity;
import net.conczin.immersive_paintings.registration.Configs;
import net.conczin.immersive_paintings.resources.ObjectLoader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import owens.oobjloader.Face;
import owens.oobjloader.FaceVertex;

public class ImmersivePaintingEntityRenderer<T extends ImmersivePaintingEntity>
extends EntityRenderer<T> {
    public ImmersivePaintingEntityRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(T entity, float yaw, float tickDelta, PoseStack poses, MultiBufferSource buffer, int light) {
        poses.pushPose();
        poses.mulPose(Axis.YP.rotationDegrees(-yaw));
        poses.mulPose(Axis.XP.rotationDegrees(-entity.getViewXRot(tickDelta)));
        poses.scale(0.0625f, 0.0625f, 0.0625f);
        this.renderPainting(poses, buffer, entity);
        poses.popPose();
        super.render(entity, yaw, tickDelta, poses, buffer, light);
    }

    public ResourceLocation getTextureLocation(T paintingEntity) {
        Minecraft client = Minecraft.getInstance();
        ClientConfig config = Configs.CLIENT;
        double distance = client.player == null ? 0.0f : client.player.distanceTo(paintingEntity);
        double blocksVisible = Math.tan((double)((Integer)client.options.fov().get()).intValue() / 180.0 * Math.PI / 2.0) * 2.0 * distance;
        Optional<Painting> painting = ClientPaintingManager.getPainting(((ImmersivePaintingEntity)((Object)paintingEntity)).getMotive());
        if (painting.isEmpty()) {
            return ClientPaintingManager.getImageIdentifier(Painting.DEFAULT_IDENTIFIER, Painting.Size.FULL);
        }
        int resolution = painting.get().resolution();
        double pixelDensity = blocksVisible * (double)resolution / (double)client.getWindow().getHeight();
        Painting.Size size = pixelDensity > (double)config.thumbResolutionThreshold ? Painting.Size.THUMBNAIL : (pixelDensity > (double)config.eighthResolutionThreshold ? Painting.Size.EIGHTH : (pixelDensity > (double)config.quarterResolutionThreshold ? Painting.Size.QUARTER : (pixelDensity > (double)config.halfResolutionThreshold ? Painting.Size.HALF : Painting.Size.FULL)));
        return ClientPaintingManager.getImageIdentifier(((ImmersivePaintingEntity)((Object)paintingEntity)).getMotive(), size);
    }

    protected int getLight(int light, boolean glowing) {
        if (!glowing) {
            return light;
        }
        return LightTexture.pack((int)((int)((double)LightTexture.block((int)light) * 0.25 + 11.25)), (int)LightTexture.sky((int)light));
    }

    protected int getFrameLight(int light, boolean glowing) {
        if (!glowing) {
            return light;
        }
        return LightTexture.pack((int)((int)((double)LightTexture.block((int)light) * 0.875 + 2.0)), (int)LightTexture.sky((int)light));
    }

    private void renderPainting(PoseStack poses, MultiBufferSource buffer, T entity) {
        int light = LevelRenderer.getLightColor((BlockAndTintGetter)entity.level(), (BlockPos)entity.blockPosition());
        PoseStack.Pose pose = poses.last();
        boolean hasFrame = !((ImmersivePaintingEntity)((Object)entity)).getFrame().getPath().equals("none");
        int widthPixels = ((ImmersivePaintingEntity)((Object)entity)).getPaintingWidth() * 16;
        int heightPixels = ((ImmersivePaintingEntity)((Object)entity)).getPaintingHeight() * 16;
        boolean glowing = ((ImmersivePaintingEntity)((Object)entity)).isGlowing();
        boolean graffiti = ((ImmersivePaintingEntity)((Object)entity)).isGraffiti();
        VertexConsumer vertexConsumer = buffer.getBuffer(graffiti ? RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(entity)) : RenderType.entitySolid((ResourceLocation)this.getTextureLocation(entity)));
        this.renderFaces(graffiti ? "objects/graffiti.obj" : "objects/canvas.obj", pose, vertexConsumer, this.getLight(light, glowing), widthPixels, heightPixels, hasFrame ? 1.0f : 0.0f);
        if (hasFrame) {
            vertexConsumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)((ImmersivePaintingEntity)((Object)entity)).getMaterial()));
            this.renderFrame(((ImmersivePaintingEntity)((Object)entity)).getFrame(), pose, vertexConsumer, this.getFrameLight(light, glowing), widthPixels, heightPixels);
        }
    }

    private void renderFaces(String name, PoseStack.Pose pose, VertexConsumer vertexConsumer, int light, float width, float height, float margin) {
        List<Face> faces = ObjectLoader.objects.get(Main.locate(name));
        for (Face face : faces) {
            for (FaceVertex v : face.vertices) {
                this.vertex(pose, vertexConsumer, v.v.x * (width - margin * 2.0f), v.v.y * (height - margin * 2.0f), v.v.z * 16.0f, v.t.u * (width - margin * 2.0f) / width + margin / width, (1.0f - v.t.v) * (height - margin * 2.0f) / height + margin / height, v.n.x, v.n.y, v.n.z, light);
            }
        }
    }

    private List<Face> getFaces(ResourceLocation frame, String part) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)frame.getNamespace(), (String)(frame.getPath() + "/" + part + ".obj"));
        if (ObjectLoader.objects.containsKey(id)) {
            return ObjectLoader.objects.get(id);
        }
        return List.of();
    }

    private void renderFrame(ResourceLocation frame, PoseStack.Pose pose, VertexConsumer vertexConsumer, int light, float width, float height) {
        float u;
        List<Face> faces = this.getFaces(frame, "bottom");
        int x = 0;
        while ((float)x < width / 16.0f) {
            u = width == 16.0f ? 0.75f : (x == 0 ? 0.0f : ((float)x == width / 16.0f - 1.0f ? 0.5f : 0.25f));
            for (Face face : faces) {
                for (FaceVertex v : face.vertices) {
                    this.vertex(pose, vertexConsumer, v.v.x + (float)(x * 16) - (width - 16.0f) / 2.0f, v.v.y - (height - 16.0f) / 2.0f, v.v.z, v.t.u * 0.25f + u, 1.0f - v.t.v, v.n.x, v.n.y, v.n.z, light);
                }
            }
            ++x;
        }
        faces = this.getFaces(frame, "top");
        x = 0;
        while ((float)x < width / 16.0f) {
            u = width == 16.0f ? 0.75f : (x == 0 ? 0.0f : ((float)x == width / 16.0f - 1.0f ? 0.5f : 0.25f));
            for (Face face : faces) {
                for (FaceVertex v : face.vertices) {
                    this.vertex(pose, vertexConsumer, v.v.x + (float)(x * 16) - (width - 16.0f) / 2.0f, v.v.y + (height - 16.0f) / 2.0f, v.v.z, v.t.u * 0.25f + u, 1.0f - v.t.v, v.n.x, v.n.y, v.n.z, light);
                }
            }
            ++x;
        }
        faces = this.getFaces(frame, "right");
        int y = 0;
        while ((float)y < height / 16.0f) {
            u = 0.25f;
            for (Face face : faces) {
                for (FaceVertex v : face.vertices) {
                    this.vertex(pose, vertexConsumer, v.v.x + (width - 16.0f) / 2.0f, v.v.y + (float)(y * 16) - (height - 16.0f) / 2.0f, v.v.z, v.t.u * 0.25f + u, 1.0f - v.t.v, v.n.x, v.n.y, v.n.z, light);
                }
            }
            ++y;
        }
        faces = this.getFaces(frame, "left");
        y = 0;
        while ((float)y < height / 16.0f) {
            u = 0.25f;
            for (Face face : faces) {
                for (FaceVertex v : face.vertices) {
                    this.vertex(pose, vertexConsumer, v.v.x - (width - 16.0f) / 2.0f, v.v.y + (float)(y * 16) - (height - 16.0f) / 2.0f, v.v.z, v.t.u * 0.25f + u, 1.0f - v.t.v, v.n.x, v.n.y, v.n.z, light);
                }
            }
            ++y;
        }
    }

    private void vertex(PoseStack.Pose pose, VertexConsumer vertexConsumer, float x, float y, float z, float u, float v, float normalX, float normalY, float normalZ, int light) {
        vertexConsumer.addVertex(pose, x, y, z - 0.5f).setColor(255, 255, 255, 255).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, normalX, normalY, normalZ);
    }
}

