/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.snbt;

import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import java.lang.runtime.SwitchBootstraps;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.Nullable;

public class SNBTNet {
    public static final ByteArrayTag EMPTY_BYTE_ARRAY = new ByteArrayTag(new byte[0]);
    public static final IntArrayTag EMPTY_INT_ARRAY = new IntArrayTag(new int[0]);
    public static final LongArrayTag EMPTY_LONG_ARRAY = new LongArrayTag(new long[0]);

    public static void write(FriendlyByteBuf buf, @Nullable Tag tag) {
        Tag tag2 = tag;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ByteTag.class, ShortTag.class, IntTag.class, LongTag.class, FloatTag.class, DoubleTag.class, ByteArrayTag.class, StringTag.class, ListTag.class, CompoundTag.class, IntArrayTag.class, LongArrayTag.class}, (Object)tag2, n)) {
            case 0: {
                ByteTag byteTag = (ByteTag)tag2;
                buf.writeByte((int)byteTag.getAsByte());
                break;
            }
            case 1: {
                ShortTag shortTag = (ShortTag)tag2;
                buf.writeShort((int)shortTag.getAsShort());
                break;
            }
            case 2: {
                IntTag intTag = (IntTag)tag2;
                buf.writeInt(intTag.getAsInt());
                break;
            }
            case 3: {
                LongTag longTag = (LongTag)tag2;
                buf.writeLong(longTag.getAsLong());
                break;
            }
            case 4: {
                FloatTag floatTag = (FloatTag)tag2;
                buf.writeFloat(floatTag.getAsFloat());
                break;
            }
            case 5: {
                DoubleTag doubleTag = (DoubleTag)tag2;
                buf.writeDouble(doubleTag.getAsDouble());
                break;
            }
            case 6: {
                ByteArrayTag byteTags = (ByteArrayTag)tag2;
                SNBTNet.writeByteArray(buf, byteTags);
                break;
            }
            case 7: {
                StringTag stringTag = (StringTag)tag2;
                buf.writeUtf(stringTag.getAsString(), Short.MAX_VALUE);
                break;
            }
            case 8: {
                ListTag tags = (ListTag)tag2;
                SNBTNet.writeList(buf, tags);
                break;
            }
            case 9: {
                CompoundTag compoundTag = (CompoundTag)tag2;
                SNBTNet.writeCompound(buf, SNBTCompoundTag.of((Tag)compoundTag));
                break;
            }
            case 10: {
                IntArrayTag intTags = (IntArrayTag)tag2;
                SNBTNet.writeIntArray(buf, intTags);
                break;
            }
            case 11: {
                LongArrayTag longTags = (LongArrayTag)tag2;
                SNBTNet.writeLongArray(buf, longTags);
                break;
            }
        }
    }

    public static void writeCompound(FriendlyByteBuf buf, @Nullable SNBTCompoundTag tag) {
        if (tag == null) {
            buf.writeVarInt(-1);
            return;
        }
        buf.writeVarInt(tag.getAllKeys().size());
        for (String s : tag.getAllKeys()) {
            buf.writeUtf(s, Short.MAX_VALUE);
            buf.writeByte((int)tag.get(s).getId());
            SNBTNet.write(buf, tag.get(s));
        }
    }

    public static void writeList(FriendlyByteBuf buf, @Nullable ListTag tag) {
        if (tag == null) {
            buf.writeVarInt(-1);
            return;
        }
        buf.writeVarInt(tag.size());
        if (!tag.isEmpty()) {
            buf.writeByte((int)tag.getElementType());
            for (Tag value : tag) {
                SNBTNet.write(buf, value);
            }
        }
    }

    public static void writeByteArray(FriendlyByteBuf buf, @Nullable ByteArrayTag tag) {
        if (tag == null) {
            buf.writeVarInt(-1);
            return;
        }
        buf.writeVarInt(tag.size());
        for (byte v : tag.getAsByteArray()) {
            buf.writeByte((int)v);
        }
    }

    public static void writeIntArray(FriendlyByteBuf buf, @Nullable IntArrayTag tag) {
        if (tag == null) {
            buf.writeVarInt(-1);
            return;
        }
        buf.writeVarInt(tag.size());
        for (int v : tag.getAsIntArray()) {
            buf.writeInt(v);
        }
    }

    public static void writeLongArray(FriendlyByteBuf buf, @Nullable LongArrayTag tag) {
        if (tag == null) {
            buf.writeVarInt(-1);
            return;
        }
        buf.writeVarInt(tag.size());
        for (long v : tag.getAsLongArray()) {
            buf.writeLong(v);
        }
    }

    @Nullable
    public static Tag read(byte type, FriendlyByteBuf buf) {
        return switch (type) {
            case 0 -> EndTag.INSTANCE;
            case 1 -> ByteTag.valueOf((byte)buf.readByte());
            case 2 -> ShortTag.valueOf((short)buf.readShort());
            case 3 -> IntTag.valueOf((int)buf.readInt());
            case 4 -> LongTag.valueOf((long)buf.readLong());
            case 5 -> FloatTag.valueOf((float)buf.readFloat());
            case 6 -> DoubleTag.valueOf((double)buf.readDouble());
            case 7 -> SNBTNet.readByteArray(buf);
            case 8 -> StringTag.valueOf((String)buf.readUtf(Short.MAX_VALUE));
            case 9 -> SNBTNet.readList(buf);
            case 10 -> SNBTNet.readCompound(buf);
            case 11 -> SNBTNet.readIntArray(buf);
            case 12 -> SNBTNet.readLongArray(buf);
            default -> null;
        };
    }

    @Nullable
    public static SNBTCompoundTag readCompound(FriendlyByteBuf buf) {
        int len = buf.readVarInt();
        if (len == -1) {
            return null;
        }
        SNBTCompoundTag tag = new SNBTCompoundTag();
        for (int i = 0; i < len; ++i) {
            String key = buf.readUtf(Short.MAX_VALUE);
            byte type = buf.readByte();
            tag.put(key, SNBTNet.read(type, buf));
        }
        return tag;
    }

    @Nullable
    public static ListTag readList(FriendlyByteBuf buf) {
        int len = buf.readVarInt();
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return new ListTag();
        }
        byte type = buf.readByte();
        ListTag tag = new ListTag();
        for (int i = 0; i < len; ++i) {
            tag.add((Object)SNBTNet.read(type, buf));
        }
        return tag;
    }

    public static ByteArrayTag readByteArray(FriendlyByteBuf buf) {
        int len = buf.readVarInt();
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] values = new byte[len];
        for (int i = 0; i < len; ++i) {
            values[i] = buf.readByte();
        }
        return new ByteArrayTag(values);
    }

    public static IntArrayTag readIntArray(FriendlyByteBuf buf) {
        int len = buf.readVarInt();
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] values = new int[len];
        for (int i = 0; i < len; ++i) {
            values[i] = buf.readInt();
        }
        return new IntArrayTag(values);
    }

    public static LongArrayTag readLongArray(FriendlyByteBuf buf) {
        int len = buf.readVarInt();
        if (len == -1) {
            return null;
        }
        if (len == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] values = new long[len];
        for (int i = 0; i < len; ++i) {
            values[i] = buf.readLong();
        }
        return new LongArrayTag(values);
    }
}

