/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import fi.dy.masa.litematica.Litematica;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.world.phys.Vec3;

@Deprecated(forRemoval=true)
public class NbtUtils {
    @Nullable
    public static BlockPos readBlockPosFromArrayTag(CompoundTag tag, String tagName) {
        int[] pos;
        if (tag.contains(tagName, 11) && (pos = tag.getIntArray("Pos")).length == 3) {
            return new BlockPos(pos[0], pos[1], pos[2]);
        }
        return null;
    }

    @Nullable
    public static Vec3 readVec3dFromListTag(@Nullable CompoundTag tag) {
        return NbtUtils.readVec3dFromListTag(tag, "Pos");
    }

    @Nullable
    public static Vec3 readVec3dFromListTag(@Nullable CompoundTag tag, String tagName) {
        ListTag tagList;
        if (tag != null && tag.contains(tagName, 9) && (tagList = tag.getList(tagName, 6)).getElementType() == 6 && tagList.size() == 3) {
            return new Vec3(tagList.getDouble(0), tagList.getDouble(1), tagList.getDouble(2));
        }
        return null;
    }

    @Nullable
    public static Vec3i readVec3iFromIntArray(@Nullable CompoundTag tag, String tagName) {
        int[] arr;
        if (tag != null && tag.contains(tagName, 11) && (arr = tag.getIntArray(tagName)) != null && arr.length == 3) {
            return new Vec3i(arr[0], arr[1], arr[2]);
        }
        return null;
    }

    @Nullable
    public static CompoundTag readNbtFromFile(File file) {
        FileInputStream is;
        if (!file.exists() || !file.canRead()) {
            return null;
        }
        try {
            is = new FileInputStream(file);
        }
        catch (Exception e) {
            Litematica.LOGGER.warn("Failed to read NBT data from file '{}' (failed to create the input stream)", (Object)file.getAbsolutePath());
            return null;
        }
        CompoundTag nbt = null;
        if (is != null) {
            try {
                nbt = NbtIo.readCompressed((InputStream)is, (NbtAccounter)NbtAccounter.unlimitedHeap());
            }
            catch (Exception e) {
                try {
                    is.close();
                    is = new FileInputStream(file);
                    nbt = NbtIo.read((Path)file.toPath());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                is.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (nbt == null) {
            Litematica.LOGGER.warn("Failed to read NBT data from file '{}'", (Object)file.getAbsolutePath());
        }
        return nbt;
    }
}

