/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.mixin.entity.IMixinEntity;
import fi.dy.masa.litematica.mixin.world.IMixinWorld;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SubRegionPlacement;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.malilib.util.InventoryUtils;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Leashable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.LeashFenceKnotEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.ApiStatus;

public class EntityUtils {
    public static final Predicate<Entity> NOT_PLAYER = entity -> !(entity instanceof Player);

    public static boolean isCreativeMode(Player player) {
        return player.getAbilities().instabuild;
    }

    public static boolean hasToolItem(LivingEntity entity) {
        return EntityUtils.hasToolItemInHand(entity, InteractionHand.MAIN_HAND) || EntityUtils.hasToolItemInHand(entity, InteractionHand.OFF_HAND);
    }

    public static boolean hasToolItemInHand(LivingEntity entity, InteractionHand hand) {
        if (DataManager.getInstance().hasToolItemComponents()) {
            ItemStack toolItem = DataManager.getInstance().getToolItemComponents();
            ItemStack stackHand = entity.getItemInHand(hand);
            if (toolItem != null) {
                return InventoryUtils.areStacksAndNbtEqual((ItemStack)toolItem, (ItemStack)stackHand);
            }
            return false;
        }
        ItemStack toolItem = DataManager.getToolItem();
        if (toolItem.isEmpty()) {
            return entity.getMainHandItem().isEmpty();
        }
        ItemStack stackHand = entity.getItemInHand(hand);
        return InventoryUtils.areStacksEqualIgnoreNbt((ItemStack)toolItem, (ItemStack)stackHand);
    }

    @Nullable
    public static InteractionHand getUsedHandForItem(Player player, ItemStack stack) {
        InteractionHand hand = null;
        if (InventoryUtils.areStacksEqualIgnoreNbt((ItemStack)player.getMainHandItem(), (ItemStack)stack)) {
            hand = InteractionHand.MAIN_HAND;
        } else if (player.getMainHandItem().isEmpty() && InventoryUtils.areStacksEqualIgnoreNbt((ItemStack)player.getOffhandItem(), (ItemStack)stack)) {
            hand = InteractionHand.OFF_HAND;
        }
        return hand;
    }

    public static boolean areStacksEqualIgnoreDurability(ItemStack stack1, ItemStack stack2) {
        return InventoryUtils.areStacksEqualIgnoreDurability((ItemStack)stack1, (ItemStack)stack2);
    }

    public static Direction getHorizontalLookingDirection(Entity entity) {
        return Direction.fromYRot((double)entity.getYRot());
    }

    public static Direction getVerticalLookingDirection(Entity entity) {
        return entity.getXRot() > 0.0f ? Direction.DOWN : Direction.UP;
    }

    public static Direction getClosestLookingDirection(Entity entity) {
        if (entity.getXRot() > 60.0f) {
            return Direction.DOWN;
        }
        if (-entity.getXRot() > 60.0f) {
            return Direction.UP;
        }
        return EntityUtils.getHorizontalLookingDirection(entity);
    }

    @Nullable
    public static <T extends Entity> T findEntityByUUID(List<T> list, UUID uuid) {
        if (uuid == null) {
            return null;
        }
        for (Entity entity : list) {
            if (!entity.getUUID().equals(uuid)) continue;
            return (T)entity;
        }
        return null;
    }

    @Nullable
    public static String getEntityId(Entity entity) {
        EntityType entitytype = entity.getType();
        ResourceLocation resourcelocation = EntityType.getKey((EntityType)entitytype);
        return entitytype.canSerialize() && resourcelocation != null ? resourcelocation.toString() : null;
    }

    @Nullable
    private static Entity createEntityFromNBTSingle(CompoundTag nbt, Level world) {
        try {
            Optional optional = EntityType.create((CompoundTag)nbt, (Level)world);
            if (optional.isPresent()) {
                Entity entity = (Entity)optional.get();
                entity.setUUID(UUID.randomUUID());
                return entity;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    public static Entity createEntityAndPassengersFromNBT(CompoundTag nbt, Level world) {
        Entity entity = EntityUtils.createEntityFromNBTSingle(nbt, world);
        if (entity == null) {
            return null;
        }
        if (nbt.contains("Passengers", 9)) {
            ListTag taglist = nbt.getList("Passengers", 10);
            for (int i = 0; i < taglist.size(); ++i) {
                Entity passenger = EntityUtils.createEntityAndPassengersFromNBT(taglist.getCompound(i), world);
                if (passenger == null) continue;
                passenger.startRiding(entity, true);
            }
        }
        return entity;
    }

    public static void spawnEntityAndPassengersInWorld(Entity entity, Level world) {
        if (world.addFreshEntity(entity) && entity.isVehicle()) {
            for (Entity passenger : entity.getPassengers()) {
                passenger.moveTo(entity.getX(), entity.getY() + entity.getPassengerRidingPosition(passenger).y(), entity.getZ(), passenger.getYRot(), passenger.getXRot());
                EntityUtils.setEntityRotations(passenger, passenger.getYRot(), passenger.getXRot());
                EntityUtils.spawnEntityAndPassengersInWorld(passenger, world);
            }
        }
    }

    public static void setEntityRotations(Entity entity, float yaw, float pitch) {
        entity.setYRot(yaw);
        entity.yRotO = yaw;
        entity.setXRot(pitch);
        entity.xRotO = pitch;
        if (entity instanceof LivingEntity) {
            LivingEntity livingBase = (LivingEntity)entity;
            livingBase.yHeadRot = yaw;
            livingBase.yBodyRot = yaw;
            livingBase.yHeadRotO = yaw;
            livingBase.yBodyRotO = yaw;
        }
    }

    public static List<Entity> getEntitiesWithinSubRegion(Level world, BlockPos origin, BlockPos regionPos, BlockPos regionSize, SchematicPlacement schematicPlacement, SubRegionPlacement placement) {
        BlockPos regionPosRelTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        BlockPos posEndAbs = PositionUtils.getTransformedPlacementPosition(regionSize.offset(-1, -1, -1), schematicPlacement, placement).offset((Vec3i)regionPosRelTransformed).offset((Vec3i)origin);
        BlockPos regionPosAbs = regionPosRelTransformed.offset((Vec3i)origin);
        AABB bb = PositionUtils.createEnclosingAABB(regionPosAbs, posEndAbs);
        return world.getEntities(null, bb, NOT_PLAYER);
    }

    public static boolean shouldPickBlock(Player player) {
        return Configs.Generic.PICK_BLOCK_ENABLED.getBooleanValue() && (!Configs.Generic.TOOL_ITEM_ENABLED.getBooleanValue() || !EntityUtils.hasToolItem((LivingEntity)player)) && Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue();
    }

    @Deprecated
    public static void loadNbtIntoEntity(Entity entity, CompoundTag nbt) {
        entity.fallDistance = nbt.getFloat("FallDistance");
        entity.setRemainingFireTicks((int)nbt.getShort("Fire"));
        if (nbt.contains("Air")) {
            entity.setAirSupply((int)nbt.getShort("Air"));
        }
        entity.setOnGround(nbt.getBoolean("OnGround"));
        entity.setInvulnerable(nbt.getBoolean("Invulnerable"));
        entity.setPortalCooldown(nbt.getInt("PortalCooldown"));
        if (nbt.hasUUID("UUID")) {
            entity.setUUID(nbt.getUUID("UUID"));
        }
        if (nbt.contains("CustomName", 8)) {
            String string = nbt.getString("CustomName");
            entity.setCustomName((Component)Component.Serializer.fromJson((String)string, (HolderLookup.Provider)entity.registryAccess()));
        }
        entity.setCustomNameVisible(nbt.getBoolean("CustomNameVisible"));
        entity.setSilent(nbt.getBoolean("Silent"));
        entity.setNoGravity(nbt.getBoolean("NoGravity"));
        entity.setGlowingTag(nbt.getBoolean("Glowing"));
        entity.setTicksFrozen(nbt.getInt("TicksFrozen"));
        if (nbt.contains("Tags", 9)) {
            entity.getTags().clear();
            ListTag nbtList4 = nbt.getList("Tags", 8);
            int max = Math.min(nbtList4.size(), 1024);
            for (int i = 0; i < max; ++i) {
                entity.getTags().add(nbtList4.getString(i));
            }
        }
        if (entity instanceof Leashable) {
            EntityUtils.readLeashableEntityCustomData(entity, nbt);
        } else {
            ((IMixinEntity)entity).litematica_readCustomDataFromNbt(nbt);
        }
    }

    @Deprecated
    private static void readLeashableEntityCustomData(Entity entity, CompoundTag nbt) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        assert (entity instanceof Leashable);
        Leashable leashable = (Leashable)entity;
        ((IMixinEntity)entity).litematica_readCustomDataFromNbt(nbt);
        if (leashable.getLeashData() != null && leashable.getLeashData().delayedLeashInfo != null) {
            leashable.getLeashData().delayedLeashInfo.ifLeft(uuid -> leashable.setLeashedTo((Entity)((IMixinWorld)mc.level).litematica_getEntityLookup().get(uuid), false)).ifRight(pos -> leashable.setLeashedTo((Entity)LeashFenceKnotEntity.getOrCreateKnot((Level)mc.level, (BlockPos)pos), false));
        }
    }

    @ApiStatus.Experimental
    public static boolean setFakedSneakingState(boolean sneaking) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player != null && player.isShiftKeyDown() != sneaking) {
            player.setShiftKeyDown(sneaking);
            return true;
        }
        return false;
    }

    @Nullable
    @ApiStatus.Experimental
    public static InteractionHand getUsedHandForItem(LivingEntity entity, ItemStack stack, boolean lenient) {
        InteractionHand hand = null;
        InteractionHand tmpHand = entity.getMainHandItem().isEmpty() ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack handStack = entity.getItemInHand(tmpHand);
        if (lenient && InventoryUtils.areStacksEqualIgnoreDurability((ItemStack)handStack, (ItemStack)stack) || !lenient && InventoryUtils.areStacksEqual((ItemStack)handStack, (ItemStack)stack)) {
            hand = tmpHand;
        }
        return hand;
    }
}

