/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.config.Hotkeys;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.render.schematic.BlockModelRendererSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDataSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDispatcherLitematica;
import fi.dy.masa.litematica.render.schematic.ChunkRenderDispatcherSchematic;
import fi.dy.masa.litematica.render.schematic.ChunkRenderLayers;
import fi.dy.masa.litematica.render.schematic.ChunkRendererSchematicVbo;
import fi.dy.masa.litematica.render.schematic.IChunkRendererFactory;
import fi.dy.masa.litematica.render.schematic.OverlayRenderType;
import fi.dy.masa.litematica.world.ChunkSchematic;
import fi.dy.masa.litematica.world.WorldSchematic;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.LayerRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

public class WorldRendererSchematic {
    private final Minecraft mc;
    private final EntityRenderDispatcher entityRenderDispatcher;
    private final BlockRenderDispatcher blockRenderManager;
    private final BlockModelRendererSchematic blockModelRenderer;
    private final Set<BlockEntity> blockEntities = new HashSet<BlockEntity>();
    private final List<ChunkRendererSchematicVbo> renderInfos = new ArrayList<ChunkRendererSchematicVbo>(1024);
    private final RenderBuffers bufferBuilders;
    private Set<ChunkRendererSchematicVbo> chunksToUpdate = new LinkedHashSet<ChunkRendererSchematicVbo>();
    private WorldSchematic world;
    private ChunkRenderDispatcherSchematic chunkRendererDispatcher;
    private double lastCameraChunkUpdateX = Double.MIN_VALUE;
    private double lastCameraChunkUpdateY = Double.MIN_VALUE;
    private double lastCameraChunkUpdateZ = Double.MIN_VALUE;
    private double lastCameraX = Double.MIN_VALUE;
    private double lastCameraY = Double.MIN_VALUE;
    private double lastCameraZ = Double.MIN_VALUE;
    private float lastCameraPitch = Float.MIN_VALUE;
    private float lastCameraYaw = Float.MIN_VALUE;
    private ChunkRenderDispatcherLitematica renderDispatcher;
    private final IChunkRendererFactory renderChunkFactory;
    private int renderDistanceChunks = -1;
    private int renderEntitiesStartupCounter = 2;
    private int countEntitiesTotal;
    private int countEntitiesRendered;
    private int countEntitiesHidden;
    private double lastTranslucentSortX;
    private double lastTranslucentSortY;
    private double lastTranslucentSortZ;
    private boolean displayListEntitiesDirty = true;

    public WorldRendererSchematic(Minecraft mc) {
        this.mc = mc;
        this.entityRenderDispatcher = mc.getEntityRenderDispatcher();
        this.bufferBuilders = mc.renderBuffers();
        this.renderChunkFactory = (world1, worldRenderer) -> new ChunkRendererSchematicVbo(world1, worldRenderer);
        this.blockRenderManager = Minecraft.getInstance().getBlockRenderer();
        this.blockModelRenderer = new BlockModelRendererSchematic(mc.getBlockColors());
        this.blockModelRenderer.setBakedManager(mc.getModelManager());
    }

    public void markNeedsUpdate() {
        this.displayListEntitiesDirty = true;
    }

    public boolean hasWorld() {
        return this.world != null;
    }

    public String getDebugInfoRenders() {
        int rcTotal = this.chunkRendererDispatcher != null ? this.chunkRendererDispatcher.getRendererCount() : 0;
        int rcRendered = this.chunkRendererDispatcher != null ? this.getRenderedChunks() : 0;
        return String.format("C: %d/%d %sD: %d, L: %d, %s", rcRendered, rcTotal, this.mc.smartCull ? "(s) " : "", this.renderDistanceChunks, 0, this.renderDispatcher == null ? "null" : this.renderDispatcher.getDebugInfo());
    }

    public String getDebugInfoEntities() {
        return "E: " + this.countEntitiesRendered + "/" + this.countEntitiesTotal + ", B: " + this.countEntitiesHidden;
    }

    protected int getRenderedChunks() {
        int count = 0;
        for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
            ChunkRenderDataSchematic data = chunkRenderer.chunkRenderData;
            if (data == ChunkRenderDataSchematic.EMPTY || data.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    protected ProfilerFiller getProfiler() {
        if (this.world == null && this.mc != null) {
            return this.mc.getProfiler();
        }
        return this.world.getProfiler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWorldAndLoadRenderers(@Nullable WorldSchematic worldSchematic) {
        this.lastCameraChunkUpdateX = Double.MIN_VALUE;
        this.lastCameraChunkUpdateY = Double.MIN_VALUE;
        this.lastCameraChunkUpdateZ = Double.MIN_VALUE;
        this.world = worldSchematic;
        if (worldSchematic != null) {
            this.loadRenderers();
        } else {
            this.chunksToUpdate.forEach(ChunkRendererSchematicVbo::deleteGlResources);
            this.chunksToUpdate.clear();
            this.renderInfos.forEach(ChunkRendererSchematicVbo::deleteGlResources);
            this.renderInfos.clear();
            if (this.chunkRendererDispatcher != null) {
                this.chunkRendererDispatcher.delete();
                this.chunkRendererDispatcher = null;
            }
            if (this.renderDispatcher != null) {
                this.renderDispatcher.stopWorkerThreads();
            }
            this.renderDispatcher = null;
            Set<BlockEntity> set = this.blockEntities;
            synchronized (set) {
                this.blockEntities.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadRenderers() {
        if (this.hasWorld()) {
            this.getProfiler().push("load_renderers");
            if (this.renderDispatcher == null) {
                this.renderDispatcher = new ChunkRenderDispatcherLitematica();
            }
            this.displayListEntitiesDirty = true;
            this.renderDistanceChunks = (Integer)this.mc.options.renderDistance().get() + 2;
            if (this.chunkRendererDispatcher != null) {
                this.chunkRendererDispatcher.delete();
            }
            this.stopChunkUpdates();
            Set<BlockEntity> set = this.blockEntities;
            synchronized (set) {
                this.blockEntities.clear();
            }
            this.chunkRendererDispatcher = new ChunkRenderDispatcherSchematic(this.world, this.renderDistanceChunks, this, this.renderChunkFactory);
            this.renderEntitiesStartupCounter = 2;
            this.getProfiler().pop();
        }
    }

    protected void stopChunkUpdates() {
        if (!this.chunksToUpdate.isEmpty()) {
            this.chunksToUpdate.forEach(ChunkRendererSchematicVbo::deleteGlResources);
        }
        this.chunksToUpdate.clear();
        this.renderDispatcher.stopChunkUpdates();
    }

    public void setupTerrain(Camera camera, Frustum frustum, int frameCount, boolean playerSpectator) {
        Entity entity;
        this.getProfiler().push("setup_terrain");
        if (this.chunkRendererDispatcher == null || (Integer)this.mc.options.renderDistance().get() + 2 != this.renderDistanceChunks) {
            this.loadRenderers();
        }
        if ((entity = EntityUtils.getCameraEntity()) == null) {
            entity = this.mc.player;
        }
        this.getProfiler().popPush("camera");
        double entityX = entity.getX();
        double entityY = entity.getY();
        double entityZ = entity.getZ();
        double diffX = entityX - this.lastCameraChunkUpdateX;
        double diffY = entityY - this.lastCameraChunkUpdateY;
        double diffZ = entityZ - this.lastCameraChunkUpdateZ;
        if (diffX * diffX + diffY * diffY + diffZ * diffZ > 256.0) {
            this.lastCameraChunkUpdateX = entityX;
            this.lastCameraChunkUpdateY = entityY;
            this.lastCameraChunkUpdateZ = entityZ;
            this.chunkRendererDispatcher.removeOutOfRangeRenderers();
        }
        this.getProfiler().popPush("renderlist_camera");
        Vec3 cameraPos = camera.getPosition();
        double cameraX = cameraPos.x;
        double cameraY = cameraPos.y;
        double cameraZ = cameraPos.z;
        this.renderDispatcher.setCameraPosition(cameraPos);
        this.getProfiler().popPush("culling");
        BlockPos viewPos = BlockPos.containing((double)cameraX, (double)(cameraY + (double)entity.getEyeHeight()), (double)cameraZ);
        int centerChunkX = viewPos.getX() >> 4;
        int centerChunkZ = viewPos.getZ() >> 4;
        int renderDistance = (Integer)this.mc.options.renderDistance().get() + 2;
        ChunkPos viewChunk = new ChunkPos(viewPos);
        this.displayListEntitiesDirty = this.displayListEntitiesDirty || !this.chunksToUpdate.isEmpty() || entityX != this.lastCameraX || entityY != this.lastCameraY || entityZ != this.lastCameraZ || entity.getXRot() != this.lastCameraPitch || entity.getYRot() != this.lastCameraYaw;
        this.lastCameraX = cameraX;
        this.lastCameraY = cameraY;
        this.lastCameraZ = cameraZ;
        this.lastCameraPitch = camera.getXRot();
        this.lastCameraYaw = camera.getYRot();
        this.getProfiler().popPush("update");
        if (this.displayListEntitiesDirty) {
            this.displayListEntitiesDirty = false;
            this.renderInfos.clear();
            this.getProfiler().push("update_sort");
            List<ChunkPos> positions = DataManager.getSchematicPlacementManager().getAndUpdateVisibleChunks(viewChunk);
            this.getProfiler().popPush("update_iteration");
            for (ChunkPos chunkPos : positions) {
                ChunkRendererSchematicVbo chunkRenderer;
                int cx = chunkPos.x;
                int cz = chunkPos.z;
                if (Math.abs(cx - centerChunkX) > renderDistance || Math.abs(cz - centerChunkZ) > renderDistance || !this.world.getChunkProvider().hasChunk(cx, cz) || (chunkRenderer = this.chunkRendererDispatcher.getChunkRenderer(cx, cz)) == null || !frustum.isVisible(chunkRenderer.getBoundingBox())) continue;
                if (chunkRenderer.needsUpdate() && chunkPos.equals((Object)viewChunk)) {
                    chunkRenderer.setNeedsUpdate(true);
                }
                this.renderInfos.add(chunkRenderer);
            }
            this.getProfiler().pop();
        }
        this.getProfiler().popPush("rebuild_near");
        Set<ChunkRendererSchematicVbo> set = this.chunksToUpdate;
        this.chunksToUpdate = new LinkedHashSet<ChunkRendererSchematicVbo>();
        for (ChunkRendererSchematicVbo chunkRendererTmp : this.renderInfos) {
            boolean isNear;
            if (!chunkRendererTmp.needsUpdate() && !set.contains(chunkRendererTmp)) continue;
            this.displayListEntitiesDirty = true;
            BlockPos pos = chunkRendererTmp.getOrigin().offset(8, 8, 8);
            boolean bl = isNear = pos.distSqr((Vec3i)viewPos) < 1024.0;
            if (!chunkRendererTmp.needsImmediateUpdate() && !isNear) {
                this.chunksToUpdate.add(chunkRendererTmp);
                continue;
            }
            this.getProfiler().push("update_now");
            this.renderDispatcher.updateChunkNow(chunkRendererTmp);
            chunkRendererTmp.clearNeedsUpdate();
            this.getProfiler().pop();
        }
        this.chunksToUpdate.addAll(set);
        this.getProfiler().pop();
    }

    public void updateChunks(long finishTimeNano) {
        this.getProfiler().push("run_chunk_uploads");
        this.displayListEntitiesDirty |= this.renderDispatcher.runChunkUploads(finishTimeNano);
        this.getProfiler().popPush("check_update");
        if (!this.chunksToUpdate.isEmpty()) {
            Iterator<ChunkRendererSchematicVbo> iterator = this.chunksToUpdate.iterator();
            int index = 0;
            while (iterator.hasNext()) {
                boolean flag;
                ChunkRendererSchematicVbo renderChunk = iterator.next();
                if (renderChunk.needsImmediateUpdate()) {
                    this.getProfiler().push("update_now");
                    flag = this.renderDispatcher.updateChunkNow(renderChunk);
                } else {
                    this.getProfiler().push("update_later");
                    flag = this.renderDispatcher.updateChunkLater(renderChunk);
                }
                this.getProfiler().pop();
                if (!flag) break;
                renderChunk.clearNeedsUpdate();
                iterator.remove();
                long i = finishTimeNano - System.nanoTime();
                if (i < 0L) break;
                ++index;
            }
        }
        this.getProfiler().pop();
    }

    public int renderBlockLayer(RenderType renderLayer, Matrix4f matrices, Camera camera, Matrix4f projMatrix) {
        RenderSystem.assertOnRenderThread();
        if (renderLayer.toString().contains("RenderType")) {
            this.getProfiler().push("layer_multi_phase");
        } else {
            this.getProfiler().push("layer_" + ChunkRenderLayers.getFriendlyName(renderLayer));
        }
        boolean isTranslucent = renderLayer == RenderType.translucent();
        renderLayer.setupRenderState();
        Vec3 cameraPos = camera.getPosition();
        double x = cameraPos.x;
        double y = cameraPos.y;
        double z = cameraPos.z;
        if (isTranslucent) {
            this.getProfiler().push("translucent_sort");
            double diffX = x - this.lastTranslucentSortX;
            double diffY = y - this.lastTranslucentSortY;
            double diffZ = z - this.lastTranslucentSortZ;
            if (diffX * diffX + diffY * diffY + diffZ * diffZ > 1.0) {
                this.lastTranslucentSortX = x;
                this.lastTranslucentSortY = y;
                this.lastTranslucentSortZ = z;
                int h = 0;
                for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
                    if (!chunkRenderer.getChunkRenderData().isBlockLayerStarted(renderLayer) && (chunkRenderer.getChunkRenderData() == ChunkRenderDataSchematic.EMPTY || !chunkRenderer.hasOverlay()) || h++ >= 15) continue;
                    this.renderDispatcher.updateTransparencyLater(chunkRenderer);
                }
            }
            this.getProfiler().pop();
        }
        this.getProfiler().popPush("layer_setup");
        boolean reverse = isTranslucent;
        int startIndex = reverse ? this.renderInfos.size() - 1 : 0;
        int stopIndex = reverse ? -1 : this.renderInfos.size();
        int increment = reverse ? -1 : 1;
        int count = 0;
        ShaderInstance shader = RenderSystem.getShader();
        BufferUploader.reset();
        boolean renderAsTranslucent = Configs.Visuals.RENDER_BLOCKS_AS_TRANSLUCENT.getBooleanValue();
        if (renderAsTranslucent) {
            float alpha = (float)Configs.Visuals.GHOST_BLOCK_ALPHA.getDoubleValue();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        }
        this.getProfiler().popPush("init_shaders");
        WorldRendererSchematic.initShader(shader, matrices, projMatrix);
        RenderSystem.setupShaderLights((ShaderInstance)shader);
        shader.apply();
        Uniform chunkOffsetUniform = shader.CHUNK_OFFSET;
        boolean startedDrawing = false;
        this.getProfiler().popPush("layer_iteration");
        for (int i = startIndex; i != stopIndex; i += increment) {
            ChunkRendererSchematicVbo renderer = this.renderInfos.get(i);
            if (renderer.getChunkRenderData().isBlockLayerEmpty(renderLayer)) continue;
            BlockPos chunkOrigin = renderer.getOrigin();
            VertexBuffer buffer = renderer.getBlocksVertexBufferByLayer(renderLayer);
            if (buffer == null || buffer.isInvalid() || !renderer.getChunkRenderData().getBuiltBufferCache().hasBuiltBufferByLayer(renderLayer)) continue;
            if (chunkOffsetUniform != null) {
                chunkOffsetUniform.set((float)((double)chunkOrigin.getX() - x), (float)((double)chunkOrigin.getY() - y), (float)((double)chunkOrigin.getZ() - z));
                chunkOffsetUniform.upload();
            }
            buffer.bind();
            buffer.draw();
            VertexBuffer.unbind();
            startedDrawing = true;
            ++count;
        }
        this.getProfiler().popPush("layer_cleanup");
        if (renderAsTranslucent) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        if (chunkOffsetUniform != null) {
            chunkOffsetUniform.set(0.0f, 0.0f, 0.0f);
        }
        shader.clear();
        if (startedDrawing) {
            renderLayer.format().clearBufferState();
        }
        VertexBuffer.unbind();
        renderLayer.clearRenderState();
        this.getProfiler().pop();
        return count;
    }

    public void renderBlockOverlays(Matrix4f matrix4f, Camera camera, Matrix4f projMatrix) {
        this.renderBlockOverlay(OverlayRenderType.OUTLINE, matrix4f, camera, projMatrix);
        this.renderBlockOverlay(OverlayRenderType.QUAD, matrix4f, camera, projMatrix);
    }

    protected static void initShader(ShaderInstance shader, Matrix4f matrix4f, Matrix4f projMatrix) {
        for (int i = 0; i < 12; ++i) {
            shader.setSampler("Sampler" + i, (Object)RenderSystem.getShaderTexture((int)i));
        }
        if (shader.MODEL_VIEW_MATRIX != null) {
            shader.MODEL_VIEW_MATRIX.set(matrix4f);
        }
        if (shader.PROJECTION_MATRIX != null) {
            shader.PROJECTION_MATRIX.set(projMatrix);
        }
        if (shader.COLOR_MODULATOR != null) {
            shader.COLOR_MODULATOR.set(RenderSystem.getShaderColor());
        }
        if (shader.FOG_START != null) {
            shader.FOG_START.set(RenderSystem.getShaderFogStart());
        }
        if (shader.FOG_END != null) {
            shader.FOG_END.set(RenderSystem.getShaderFogEnd());
        }
        if (shader.FOG_COLOR != null) {
            shader.FOG_COLOR.set(RenderSystem.getShaderFogColor());
        }
        if (shader.TEXTURE_MATRIX != null) {
            shader.TEXTURE_MATRIX.set(RenderSystem.getTextureMatrix());
        }
        if (shader.GAME_TIME != null) {
            shader.GAME_TIME.set(RenderSystem.getShaderGameTime());
        }
    }

    protected void renderBlockOverlay(OverlayRenderType type, Matrix4f matrix4f, Camera camera, Matrix4f projMatrix) {
        boolean renderThrough;
        this.getProfiler().push("overlay_" + type.name());
        RenderType renderLayer = RenderType.translucent();
        renderLayer.setupRenderState();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Vec3 cameraPos = camera.getPosition();
        double x = cameraPos.x;
        double y = cameraPos.y;
        double z = cameraPos.z;
        boolean bl = renderThrough = Configs.Visuals.SCHEMATIC_OVERLAY_RENDER_THROUGH.getBooleanValue() || Hotkeys.RENDER_OVERLAY_THROUGH_BLOCKS.getKeybind().isKeybindHeld();
        if (renderThrough) {
            RenderSystem.disableDepthTest();
        } else {
            RenderSystem.enableDepthTest();
        }
        ShaderInstance originalShader = RenderSystem.getShader();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        ShaderInstance shader = RenderSystem.getShader();
        BufferUploader.reset();
        Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
        this.getProfiler().popPush("overlay_iterate");
        for (int i = this.renderInfos.size() - 1; i >= 0; --i) {
            ChunkRenderDataSchematic compiledChunk;
            ChunkRendererSchematicVbo renderer = this.renderInfos.get(i);
            if (renderer.getChunkRenderData() == ChunkRenderDataSchematic.EMPTY || !renderer.hasOverlay() || (compiledChunk = renderer.getChunkRenderData()).isOverlayTypeEmpty(type)) continue;
            VertexBuffer buffer = renderer.getOverlayVertexBuffer(type);
            BlockPos chunkOrigin = renderer.getOrigin();
            if (buffer == null || buffer.isInvalid() || !renderer.getChunkRenderData().getBuiltBufferCache().hasBuiltBufferByType(type)) continue;
            matrix4fStack.pushMatrix();
            matrix4fStack.translate((float)((double)chunkOrigin.getX() - x), (float)((double)chunkOrigin.getY() - y), (float)((double)chunkOrigin.getZ() - z));
            buffer.bind();
            buffer.drawWithShader((Matrix4f)matrix4fStack, projMatrix, shader);
            VertexBuffer.unbind();
            matrix4fStack.popMatrix();
        }
        renderLayer.clearRenderState();
        RenderSystem.setShader(() -> originalShader);
        RenderSystem.disableBlend();
        this.getProfiler().pop();
    }

    public boolean renderBlock(BlockAndTintGetter world, BlockState state, BlockPos pos, PoseStack matrixStack, BufferBuilder bufferBuilderIn) {
        this.getProfiler().push("render_block");
        try {
            RenderShape renderType = state.getRenderShape();
            if (renderType == RenderShape.INVISIBLE) {
                return false;
            }
            BlockModelRendererSchematic.enableCache();
            boolean result = renderType == RenderShape.MODEL && this.blockModelRenderer.renderModel(world, this.getModelForState(state), state, pos, matrixStack, (VertexConsumer)bufferBuilderIn, state.getSeed(pos));
            BlockModelRendererSchematic.disableCache();
            this.getProfiler().pop();
            return result;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Tesselating block in world");
            CrashReportCategory crashreportcategory = crashreport.addCategory("Block being tesselated");
            CrashReportCategory.populateBlockDetails((CrashReportCategory)crashreportcategory, (LevelHeightAccessor)world, (BlockPos)pos, (BlockState)state);
            this.getProfiler().pop();
            throw new ReportedException(crashreport);
        }
    }

    public void renderFluid(BlockAndTintGetter world, BlockState blockState, FluidState fluidState, BlockPos pos, BufferBuilder bufferBuilderIn) {
        this.getProfiler().push("render_fluid");
        try {
            this.blockRenderManager.renderLiquid(pos, world, (VertexConsumer)bufferBuilderIn, blockState, fluidState);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getProfiler().pop();
    }

    public boolean hasQuadsForModel(BakedModel model, BlockState state, @Nullable Direction side) {
        if (side != null) {
            List list = model.getQuads(state, side, RandomSource.create());
            return !list.isEmpty();
        }
        for (Direction entry : Direction.values()) {
            List list = model.getQuads(state, side, RandomSource.create());
            if (list.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public BakedModel getModelForState(BlockState state) {
        if (state.getRenderShape() == RenderShape.ENTITYBLOCK_ANIMATED) {
            return this.blockRenderManager.getBlockModelShaper().getModelManager().getMissingModel();
        }
        return this.blockRenderManager.getBlockModel(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderEntities(Camera camera, Frustum frustum, Matrix4f matrix4f, float partialTicks) {
        if (this.renderEntitiesStartupCounter > 0) {
            --this.renderEntitiesStartupCounter;
        } else {
            this.getProfiler().push("entities_prepare");
            double cameraX = camera.getPosition().x;
            double cameraY = camera.getPosition().y;
            double cameraZ = camera.getPosition().z;
            Minecraft.getInstance().getBlockEntityRenderDispatcher().prepare((Level)this.world, camera, this.mc.hitResult);
            this.entityRenderDispatcher.prepare((Level)this.world, camera, this.mc.crosshairPickEntity);
            this.countEntitiesTotal = 0;
            this.countEntitiesRendered = 0;
            this.countEntitiesHidden = 0;
            this.countEntitiesTotal = this.world.getRegularEntityCount();
            this.getProfiler().popPush("regular_entities");
            PoseStack matrixStack = new PoseStack();
            matrixStack.pushPose();
            matrixStack.mulPose(matrix4f);
            matrixStack.popPose();
            MultiBufferSource.BufferSource entityVertexConsumers = this.bufferBuilders.bufferSource();
            LayerRange layerRange = DataManager.getRenderLayerRange();
            this.getProfiler().popPush("regular_iterate");
            for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
                BlockPos pos = chunkRenderer.getOrigin();
                ChunkSchematic chunk = this.world.getChunk(pos.getX() >> 4, pos.getZ() >> 4);
                List<Entity> list = chunk.getEntityList();
                if (list.isEmpty()) continue;
                for (Entity entityTmp : list) {
                    boolean shouldRender;
                    if (!layerRange.isPositionWithinRange((int)entityTmp.getX(), (int)entityTmp.getY(), (int)entityTmp.getZ()) || !(shouldRender = this.entityRenderDispatcher.shouldRender(entityTmp, frustum, cameraX, cameraY, cameraZ))) continue;
                    double x = entityTmp.getX() - cameraX;
                    double y = entityTmp.getY() - cameraY;
                    double z = entityTmp.getZ() - cameraZ;
                    matrixStack.pushPose();
                    this.entityRenderDispatcher.render(entityTmp, x, y, z, entityTmp.getYRot(), 1.0f, matrixStack, (MultiBufferSource)entityVertexConsumers, this.entityRenderDispatcher.getPackedLightCoords(entityTmp, partialTicks));
                    ++this.countEntitiesRendered;
                    matrixStack.popPose();
                }
            }
            this.getProfiler().popPush("block_entities");
            BlockEntityRenderDispatcher renderer = Minecraft.getInstance().getBlockEntityRenderDispatcher();
            this.getProfiler().popPush("block_entities_iterate");
            for (ChunkRendererSchematicVbo chunkRenderer : this.renderInfos) {
                ChunkRenderDataSchematic data = chunkRenderer.getChunkRenderData();
                List<BlockEntity> tiles = data.getBlockEntities();
                if (tiles.isEmpty()) continue;
                BlockPos chunkOrigin = chunkRenderer.getOrigin();
                ChunkSchematic chunk = this.world.getChunkProvider().getChunk(chunkOrigin.getX() >> 4, chunkOrigin.getZ() >> 4);
                if (chunk == null || data.getTimeBuilt() < chunk.getTimeCreated()) continue;
                for (BlockEntity te : tiles) {
                    try {
                        BlockPos pos = te.getBlockPos();
                        matrixStack.pushPose();
                        matrixStack.translate((double)pos.getX() - cameraX, (double)pos.getY() - cameraY, (double)pos.getZ() - cameraZ);
                        renderer.render(te, partialTicks, matrixStack, (MultiBufferSource)entityVertexConsumers);
                        matrixStack.popPose();
                    }
                    catch (Exception exception) {}
                }
            }
            this.getProfiler().popPush("block_entities_render");
            Set<BlockEntity> set = this.blockEntities;
            synchronized (set) {
                for (BlockEntity te : this.blockEntities) {
                    try {
                        BlockPos pos = te.getBlockPos();
                        matrixStack.pushPose();
                        matrixStack.translate((double)pos.getX() - cameraX, (double)pos.getY() - cameraY, (double)pos.getZ() - cameraZ);
                        renderer.render(te, partialTicks, matrixStack, (MultiBufferSource)entityVertexConsumers);
                        matrixStack.popPose();
                    }
                    catch (Exception exception) {}
                }
            }
            this.getProfiler().pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBlockEntities(Collection<BlockEntity> toRemove, Collection<BlockEntity> toAdd) {
        Set<BlockEntity> set = this.blockEntities;
        synchronized (set) {
            this.blockEntities.removeAll(toRemove);
            this.blockEntities.addAll(toAdd);
        }
    }

    public void scheduleChunkRenders(int chunkX, int chunkZ) {
        this.getProfiler().push("schedule_render");
        if (Configs.Visuals.ENABLE_RENDERING.getBooleanValue() && Configs.Visuals.ENABLE_SCHEMATIC_RENDERING.getBooleanValue()) {
            this.chunkRendererDispatcher.scheduleChunkRender(chunkX, chunkZ);
        }
        this.getProfiler().pop();
    }
}

