/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.render.schematic;

import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import fi.dy.masa.litematica.render.schematic.ChunkRenderLayers;
import fi.dy.masa.litematica.render.schematic.OverlayRenderType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.renderer.RenderType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BufferAllocatorCache
implements AutoCloseable {
    protected static final List<RenderType> LAYERS = ChunkRenderLayers.LAYERS;
    protected static final List<OverlayRenderType> TYPES = ChunkRenderLayers.TYPES;
    protected static final int EXPECTED_TOTAL_SIZE = LAYERS.stream().mapToInt(RenderType::bufferSize).sum() + TYPES.stream().mapToInt(OverlayRenderType::getExpectedBufferSize).sum();
    private final ConcurrentHashMap<RenderType, ByteBufferBuilder> layerCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<OverlayRenderType, ByteBufferBuilder> overlayCache = new ConcurrentHashMap();

    protected BufferAllocatorCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void allocateCache() {
        ConcurrentHashMap<Object, ByteBufferBuilder> concurrentHashMap;
        for (RenderType layer : LAYERS) {
            if (this.layerCache.containsKey(layer)) {
                this.layerCache.get(layer).close();
            }
            concurrentHashMap = this.layerCache;
            synchronized (concurrentHashMap) {
                this.layerCache.put(layer, new ByteBufferBuilder(layer.bufferSize()));
            }
        }
        for (OverlayRenderType type : TYPES) {
            if (this.overlayCache.containsKey((Object)type)) {
                this.overlayCache.get((Object)type).close();
            }
            concurrentHashMap = this.overlayCache;
            synchronized (concurrentHashMap) {
                this.overlayCache.put(type, new ByteBufferBuilder(type.getExpectedBufferSize()));
            }
        }
    }

    protected boolean hasBufferByLayer(RenderType layer) {
        return this.layerCache.containsKey(layer);
    }

    protected boolean hasBufferByOverlay(OverlayRenderType type) {
        return this.overlayCache.containsKey((Object)type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ByteBufferBuilder getBufferByLayer(RenderType layer) {
        ConcurrentHashMap<RenderType, ByteBufferBuilder> concurrentHashMap = this.layerCache;
        synchronized (concurrentHashMap) {
            return this.layerCache.computeIfAbsent(layer, l -> new ByteBufferBuilder(l.bufferSize()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ByteBufferBuilder getBufferByOverlay(OverlayRenderType type) {
        ConcurrentHashMap<OverlayRenderType, ByteBufferBuilder> concurrentHashMap = this.overlayCache;
        synchronized (concurrentHashMap) {
            return this.overlayCache.computeIfAbsent(type, t -> new ByteBufferBuilder(t.getExpectedBufferSize()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeByLayer(RenderType layer) {
        try {
            ConcurrentHashMap<RenderType, ByteBufferBuilder> concurrentHashMap = this.layerCache;
            synchronized (concurrentHashMap) {
                this.layerCache.remove(layer).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeByType(OverlayRenderType type) {
        try {
            ConcurrentHashMap<OverlayRenderType, ByteBufferBuilder> concurrentHashMap = this.overlayCache;
            synchronized (concurrentHashMap) {
                this.overlayCache.remove((Object)type).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void resetAll() {
        try {
            this.layerCache.values().forEach(ByteBufferBuilder::discard);
            this.overlayCache.values().forEach(ByteBufferBuilder::discard);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void clearAll() {
        try {
            this.layerCache.values().forEach(ByteBufferBuilder::clear);
            this.overlayCache.values().forEach(ByteBufferBuilder::clear);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAll() {
        ArrayList<ByteBufferBuilder> allocators;
        ConcurrentHashMap<Object, ByteBufferBuilder> concurrentHashMap = this.layerCache;
        synchronized (concurrentHashMap) {
            allocators = new ArrayList<ByteBufferBuilder>(this.layerCache.values());
            this.layerCache.clear();
        }
        concurrentHashMap = this.overlayCache;
        synchronized (concurrentHashMap) {
            allocators.addAll(this.overlayCache.values());
            this.overlayCache.clear();
        }
        allocators.forEach(ByteBufferBuilder::close);
    }

    @Override
    public void close() {
        this.closeAll();
    }
}

