/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.util.rendering.text;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentParser {
    private static final Logger LOGGER = LogManager.getLogger();

    @NotNull
    public static Component fromJsonOrPlainText(@NotNull String serializedComponentOrPlainText) {
        if (!(serializedComponentOrPlainText = PlaceholderParser.replacePlaceholders(serializedComponentOrPlainText)).startsWith("{") && !serializedComponentOrPlainText.startsWith("[")) {
            return Component.literal((String)serializedComponentOrPlainText);
        }
        try {
            MutableComponent c = ComponentParser.deserializeComponentFromJson(serializedComponentOrPlainText);
            if (c != null) {
                return c;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Component.literal((String)serializedComponentOrPlainText);
    }

    @NotNull
    public static String toJson(@NotNull Component component) {
        return ((JsonElement)ComponentSerialization.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)component).getOrThrow(JsonParseException::new)).toString();
    }

    @Nullable
    private static MutableComponent deserializeComponentFromJson(@NotNull String json) {
        try {
            JsonElement jsonElement = JsonParser.parseString((String)json);
            return jsonElement == null ? null : ComponentParser.deserializeComponent(jsonElement);
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to deserialize Component!", (Throwable)ex);
            return null;
        }
    }

    private static MutableComponent deserializeComponent(JsonElement jsonElement) {
        Object var2 = ComponentSerialization.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).getOrThrow();
        if (var2 instanceof MutableComponent) {
            MutableComponent m = (MutableComponent)var2;
            return m;
        }
        throw new IllegalStateException("Deserialized component was not a MutableComponent!");
    }
}

