/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.client;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import gg.moonflower.etched.api.record.AlbumCover;
import gg.moonflower.etched.client.render.item.AlbumCoverItemRenderer;
import gg.moonflower.etched.client.render.item.AlbumImageProcessor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

@ApiStatus.Internal
public final class AlbumCoverCache {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new Gson();
    private static final Path CACHE_FOLDER = Minecraft.getInstance().gameDirectory.toPath().resolve("etched-cache");
    private static final Object METADATA_LOCK = new Object();
    private static final Object IO_LOCK = new Object();
    private static final Path CACHE_METADATA_LOCATION = CACHE_FOLDER.resolve("cache.json");
    private static final int METADATA_WRITE_TIME = 5000;
    private static volatile JsonObject CACHE_METADATA = new JsonObject();
    private static volatile long nextWriteTime = Long.MAX_VALUE;

    private AlbumCoverCache() {
    }

    private static void onClientTickPost(ClientTickEvent.Post event) {
        if (nextWriteTime == Long.MAX_VALUE) {
            return;
        }
        if (System.currentTimeMillis() - nextWriteTime > 0L) {
            nextWriteTime = Long.MAX_VALUE;
            Util.ioPool().execute(AlbumCoverCache::writeMetadata);
        }
    }

    public static NativeImage read(InputStream stream) throws IOException {
        ByteBuffer textureData = null;
        try {
            NativeImage nativeImage;
            block11: {
                textureData = TextureUtil.readResource((InputStream)stream);
                textureData.rewind();
                if (MemoryUtil.memAddress((ByteBuffer)textureData) == 0L) {
                    throw new IllegalArgumentException("Invalid buffer");
                }
                MemoryStack memorystack = MemoryStack.stackPush();
                try {
                    IntBuffer w = memorystack.mallocInt(1);
                    IntBuffer h = memorystack.mallocInt(1);
                    IntBuffer channels = memorystack.mallocInt(1);
                    ByteBuffer data = STBImage.stbi_load_from_memory((ByteBuffer)textureData, (IntBuffer)w, (IntBuffer)h, (IntBuffer)channels, (int)4);
                    if (data == null) {
                        throw new IOException("Could not load image: " + STBImage.stbi_failure_reason());
                    }
                    nativeImage = new NativeImage(NativeImage.Format.RGBA, w.get(0), h.get(0), true, MemoryUtil.memAddress((ByteBuffer)data));
                    if (memorystack == null) break block11;
                }
                catch (Throwable throwable) {
                    if (memorystack != null) {
                        try {
                            memorystack.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                memorystack.close();
            }
            return nativeImage;
        }
        finally {
            MemoryUtil.memFree((Buffer)textureData);
        }
    }

    public static CompletableFuture<AlbumCover> requestResource(String url) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                return AlbumCoverCache.getPath(url);
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, Util.nonCriticalIoPool()).thenApplyAsync(path -> {
            try (FileInputStream is = new FileInputStream(path.toFile());){
                AlbumCover albumCover;
                block13: {
                    NativeImage image = AlbumCoverCache.read(is);
                    try {
                        albumCover = AlbumCover.of(AlbumImageProcessor.apply(image, AlbumCoverItemRenderer.getOverlayImage()));
                        if (image == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (image != null) {
                            try {
                                image.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    image.close();
                }
                return albumCover;
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, (Executor)Util.ioPool())).handle((result, throwable) -> {
            if (throwable != null) {
                while (throwable instanceof CompletionException) {
                    throwable = throwable.getCause();
                }
                LOGGER.error("Failed to load album cover from '{}'", (Object)url, throwable);
            }
            return result != null ? result : AlbumCover.EMPTY;
        });
    }

    private static synchronized void writeMetadata() {
        LOGGER.debug("Writing cache metadata to file.");
        try (FileOutputStream os = new FileOutputStream(CACHE_METADATA_LOCATION.toFile());){
            if (!Files.exists(CACHE_FOLDER, new LinkOption[0])) {
                Files.createDirectory(CACHE_FOLDER, new FileAttribute[0]);
            }
            IOUtils.write((String)GSON.toJson((JsonElement)CACHE_METADATA), (OutputStream)os, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            LOGGER.error("Failed to write cache metadata", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Path getPath(String url) throws IOException {
        InputStream fetchedStream;
        Path imageFile = CACHE_FOLDER.resolve(DigestUtils.md5Hex((String)url));
        String key = DigestUtils.md5Hex((String)url);
        if (Files.exists(imageFile, new LinkOption[0]) && CACHE_METADATA.has(key) && CACHE_METADATA.get(key).isJsonPrimitive() && CACHE_METADATA.get(key).getAsJsonPrimitive().isNumber()) {
            long now = System.currentTimeMillis();
            long expirationDate = CACHE_METADATA.get(key).getAsLong();
            if (expirationDate - now > 0L) {
                return imageFile;
            }
        }
        if ((fetchedStream = AlbumCoverCache.get(url)) == null) {
            try {
                Object object;
                if (!Files.exists(CACHE_FOLDER, new LinkOption[0])) {
                    object = IO_LOCK;
                    synchronized (object) {
                        Files.createDirectory(CACHE_FOLDER, new FileAttribute[0]);
                    }
                }
                if (!Files.exists(imageFile, new LinkOption[0])) {
                    object = IO_LOCK;
                    synchronized (object) {
                        Files.createFile(imageFile, new FileAttribute[0]);
                    }
                }
                object = METADATA_LOCK;
                synchronized (object) {
                    CACHE_METADATA.addProperty(key, (Number)(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(1L)));
                    nextWriteTime = System.currentTimeMillis() + 5000L;
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to create empty file '{}' for '{}'", (Object)imageFile, (Object)url, (Object)e);
            }
            return null;
        }
        try {
            Object object = IO_LOCK;
            synchronized (object) {
                if (!Files.exists(CACHE_FOLDER, new LinkOption[0])) {
                    Files.createDirectory(CACHE_FOLDER, new FileAttribute[0]);
                }
                Files.copy(fetchedStream, imageFile, StandardCopyOption.REPLACE_EXISTING);
            }
            object = METADATA_LOCK;
            synchronized (object) {
                CACHE_METADATA.addProperty(key, (Number)(System.currentTimeMillis() + TimeUnit.DAYS.toMillis(1L)));
                nextWriteTime = System.currentTimeMillis() + 5000L;
            }
            object = imageFile;
            return object;
        }
        finally {
            IOUtils.closeQuietly((InputStream)fetchedStream);
        }
    }

    public static InputStream get(String url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        connection.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
        InputStream stream = connection.getInputStream();
        if (connection.getResponseCode() != 200) {
            IOException exception = new IOException("Failed to connect to '" + url + "'. " + connection.getResponseCode() + " " + connection.getResponseMessage());
            try {
                stream.close();
            }
            catch (Throwable e) {
                exception.addSuppressed(e);
            }
            throw exception;
        }
        return stream;
    }

    static {
        if (Files.exists(CACHE_METADATA_LOCATION, new LinkOption[0])) {
            LOGGER.debug("Reading cache metadata from file.");
            try (InputStreamReader reader = new InputStreamReader(new FileInputStream(CACHE_METADATA_LOCATION.toFile()));){
                CACHE_METADATA = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            }
            catch (Exception e) {
                LOGGER.error("Failed to load cache metadata", (Throwable)e);
            }
        }
        NeoForge.EVENT_BUS.addListener(AlbumCoverCache::onClientTickPost);
    }
}

