/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.etched.api.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class M3uParser {
    private static final Logger LOGGER = LogManager.getLogger();

    public static List<URL> parse(InputStream stream) throws IOException {
        String line;
        String line2;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        LinkedList<String> lines = new LinkedList<String>();
        while ((line2 = reader.readLine()) != null) {
            if (line2.isBlank()) continue;
            lines.add(line2.trim());
        }
        if (lines.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<URL> entries = new LinkedList<URL>();
        Iterator iterator = lines.iterator();
        boolean extendedHeader = false;
        int version = 0;
        while (iterator.hasNext()) {
            line = (String)iterator.next();
            if (line.equals("#EXTM3U")) {
                extendedHeader = true;
                continue;
            }
            if (line.startsWith("#EXT-X-VERSION:")) {
                version = Integer.parseInt(line.substring(15));
                continue;
            }
            if (line.startsWith("#EXT-X-MAP:URI=")) {
                String url = line.substring(16, line.length() - 1);
                try {
                    entries.add(new URI(url).toURL());
                    continue;
                }
                catch (Exception e) {
                    throw new IOException("Failed to parse map URL: " + url, e);
                }
            }
            if (!line.startsWith("#EXTINF")) continue;
            if (!extendedHeader) {
                throw new IOException("Invalid Header");
            }
            if (version == 6) break;
            throw new IOException("Invalid M3u Version, expected 6, got " + version);
        }
        if (!iterator.hasNext()) {
            throw new IOException("No body was provided");
        }
        while (iterator.hasNext()) {
            line = (String)iterator.next();
            if (line.startsWith("#")) continue;
            try {
                entries.add(new URI(line).toURL());
            }
            catch (Exception e) {
                LOGGER.warn("Could not parse as location: {}", (Object)line, (Object)e);
            }
        }
        return entries;
    }
}

