/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.arch.screen;

import com.mojang.blaze3d.platform.InputConstants;
import io.github.kosmx.emotes.PlatformTools;
import io.github.kosmx.emotes.arch.gui.screen.ConfigScreen;
import io.github.kosmx.emotes.arch.gui.widgets.EmoteListWidget;
import io.github.kosmx.emotes.arch.screen.components.EmoteSubScreen;
import io.github.kosmx.emotes.arch.screen.utils.EmoteListener;
import io.github.kosmx.emotes.arch.screen.widget.AbstractFastChooseWidget;
import io.github.kosmx.emotes.arch.screen.widget.IChooseWheel;
import io.github.kosmx.emotes.executor.EmoteInstance;
import io.github.kosmx.emotes.main.EmoteHolder;
import io.github.kosmx.emotes.main.config.ClientConfig;
import io.github.kosmx.emotes.main.config.ClientSerializer;
import java.util.UUID;
import java.util.logging.Level;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class EmoteMenu
extends EmoteSubScreen {
    private static final Component TITLE = Component.translatable((String)"emotecraft.menu");
    public static final Component OPEN_FOLDER = Component.translatable((String)"emotecraft.openFolder");
    private static final Component OPTIONS = Component.translatable((String)"emotecraft.options.options");
    public static final Component RESET = Component.translatable((String)"controls.reset");
    private static final Component KEYBIND = Component.translatable((String)"emotecraft.options.keybind");
    private static final Component FASTMENU = Component.translatable((String)"emotecraft.options.fastmenu");
    private static final Component FASTMENU2 = Component.translatable((String)"emotecraft.options.fastmenu2");
    private static final Component FASTMENU3 = Component.translatable((String)"emotecraft.options.fastmenu3");
    private static final Component SURE = Component.translatable((String)"emotecraft.sure");
    private static final Component SURE2 = Component.translatable((String)"emotecraft.sure2");
    private static final Component RESET_ONE = Component.translatable((String)"controls.reset");
    private static final Component RESET_ALL = Component.translatable((String)"controls.resetAll");
    private static final Component RESET_ALL_TITLE = Component.translatable((String)"emotecraft.resetAllKeys.title");
    private static final Component RESET_ALL_MSG = Component.translatable((String)"emotecraft.resetAllKeys.message");
    public final EmoteListener watcher = new EmoteListener(EmoteInstance.instance.getExternalEmoteDir().toPath());
    public long activeKeyTime;
    private Button setKeyButton;
    private Button resetButton;
    private boolean resetOnlySelected;
    protected FastChooseWidget fastChoose;

    public EmoteMenu(Screen parent) {
        super(TITLE, parent);
        this.watcher.load(this::addOptions);
    }

    @Override
    protected void addContents() {
        LinearLayout linearLayout = (LinearLayout)this.layout.addToContents((LayoutElement)LinearLayout.horizontal().spacing(8));
        this.list = (EmoteListWidget)linearLayout.addChild((LayoutElement)this.newEmoteListWidget());
        this.addOptions();
        GridLayout gridLayout = (GridLayout)linearLayout.addChild((LayoutElement)new GridLayout());
        gridLayout.defaultCellSetting().padding(4, 4, 4, 0);
        GridLayout.RowHelper rowHelper = gridLayout.createRowHelper(2);
        rowHelper.addChild((LayoutElement)new StringWidget(KEYBIND, this.font), 2);
        this.setKeyButton = (Button)rowHelper.addChild((LayoutElement)Button.builder((Component)InputConstants.UNKNOWN.getDisplayName(), button -> {
            if (this.list != null && this.list.getSelected() != null) {
                this.activeKeyTime = 200L;
            }
        }).width(120).build());
        this.setKeyButton.active = false;
        this.resetButton = (Button)rowHelper.addChild((LayoutElement)Button.builder((Component)RESET, this::resetKeyAction).width(120).build());
        this.resetButton.active = false;
        rowHelper.addChild((LayoutElement)new StringWidget(FASTMENU, this.font), 2, gridLayout.newCellSettings().paddingTop(20));
        rowHelper.addChild((LayoutElement)new StringWidget(FASTMENU2, this.font), 2);
        rowHelper.addChild((LayoutElement)new StringWidget(FASTMENU3, this.font), 2);
        this.fastChoose = (FastChooseWidget)rowHelper.addChild((LayoutElement)new FastChooseWidget(0, 0, 0), 2);
    }

    @Override
    protected void addOptions() {
        if (this.list != null) {
            this.list.setEmotes((Iterable<EmoteHolder>)EmoteHolder.list, true);
        }
    }

    @Override
    protected void addFooter() {
        LinearLayout linearLayout = (LinearLayout)this.layout.addToFooter((LayoutElement)LinearLayout.horizontal().spacing(8));
        linearLayout.addChild((LayoutElement)Button.builder((Component)OPEN_FOLDER, button -> PlatformTools.openExternalEmotesDir()).width(120).build());
        linearLayout.addChild((LayoutElement)Button.builder((Component)OPTIONS, button -> this.minecraft.setScreen((Screen)new ConfigScreen(this))).width(120).build());
        linearLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, button -> this.onClose()).width(120).build());
    }

    private void resetKeyAction(Button button) {
        if (this.resetOnlySelected) {
            if (this.list == null || this.list.getFocused() == null) {
                return;
            }
            ((ClientConfig)EmoteInstance.config).emoteKeyMap.removeL(((EmoteListWidget.EmoteEntry)this.list.getFocused()).getEmote().getUuid());
            this.onPressed((EmoteListWidget.EmoteEntry)this.list.getSelected());
        } else {
            this.minecraft.setScreen((Screen)new ConfirmScreen(aBoolean -> {
                if (aBoolean) {
                    ((ClientConfig)EmoteInstance.config).emoteKeyMap.clear();
                    this.onPressed((EmoteListWidget.EmoteEntry)this.list.getSelected());
                }
                this.minecraft.setScreen((Screen)this);
            }, RESET_ALL_TITLE, (Component)RESET_ALL_MSG.copy().append(" (" + ((ClientConfig)EmoteInstance.config).emoteKeyMap.size() + ")")));
        }
    }

    @Override
    protected void repositionElements() {
        if (this.fastChoose != null) {
            int x = Math.min(this.width / 4, (int)((double)this.height / 2.5)) - 7;
            this.fastChoose.setSize(x, x);
        }
        super.repositionElements();
        if (this.list != null) {
            this.list.setCompactMode(true);
            this.list.setWidth(this.width / 3);
            this.layout.arrangeElements();
        }
    }

    @Override
    protected void onPressed(EmoteListWidget.EmoteEntry selected) {
        this.resetButton.active = selected != null;
        this.setKeyButton.active = this.resetButton.active;
        if (selected != null) {
            this.setKeyButton.setMessage(EmoteMenu.getKey(selected.getEmote().getUuid()).getDisplayName());
            this.resetOnlySelected = ((ClientConfig)EmoteInstance.config).emoteKeyMap.containsL(selected.getEmote().getUuid());
        } else {
            this.resetOnlySelected = false;
        }
        if (this.resetOnlySelected) {
            this.resetButton.active = true;
            this.resetButton.setMessage(RESET_ONE);
        } else if (!((ClientConfig)EmoteInstance.config).emoteKeyMap.isEmpty()) {
            this.resetButton.active = true;
            this.resetButton.setMessage((Component)RESET_ALL.copy().append(" (" + ((ClientConfig)EmoteInstance.config).emoteKeyMap.size() + ")"));
        } else {
            this.resetButton.active = false;
            this.resetButton.setMessage(RESET_ONE);
        }
    }

    public void tick() {
        if (this.activeKeyTime == 1L) {
            this.setFocused(null);
        }
        if (this.activeKeyTime != 0L) {
            --this.activeKeyTime;
        }
        if (this.watcher != null && this.watcher.isFilesChanged()) {
            this.watcher.load(this::addOptions);
        }
        super.tick();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.activeKeyTime != 0L && this.list != null && this.list.getFocused() != null) {
            return this.setKey(InputConstants.Type.MOUSE.getOrCreate(button));
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private boolean setKey(InputConstants.Key key) {
        boolean bl = false;
        if (this.list != null && this.list.getFocused() != null) {
            bl = true;
            if (!this.applyKey(false, ((EmoteListWidget.EmoteEntry)this.list.getFocused()).getEmote(), key)) {
                this.minecraft.setScreen((Screen)new ConfirmScreen(choice -> {
                    if (choice) {
                        this.applyKey(true, ((EmoteListWidget.EmoteEntry)this.list.getFocused()).getEmote(), key);
                    }
                    this.minecraft.setScreen((Screen)this);
                }, SURE, SURE2));
            }
        }
        return bl;
    }

    private boolean applyKey(boolean force, EmoteHolder emote, InputConstants.Key key) {
        boolean bl = true;
        for (EmoteHolder emoteHolder : EmoteHolder.list) {
            if (key.equals((Object)InputConstants.UNKNOWN) || !EmoteMenu.getKey(emoteHolder.getUuid()).equals((Object)key)) continue;
            bl = false;
            if (!force) continue;
            ((ClientConfig)EmoteInstance.config).emoteKeyMap.removeL(emoteHolder.getUuid());
        }
        if (bl || force) {
            ((ClientConfig)EmoteInstance.config).emoteKeyMap.put(emote.getUuid(), key);
            this.onPressed((EmoteListWidget.EmoteEntry)this.list.getSelected());
        }
        this.activeKeyTime = 0L;
        return bl;
    }

    @NotNull
    public static InputConstants.Key getKey(UUID emoteID) {
        InputConstants.Key key = ((ClientConfig)EmoteInstance.config).emoteKeyMap.getR(emoteID);
        if (key == null) {
            return InputConstants.UNKNOWN;
        }
        return key;
    }

    public void removed() {
        this.watcher.blockWhileLoading();
        super.removed();
        ClientSerializer.saveConfig();
        try {
            this.watcher.close();
        }
        catch (Throwable th) {
            EmoteInstance.instance.getLogger().log(Level.WARNING, "Failed to close watcher!", th);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int mod) {
        if (this.list != null && this.list.getFocused() != null && this.activeKeyTime != 0L) {
            if (keyCode == 256) {
                return this.setKey(InputConstants.UNKNOWN);
            }
            return this.setKey(InputConstants.getKey((int)keyCode, (int)scanCode));
        }
        return super.keyPressed(keyCode, scanCode, mod);
    }

    protected class FastChooseWidget
    extends AbstractFastChooseWidget {
        public FastChooseWidget(int x, int y, int size) {
            super(x, y, size);
        }

        @Override
        protected boolean isValidClickButton(int button) {
            return (button == 0 || button == 1) && EmoteMenu.this.activeKeyTime == 0L;
        }

        @Override
        protected boolean onClick(IChooseWheel.IChooseElement element, int button) {
            if (EmoteMenu.this.activeKeyTime != 0L) {
                return false;
            }
            if (button == 1) {
                element.clearEmote();
                return true;
            }
            if (EmoteMenu.this.list != null && EmoteMenu.this.list.getFocused() != null) {
                element.setEmote(((EmoteListWidget.EmoteEntry)EmoteMenu.this.list.getFocused()).getEmote());
                return true;
            }
            return false;
        }

        @Override
        protected boolean doHoverPart(IChooseWheel.IChooseElement part) {
            return EmoteMenu.this.activeKeyTime == 0L;
        }

        @Override
        protected boolean doesShowInvalid() {
            return true;
        }
    }
}

