/*
 * Decompiled with CFR 0.152.
 */
package moe.prwk.emiffect;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiInitRegistry;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiRegistryAdapter;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.serializer.EmiIngredientSerializer;
import java.util.List;
import moe.prwk.emiffect.recipes.MobEffectInfo;
import moe.prwk.emiffect.util.MobEffectEmiStack;
import moe.prwk.emiffect.util.VersionUtil;
import moe.prwk.emiffect.util.resources.ExtraAppenderLoader;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EmiEntrypoint
public class EMIffectPlugin
implements EmiPlugin {
    public static final String MOD_ID = "emiffect";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"EMIffect");
    public static final ResourceLocation CATEGORY_ICON = VersionUtil.identifier("emiffect", "textures/gui/emi/icon.png");
    public static final EmiRecipeCategory CATEGORY = new EmiRecipeCategory(VersionUtil.identifier("emiffect", "status_effect_info"), (EmiRenderable)new EmiTexture(CATEGORY_ICON, 0, 0, 16, 16, 16, 16, 16, 16));

    public void initialize(@NotNull EmiInitRegistry registry) {
        registry.addIngredientSerializer(MobEffectEmiStack.class, (EmiIngredientSerializer)new MobEffectEmiStack.Serializer());
        registry.addRegistryAdapter(EmiRegistryAdapter.simple(MobEffect.class, (Registry)BuiltInRegistries.MOB_EFFECT, (effect, _arg, _amount) -> new MobEffectEmiStack((MobEffect)effect)));
    }

    public void register(@NotNull EmiRegistry registry) {
        registry.addCategory(CATEGORY);
        List<ExtraAppenderLoader.ExtraAppender> appenders = ExtraAppenderLoader.getAppenders();
        for (MobEffect effect : BuiltInRegistries.MOB_EFFECT) {
            MobEffectEmiStack stack = new MobEffectEmiStack(effect);
            MobEffectInfo recipe = new MobEffectInfo(effect, stack);
            recipe.addFromAppenders(appenders);
            registry.addRecipe((EmiRecipe)recipe);
            registry.addEmiStack((EmiStack)stack);
        }
        registry.addWorkstation(CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)Blocks.BEACON));
        registry.addWorkstation(CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)Items.POTION));
        registry.addWorkstation(CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)Items.SPLASH_POTION));
        registry.addWorkstation(CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)Items.LINGERING_POTION));
        registry.addWorkstation(CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)Items.SUSPICIOUS_STEW));
        for (Item item : BuiltInRegistries.ITEM) {
            FoodProperties food = (FoodProperties)item.components().get(DataComponents.FOOD);
            if (food == null || food.effects().isEmpty()) continue;
            registry.addWorkstation(CATEGORY, (EmiIngredient)EmiStack.of((ItemLike)item));
        }
        LOGGER.info("Reloaded.");
    }
}

