/*
 * Decompiled with CFR 0.152.
 */
package cc.abbie.emi_ores.networking;

import cc.abbie.emi_ores.networking.payload.S2CSendBiomeInfoPayload;
import cc.abbie.emi_ores.networking.payload.S2CSendFeaturesPayload;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.GeodeConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class FeaturesSender {
    public static void onSyncDataPackContents(ServerPlayer player, BiPredicate<ServerPlayer, CustomPacketPayload.Type<?>> canSend, BiConsumer<ServerPlayer, CustomPacketPayload> sender) {
        if (!canSend.test(player, S2CSendBiomeInfoPayload.TYPE) || !canSend.test(player, S2CSendFeaturesPayload.TYPE)) {
            return;
        }
        HashMap<ResourceLocation, PlacedFeature> featureMap = new HashMap<ResourceLocation, PlacedFeature>();
        HashMultimap features2biomes = HashMultimap.create();
        RegistryAccess.Frozen access = player.server.registryAccess();
        Registry placedFeatureRegistry = access.registryOrThrow(Registries.PLACED_FEATURE);
        placedFeatureRegistry.entrySet().forEach(entry -> {
            PlacedFeature pf = (PlacedFeature)entry.getValue();
            ConfiguredFeature cf = (ConfiguredFeature)pf.feature().value();
            FeatureConfiguration fc = cf.config();
            if (fc instanceof OreConfiguration || fc instanceof GeodeConfiguration) {
                List<PlacementModifier> newModifiers = pf.placement().stream().filter(FeaturesSender::isSupported).toList();
                featureMap.put(((ResourceKey)entry.getKey()).location(), new PlacedFeature(pf.feature(), newModifiers));
            }
        });
        access.registryOrThrow(Registries.BIOME).entrySet().forEach(arg_0 -> FeaturesSender.lambda$onSyncDataPackContents$4((SetMultimap)features2biomes, arg_0));
        SetMultimap features2biomes2 = Multimaps.filterKeys((SetMultimap)features2biomes, k -> featureMap.containsKey(k.location()));
        sender.accept(player, new S2CSendBiomeInfoPayload((SetMultimap<ResourceKey<PlacedFeature>, ResourceKey<Biome>>)features2biomes2));
        sender.accept(player, new S2CSendFeaturesPayload(featureMap));
    }

    private static boolean isSupported(PlacementModifier modifier) {
        return modifier instanceof HeightRangePlacement || modifier instanceof BiomeFilter || modifier instanceof CountPlacement || modifier instanceof RarityFilter;
    }

    private static /* synthetic */ void lambda$onSyncDataPackContents$4(SetMultimap features2biomes, Map.Entry biomeEntry) {
        ((Biome)biomeEntry.getValue()).getGenerationSettings().features().forEach(placedFeatureHolderSet -> placedFeatureHolderSet.forEach(placedFeatureHolder -> placedFeatureHolder.unwrapKey().ifPresent(placedFeatureResourceKey -> features2biomes.put(placedFeatureResourceKey, (Object)((ResourceKey)biomeEntry.getKey())))));
    }
}

