/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.parser.registry;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.parser.condition.BlockStatePropertyConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.ConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.DamageSourceConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.EntityPropertiesConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.InvertedConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.LocationCheckConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.MatchToolConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.MultiplesConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.RandomChanceConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.RandomChanceWithLootingConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.ReferenceConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.SimpleConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.SurvivesExplosionConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.TableBonusConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.TimeCheckConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.ValueCheckConditionParser;
import fzzyhmstrs.emi_loot.parser.condition.WeatherCheckConditionParser;
import fzzyhmstrs.emi_loot.parser.function.ApplyBonusFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.CopyNameFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.EnchantRandomlyFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.EnchantWithLevelsFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.ExplorationMapFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.ExplosionDecayFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.FilteredFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.FunctionParser;
import fzzyhmstrs.emi_loot.parser.function.LimitCountFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.ModifyContentsFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.ReferenceFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SequenceFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetAnyDamageFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetAttributesFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetBookCoverFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetCountFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetCustomDataFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetDamageFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetEnchantmentsFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetFireworkExplosionFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetFireworksFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetInstrumentFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetItemFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetLootTableFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetNameFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetNbtFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetOminousBottleFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetPotionFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SetStewFunctionParser;
import fzzyhmstrs.emi_loot.parser.function.SimpleFunctionParser;
import fzzyhmstrs.emi_loot.util.TextKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public class LootParserRegistry {
    private static final Map<LootItemConditionType, ConditionParser> CONDITION_PARSERS = new HashMap<LootItemConditionType, ConditionParser>();
    private static final Map<LootItemFunctionType<?>, FunctionParser> FUNCTION_PARSERS = new HashMap();

    public static void registerCondition(LootItemConditionType type, ConditionParser parser, String registrationContext) {
        if (!CONDITION_PARSERS.containsKey(type)) {
            if (EMILoot.DEBUG) {
                EMILoot.LOGGER.info("Registering condition for type: " + String.valueOf(type) + " from: " + registrationContext);
            }
            CONDITION_PARSERS.put(type, parser);
        } else {
            EMILoot.LOGGER.warn("Duplicate condition registration attempted with type: " + String.valueOf(type) + " during " + registrationContext);
        }
    }

    public static void registerFunction(LootItemFunctionType<?> type, FunctionParser parser, String registrationContext) {
        if (!FUNCTION_PARSERS.containsKey(type)) {
            if (EMILoot.DEBUG) {
                EMILoot.LOGGER.info("Registering function for type: " + String.valueOf(type) + " from: " + registrationContext);
            }
            FUNCTION_PARSERS.put(type, parser);
        } else {
            EMILoot.LOGGER.warn("Duplicate function registration attempted with type: " + String.valueOf(type) + " during " + registrationContext);
        }
    }

    public static List<LootTableParser.LootConditionResult> parseCondition(LootItemCondition condition, LootItemConditionType type, ItemStack stack, boolean parentIsAlternative) {
        ConditionParser parser = CONDITION_PARSERS.getOrDefault(type, ConditionParser.EMPTY);
        return parser.parseCondition(condition, stack, parentIsAlternative);
    }

    public static LootTableParser.LootFunctionResult parseFunction(LootItemFunction function, ItemStack stack, LootItemFunctionType<?> type, boolean parentIsAlternative, List<TextKey> conditionTexts) {
        FunctionParser parser = FUNCTION_PARSERS.getOrDefault(type, FunctionParser.EMPTY);
        return parser.parseFunction(function, stack, parentIsAlternative, conditionTexts);
    }

    static {
        LootParserRegistry.registerFunction(LootItemFunctions.APPLY_BONUS, new ApplyBonusFunctionParser(), "Registering vanilla apply bonus function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.SET_POTION, new SetPotionFunctionParser(), "Registering vanilla set potion function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.SET_COUNT, new SetCountFunctionParser(), "Registering vanilla set count function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.SET_ITEM, new SetItemFunctionParser(), "Registering vanilla set item function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.ENCHANT_WITH_LEVELS, new EnchantWithLevelsFunctionParser(), "Registering vanilla enchant with levels function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.ENCHANT_RANDOMLY, new EnchantRandomlyFunctionParser(), "Registering vanilla enchant randomly function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.SET_ENCHANTMENTS, new SetEnchantmentsFunctionParser(), "Registering vanilla set enchantments function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.SET_CUSTOM_DATA, new SetCustomDataFunctionParser(), "Registering vanilla set nbt function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.SET_COMPONENTS, new SetNbtFunctionParser(), "Registering vanilla set components function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.FURNACE_SMELT, new SimpleFunctionParser("emi_loot.function.smelt"), "Registering vanilla furnace smelt function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.ENCHANTED_COUNT_INCREASE, new SimpleFunctionParser("emi_loot.function.looting"), "Registering vanilla looting function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.EXPLORATION_MAP, new ExplorationMapFunctionParser(), "Registering vanilla exploration map function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.SET_NAME, new SetNameFunctionParser(), "Registering vanilla set name function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.SET_CONTENTS, new SimpleFunctionParser("emi_loot.function.set_contents"), "Registering vanilla set contents function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.MODIFY_CONTENTS, new ModifyContentsFunctionParser(), "Registering vanilla modify contents function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.FILTERED, new FilteredFunctionParser(), "Registering vanilla filtered function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.SET_DAMAGE, new SetDamageFunctionParser(), "Registering vanilla set damage function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.SET_INSTRUMENT, new SetInstrumentFunctionParser(), "Registering vanilla set instrument function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.COPY_STATE, new SimpleFunctionParser("emi_loot.function.copy_state"), "Registering vanilla copy state function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.COPY_NAME, new CopyNameFunctionParser(), "Registering vanilla copy name function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.COPY_CUSTOM_DATA, new SimpleFunctionParser("emi_loot.function.copy_nbt"), "Registering vanilla copy nbt function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.COPY_COMPONENTS, new SimpleFunctionParser("emi_loot.function.copy_nbt"), "Registering vanilla copy components function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.EXPLOSION_DECAY, new ExplosionDecayFunctionParser(), "Registering vanilla explosion decay function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.FILL_PLAYER_HEAD, new SimpleFunctionParser("emi_loot.function.fill_player_head"), "Registering vanilla fill-player-head function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.LIMIT_COUNT, new LimitCountFunctionParser(), "Registering vanilla limit-count function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.SET_ATTRIBUTES, new SetAttributesFunctionParser(), "Registering vanilla set attributes function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.SET_BANNER_PATTERN, new SimpleFunctionParser("emi_loot.function.banner"), "Registering vanilla set banner function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.SET_LORE, new SimpleFunctionParser("emi_loot.function.lore"), "Registering vanilla set lore function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.SET_STEW_EFFECT, new SetStewFunctionParser(), "Registering vanilla set stew effect function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.SET_LOOT_TABLE, new SetLootTableFunctionParser(), "Registering vanilla set loot table function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.REFERENCE, new ReferenceFunctionParser(), "Registering vanilla reference function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.SEQUENCE, new SequenceFunctionParser(), "Registering vanilla sequence function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.SET_FIREWORKS, new SetFireworksFunctionParser(), "Registering vanilla fireworks function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.SET_FIREWORK_EXPLOSION, new SetFireworkExplosionFunctionParser(), "Registering vanilla firework explosion function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.SET_BOOK_COVER, new SetBookCoverFunctionParser(), "Registering vanilla book cover function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.SET_WRITTEN_BOOK_PAGES, new SimpleFunctionParser("emi_loot.function.set_pages"), "Registering vanilla set book pages function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.SET_WRITABLE_BOOK_PAGES, new SimpleFunctionParser("emi_loot.function.set_pages"), "Registering vanilla set book pages function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.TOGGLE_TOOLTIPS, new SimpleFunctionParser("emi_loot.function.toggle_tooltip"), "Registering vanilla toggle tooltips function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.SET_OMINOUS_BOTTLE_AMPLIFIER, new SetOminousBottleFunctionParser(), "Registering vanilla ominous bottle amplifier function parser");
        LootParserRegistry.registerFunction(LootItemFunctions.SET_CUSTOM_MODEL_DATA, new SimpleFunctionParser("emi_loot.function.custom_model_data"), "Registering vanilla custom model data function parser");
        LootParserRegistry.registerFunction(EMILoot.OMINOUS_BANNER.get(), new SimpleFunctionParser("emi_loot.function.ominous_banner"), "Registering Lootify ominous banner function parser");
        LootParserRegistry.registerFunction(EMILoot.SET_ANY_DAMAGE.get(), new SetAnyDamageFunctionParser(), "Registering Lootify set-any-damage function parser");
        LootParserRegistry.registerCondition(LootItemConditions.ANY_OF, new MultiplesConditionParser("emi_loot.condition.any_of"), "Registering vanilla any-of condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.ALL_OF, new MultiplesConditionParser("emi_loot.condition.all_of"), "Registering vanilla all-of condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.SURVIVES_EXPLOSION, new SurvivesExplosionConditionParser(), "Registering vanilla survives-explosion condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.BLOCK_STATE_PROPERTY, new BlockStatePropertyConditionParser(), "Registering vanilla block state property condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.TABLE_BONUS, new TableBonusConditionParser(), "Registering vanilla table bonus condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.INVERTED, new InvertedConditionParser(), "Registering vanilla inverted condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.KILLED_BY_PLAYER, new SimpleConditionParser("emi_loot.condition.killed_player"), "Registering vanilla killed-by-player condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.RANDOM_CHANCE, new RandomChanceConditionParser(), "Registering vanilla random chance condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.RANDOM_CHANCE_WITH_ENCHANTED_BONUS, new RandomChanceWithLootingConditionParser(), "Registering vanilla random chance with looting condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.DAMAGE_SOURCE_PROPERTIES, new DamageSourceConditionParser(), "Registering vanilla damage source properties condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.LOCATION_CHECK, new LocationCheckConditionParser(), "Registering vanilla location check condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.ENTITY_PROPERTIES, new EntityPropertiesConditionParser(), "Registering vanilla entity properties condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.MATCH_TOOL, new MatchToolConditionParser(), "Registering vanilla match-tool condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.ENTITY_SCORES, new SimpleConditionParser("emi_loot.condition.entity_scores"), "Registering vanilla entity scores condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.REFERENCE, new ReferenceConditionParser(), "Registering vanilla reference condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.TIME_CHECK, new TimeCheckConditionParser(), "Registering vanilla time check condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.VALUE_CHECK, new ValueCheckConditionParser(), "Registering vanilla value check condition parser");
        LootParserRegistry.registerCondition(LootItemConditions.WEATHER_CHECK, new WeatherCheckConditionParser(), "Registering vanilla weather check condition parser");
        LootParserRegistry.registerCondition(EMILoot.SPAWNS_WITH.get(), new SimpleConditionParser("emi_loot.condition.spawns_with"), "Registering lootify spawns with condition parser");
        LootParserRegistry.registerCondition(EMILoot.CREEPER.get(), new SimpleConditionParser("emi_loot.condition.creeper"), "Registering lootify creeper condition parser");
        LootParserRegistry.registerCondition(EMILoot.WITHER_KILL.get(), new SimpleConditionParser("emi_loot.condition.wither_kill"), "Registering lootify wither-killed condition parser");
    }
}

