/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.emi;

import com.google.common.collect.ArrayListMultimap;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.EMILootAgnos;
import fzzyhmstrs.emi_loot.client.ClientArchaeologyLootTable;
import fzzyhmstrs.emi_loot.emi.EmiClientPlugin;
import fzzyhmstrs.emi_loot.util.FloatTrimmer;
import fzzyhmstrs.emi_loot.util.InteractableTextWidget;
import fzzyhmstrs.emi_loot.util.LText;
import fzzyhmstrs.emi_loot.util.stack.ArchaeologyLootEmiStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class ArchaeologyLootRecipe
implements EmiRecipe {
    private final ClientArchaeologyLootTable loot;
    private final ArrayListMultimap<Float, EmiStack> lootStacksSorted;
    private final int lootStacksSortedSize;
    private final List<EmiStack> outputs;
    private boolean isGuaranteedNonChance = false;
    private final ArchaeologyLootEmiStack inputStack;
    private final float columns = 8.0f;

    public ArchaeologyLootRecipe(ArchaeologyLootRecipeData data) {
        this.loot = data.loot;
        this.isGuaranteedNonChance = data.guaranteed;
        ArrayListMultimap map2 = ArrayListMultimap.create();
        ArrayList<EmiStack> outputsList = new ArrayList<EmiStack>();
        data.map.forEach((weight, item) -> {
            EmiStack stack = EmiStack.of((ItemStack)item);
            map2.put(weight, (Object)stack);
            outputsList.add(stack);
        });
        this.lootStacksSorted = map2;
        this.lootStacksSortedSize = this.loot.items.size() > 48 || EMILoot.config.chestLootAlwaysStackSame ? this.lootStacksSorted.keySet().size() : this.loot.items.size();
        this.outputs = outputsList;
        this.inputStack = new ArchaeologyLootEmiStack(this.loot.id);
    }

    public EmiRecipeCategory getCategory() {
        return EmiClientPlugin.ARCHAEOLOGY_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return ResourceLocation.fromNamespaceAndPath((String)"emi_loot", (String)("/" + this.getCategory().id.getPath() + "/" + this.loot.id.getNamespace() + "/" + this.loot.id.getPath()));
    }

    public List<EmiIngredient> getInputs() {
        EmiIngredient sand = EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.SUSPICIOUS_SAND, Items.SUSPICIOUS_GRAVEL}));
        EmiIngredient brush = EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.BRUSH}));
        return Arrays.asList(sand, brush);
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return 144;
    }

    public int getDisplayHeight() {
        int titleHeight = 11;
        int boxesHeight = (int)Math.ceil((float)this.lootStacksSortedSize / 8.0f) * (EMILoot.config.isCompact(EMILoot.Type.ARCHAEOLOGY) ? 18 : 19) - 1;
        return titleHeight + boxesHeight;
    }

    public void addWidgets(WidgetHolder widgets) {
        int finalRowHeight;
        int titleSpace;
        if (widgets.getHeight() < this.getDisplayHeight()) {
            titleSpace = 9;
            finalRowHeight = (widgets.getHeight() - titleSpace) / (int)Math.ceil((double)this.lootStacksSortedSize / 8.0);
        } else {
            titleSpace = 11;
            finalRowHeight = 18;
        }
        widgets.add((Widget)new InteractableTextWidget(this.inputStack, 1, 0, 0x404040, false).recipeContext(this));
        if (EMILootAgnos.isModLoaded(this.loot.id.getNamespace())) {
            widgets.addTooltip(LText.components(this.inputStack.getName(), this.loot.id.getNamespace()), 0, 0, 144, 10);
        } else {
            widgets.addTooltipText(List.of(this.inputStack.getName()), 0, 0, 144, 10);
        }
        AtomicInteger index = new AtomicInteger(this.lootStacksSortedSize);
        for (Map.Entry entry : this.lootStacksSorted.asMap().entrySet()) {
            float weight = ((Float)entry.getKey()).floatValue();
            Collection items = (Collection)entry.getValue();
            if (this.loot.items.size() <= 48 && !EMILoot.config.chestLootAlwaysStackSame) {
                for (EmiStack stack : items) {
                    int row = (int)Math.ceil((float)index.get() / 8.0f) - 1;
                    int column = (index.get() - 1) % 8;
                    index.getAndDecrement();
                    String fTrim = FloatTrimmer.trimFloatString(weight, (Integer)EMILoot.config.chanceDecimalPlaces.get());
                    SlotWidget slotWidget = new SlotWidget((EmiIngredient)stack, column * 18, titleSpace + row * finalRowHeight).recipeContext((EmiRecipe)this);
                    widgets.add((Widget)slotWidget.appendTooltip((Component)LText.translatable("emi_loot.percentage", fTrim).withStyle(ChatFormatting.GRAY)));
                }
                continue;
            }
            int row = (int)Math.ceil((float)index.get() / 8.0f) - 1;
            int column = (int)((float)(index.get() - 1) % 8.0f);
            index.getAndDecrement();
            EmiIngredient ingredient = EmiIngredient.of(items.stream().toList());
            String fTrim = FloatTrimmer.trimFloatString(Math.max(weight / 100.0f, 0.01f), Math.max((Integer)EMILoot.config.chanceDecimalPlaces.get() + 1, 2));
            SlotWidget slotWidget = new SlotWidget(ingredient, column * 18, titleSpace + row * finalRowHeight).recipeContext((EmiRecipe)this);
            widgets.add((Widget)slotWidget.appendTooltip((Component)LText.translatable("emi_loot.rolls", fTrim).withStyle(ChatFormatting.GRAY)));
        }
    }

    public boolean supportsRecipeTree() {
        return super.supportsRecipeTree() && this.isGuaranteedNonChance;
    }

    public record ArchaeologyLootRecipeData(ClientArchaeologyLootTable loot, ArrayListMultimap<Float, ItemStack> map, boolean guaranteed) {
        public static ArchaeologyLootRecipeData of(ClientArchaeologyLootTable loot) {
            boolean isGuaranteedNonChance = false;
            if (loot.items.size() == 1 && loot.items.values().toFloatArray()[0] == 1.0f) {
                isGuaranteedNonChance = true;
            }
            ArrayListMultimap map2 = ArrayListMultimap.create();
            loot.items.forEach((item, weight) -> map2.put(weight, item));
            Iterator iterator = map2.keySet().iterator();
            while (iterator.hasNext()) {
                float key = ((Float)iterator.next()).floatValue();
                map2.get((Object)Float.valueOf(key)).sort(Comparator.comparingInt(s -> BuiltInRegistries.ITEM.getId((Object)s.getItem())));
            }
            return new ArchaeologyLootRecipeData(loot, (ArrayListMultimap<Float, ItemStack>)map2, isGuaranteedNonChance);
        }
    }
}

