/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.earlywindow.window.sync;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class EarlyWindowReferenceSizeStore {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String FILE_NAME = "early_window_reference.properties";

    private EarlyWindowReferenceSizeStore() {
    }

    public static void persist(Path drippyConfigDir, int width, int height) {
        if (drippyConfigDir == null || width <= 0 || height <= 0) {
            return;
        }
        try {
            Files.createDirectories(drippyConfigDir, new FileAttribute[0]);
            Properties props = new Properties();
            props.setProperty("width", Integer.toString(width));
            props.setProperty("height", Integer.toString(height));
            props.setProperty("timestamp", Long.toString(System.currentTimeMillis()));
            Path file = drippyConfigDir.resolve(FILE_NAME);
            try (OutputStream out = Files.newOutputStream(file, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);){
                props.store(out, "Drippy Loading Screen early-window reference size");
            }
        }
        catch (IOException ex) {
            LOGGER.debug("[DRIPPY LOADING SCREEN] Failed to persist early-window reference size to {}", (Object)drippyConfigDir, (Object)ex);
        }
    }

    public static Optional<ReferenceSize> load(Path drippyConfigDir) {
        if (drippyConfigDir == null) {
            return Optional.empty();
        }
        Path file = drippyConfigDir.resolve(FILE_NAME);
        if (!Files.isRegularFile(file, new LinkOption[0])) {
            return Optional.empty();
        }
        Properties props = new Properties();
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            props.load(in);
        }
        catch (IOException ex) {
            LOGGER.debug("[DRIPPY LOADING SCREEN] Failed to read early-window reference size from {}", (Object)file, (Object)ex);
            return Optional.empty();
        }
        int width = EarlyWindowReferenceSizeStore.parseInt(props.getProperty("width"));
        int height = EarlyWindowReferenceSizeStore.parseInt(props.getProperty("height"));
        long timestamp = EarlyWindowReferenceSizeStore.parseLong(props.getProperty("timestamp"));
        if (width <= 0 || height <= 0) {
            return Optional.empty();
        }
        return Optional.of(new ReferenceSize(width, height, timestamp));
    }

    private static int parseInt(String raw) {
        if (raw == null) {
            return -1;
        }
        try {
            return Integer.parseInt(raw.trim());
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    private static long parseLong(String raw) {
        if (raw == null) {
            return 0L;
        }
        try {
            return Long.parseLong(raw.trim());
        }
        catch (NumberFormatException ex) {
            return 0L;
        }
    }

    public record ReferenceSize(int width, int height, long timestampMillis) {
    }
}

