/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.earlywindow.window.config;

import de.keksuccino.drippyloadingscreen.earlywindow.window.config.EarlyLoadingOptions;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class EarlyLoadingOptionsLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String SECTION_PREFIX = "##[";
    private static final String[] PLACEHOLDER_TEXTURE_VALUES = new String[]{"/config/fancymenu/assets/some_image.png", "/config/fancymenu/assets/some_bar_background_image.png", "/config/fancymenu/assets/some_bar_progress_image.png"};
    private final Path optionsFile;

    public EarlyLoadingOptionsLoader(Path configDirectory) {
        this.optionsFile = configDirectory.resolve("drippyloadingscreen").resolve("options.txt");
    }

    public EarlyLoadingOptions load() {
        EarlyLoadingOptions defaults = EarlyLoadingOptions.defaults();
        if (!Files.isRegularFile(this.optionsFile, new LinkOption[0])) {
            LOGGER.debug("Early loading options file {} not found, using defaults", (Object)this.optionsFile);
            return defaults;
        }
        HashMap<String, String> values = new HashMap<String, String>();
        try {
            for (String rawLine : Files.readAllLines(this.optionsFile, StandardCharsets.UTF_8)) {
                EarlyLoadingOptionsLoader.parseLine(rawLine, values);
            }
        }
        catch (IOException ioException) {
            LOGGER.warn("Failed to read Drippy options from {}", (Object)this.optionsFile, (Object)ioException);
            return defaults;
        }
        return new EarlyLoadingOptions(EarlyLoadingOptionsLoader.sanitizeTextureValue((String)values.get("early_loading_background_texture_path")), EarlyLoadingOptionsLoader.parseBoolean((String)values.get("early_loading_background_preserve_aspect_ratio"), defaults.backgroundPreserveAspectRatio()), EarlyLoadingOptionsLoader.sanitizeTextureValue((String)values.get("early_loading_logo_texture_path")), EarlyLoadingOptionsLoader.parseInt((String)values.get("early_loading_logo_width"), defaults.logoWidth()), EarlyLoadingOptionsLoader.parseInt((String)values.get("early_loading_logo_height"), defaults.logoHeight()), EarlyLoadingOptionsLoader.parseInt((String)values.get("early_loading_logo_position_offset_x"), defaults.logoOffsetX()), EarlyLoadingOptionsLoader.parseInt((String)values.get("early_loading_logo_position_offset_y"), defaults.logoOffsetY()), EarlyLoadingOptionsLoader.sanitizeTitle((String)values.get("early_loading_window_title"), defaults.windowTitle()), EarlyLoadingOptionsLoader.sanitizeTextureValue((String)values.get("early_loading_bar_background_texture_path")), EarlyLoadingOptionsLoader.sanitizeTextureValue((String)values.get("early_loading_bar_progress_texture_path")), EarlyLoadingOptionsLoader.parseInt((String)values.get("early_loading_bar_width"), defaults.barWidth()), EarlyLoadingOptionsLoader.parseInt((String)values.get("early_loading_bar_height"), defaults.barHeight()), EarlyLoadingOptionsLoader.parseInt((String)values.get("early_loading_bar_position_offset_x"), defaults.barOffsetX()), EarlyLoadingOptionsLoader.parseInt((String)values.get("early_loading_bar_position_offset_y"), defaults.barOffsetY()), EarlyLoadingOptionsLoader.parseInt((String)values.get("early_loading_window_width"), defaults.windowWidthOverride()), EarlyLoadingOptionsLoader.parseInt((String)values.get("early_loading_window_height"), defaults.windowHeightOverride()), EarlyLoadingOptionsLoader.parseBoolean((String)values.get("early_loading_hide_logo"), defaults.hideLogo()), EarlyLoadingOptionsLoader.parseBoolean((String)values.get("early_loading_hide_bar"), defaults.hideBar()), EarlyLoadingOptionsLoader.parseBoolean((String)values.get("early_loading_hide_logger"), defaults.hideLogger()), EarlyLoadingOptionsLoader.sanitizeTextureValue((String)values.get("early_loading_top_left_watermark_texture_path")), EarlyLoadingOptionsLoader.parseInt((String)values.get("early_loading_top_left_watermark_width"), defaults.topLeftWatermarkWidth()), EarlyLoadingOptionsLoader.parseInt((String)values.get("early_loading_top_left_watermark_height"), defaults.topLeftWatermarkHeight()), EarlyLoadingOptionsLoader.parseInt((String)values.get("early_loading_top_left_watermark_position_offset_x"), defaults.topLeftWatermarkOffsetX()), EarlyLoadingOptionsLoader.parseInt((String)values.get("early_loading_top_left_watermark_position_offset_y"), defaults.topLeftWatermarkOffsetY()), EarlyLoadingOptionsLoader.sanitizeTextureValue((String)values.get("early_loading_top_right_watermark_texture_path")), EarlyLoadingOptionsLoader.parseInt((String)values.get("early_loading_top_right_watermark_width"), defaults.topRightWatermarkWidth()), EarlyLoadingOptionsLoader.parseInt((String)values.get("early_loading_top_right_watermark_height"), defaults.topRightWatermarkHeight()), EarlyLoadingOptionsLoader.parseInt((String)values.get("early_loading_top_right_watermark_position_offset_x"), defaults.topRightWatermarkOffsetX()), EarlyLoadingOptionsLoader.parseInt((String)values.get("early_loading_top_right_watermark_position_offset_y"), defaults.topRightWatermarkOffsetY()), EarlyLoadingOptionsLoader.sanitizeTextureValue((String)values.get("early_loading_bottom_left_watermark_texture_path")), EarlyLoadingOptionsLoader.parseInt((String)values.get("early_loading_bottom_left_watermark_width"), defaults.bottomLeftWatermarkWidth()), EarlyLoadingOptionsLoader.parseInt((String)values.get("early_loading_bottom_left_watermark_height"), defaults.bottomLeftWatermarkHeight()), EarlyLoadingOptionsLoader.parseInt((String)values.get("early_loading_bottom_left_watermark_position_offset_x"), defaults.bottomLeftWatermarkOffsetX()), EarlyLoadingOptionsLoader.parseInt((String)values.get("early_loading_bottom_left_watermark_position_offset_y"), defaults.bottomLeftWatermarkOffsetY()), EarlyLoadingOptionsLoader.sanitizeTextureValue((String)values.get("early_loading_bottom_right_watermark_texture_path")), EarlyLoadingOptionsLoader.parseInt((String)values.get("early_loading_bottom_right_watermark_width"), defaults.bottomRightWatermarkWidth()), EarlyLoadingOptionsLoader.parseInt((String)values.get("early_loading_bottom_right_watermark_height"), defaults.bottomRightWatermarkHeight()), EarlyLoadingOptionsLoader.parseInt((String)values.get("early_loading_bottom_right_watermark_position_offset_x"), defaults.bottomRightWatermarkOffsetX()), EarlyLoadingOptionsLoader.parseInt((String)values.get("early_loading_bottom_right_watermark_position_offset_y"), defaults.bottomRightWatermarkOffsetY()));
    }

    private static void parseLine(String rawLine, Map<String, String> values) {
        String line = rawLine.trim();
        if (line.isEmpty() || line.startsWith("#") || line.startsWith(SECTION_PREFIX)) {
            return;
        }
        int typeSeparator = line.indexOf(58);
        int assignmentIndex = line.indexOf(61);
        if (typeSeparator <= 0 || assignmentIndex <= typeSeparator) {
            return;
        }
        String key = line.substring(typeSeparator + 1, assignmentIndex).trim();
        if (key.isEmpty()) {
            return;
        }
        String valuePortion = line.substring(assignmentIndex + 1).trim();
        if (valuePortion.endsWith(";")) {
            valuePortion = valuePortion.substring(0, valuePortion.length() - 1).trim();
        }
        if (valuePortion.length() >= 2 && valuePortion.startsWith("'") && valuePortion.endsWith("'")) {
            valuePortion = valuePortion.substring(1, valuePortion.length() - 1);
        }
        values.put(key, valuePortion);
    }

    private static int parseInt(String raw, int fallback) {
        if (raw == null || raw.isBlank()) {
            return fallback;
        }
        try {
            return Integer.parseInt(raw.trim());
        }
        catch (NumberFormatException ex) {
            return fallback;
        }
    }

    private static boolean parseBoolean(String raw, boolean fallback) {
        if (raw == null || raw.isBlank()) {
            return fallback;
        }
        String normalized = raw.trim().toLowerCase(Locale.ROOT);
        if ("true".equals(normalized) || "false".equals(normalized)) {
            return Boolean.parseBoolean(normalized);
        }
        return fallback;
    }

    private static String sanitizeTextureValue(String raw) {
        if (raw == null) {
            return null;
        }
        String trimmed = raw.trim();
        if (trimmed.isEmpty()) {
            return null;
        }
        for (String placeholder : PLACEHOLDER_TEXTURE_VALUES) {
            if (!placeholder.equalsIgnoreCase(trimmed)) continue;
            return null;
        }
        return trimmed;
    }

    private static String sanitizeTitle(String raw, String fallback) {
        if (raw == null) {
            return fallback;
        }
        String trimmed = raw.trim();
        return trimmed.isEmpty() ? fallback : trimmed;
    }
}

