/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.earlywindow.window;

import de.keksuccino.drippyloadingscreen.earlywindow.window.config.EarlyLoadingOptions;
import de.keksuccino.drippyloadingscreen.earlywindow.window.config.EarlyLoadingOptionsLoader;
import de.keksuccino.drippyloadingscreen.earlywindow.window.sync.EarlyWindowReferenceSizeStore;
import de.keksuccino.drippyloadingscreen.earlywindow.window.texture.EarlyWindowTextureLoader;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import net.neoforged.fml.loading.FMLConfig;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.loading.progress.Message;
import net.neoforged.fml.loading.progress.ProgressMeter;
import net.neoforged.fml.loading.progress.StartupNotificationManager;
import net.neoforged.neoforgespi.earlywindow.ImmediateWindowProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.stb.STBEasyFont;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class DrippyEarlyWindowProvider
implements ImmediateWindowProvider {
    public static final String PROVIDER_NAME = "drippy_early_window";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Runnable EMPTY_TICK = () -> {};
    private static final String MOJANG_LOGO_PATH = "assets/minecraft/textures/gui/title/mojangstudios.png";
    private static final float INDETERMINATE_SEGMENT_WIDTH = 0.3f;
    private static final float LOGGER_LINE_HEIGHT = 12.0f;
    private static final float LOGGER_MARGIN = 10.0f;
    private static final int LOGGER_MAX_VISIBLE_LINES = 6;
    private static final int LOGGER_MAX_MESSAGE_LENGTH = 256;
    private static final int LOGGER_VERTEX_BUFFER_CAPACITY = 76800;
    private static final float LOGGER_BASE_TEXT_SCALE = 1.35f;
    private static final float LOGGER_MIN_UI_SCALE = 0.75f;
    private static final boolean LOGGER_DEBUG_MODE = false;
    private static final long LOGGER_DEBUG_MESSAGE_INTERVAL_NANOS = 2000000000L;
    private static final String[] LOGGER_DEBUG_MESSAGE_POOL = new String[]{"Initializing Drippy Early Window renderer...", "Connecting to NeoForge loading pipeline", "Registering FancyMenu compatibility hooks", "Preparing APNG decoder", "Waiting for Minecraft bootstrap", "Completing early window handoff"};
    private static final float MOJANG_LOGO_U_OVERLAP = 0.0625f;
    private static final Duration WEB_TEXTURE_TIMEOUT = Duration.ofSeconds(20L);
    private long window;
    private boolean running;
    private int windowWidth;
    private int windowHeight;
    private int baseWindowWidth = 1;
    private int baseWindowHeight = 1;
    private int framebufferWidth;
    private int framebufferHeight;
    private int windowX;
    private int windowY;
    private Runnable ticker = EMPTY_TICK;
    private String glVersion = "3.2";
    private Constructor<?> overlayConstructor;
    private Thread renderThread;
    private GLCapabilities renderCapabilities;
    private final ConcurrentLinkedQueue<PendingTextureUpload> pendingWebTextures = new ConcurrentLinkedQueue();
    private HttpClient httpClient;
    private Path gameDirectory;
    private Path drippyConfigDirectory;
    private EarlyLoadingOptions options = EarlyLoadingOptions.defaults();
    private ColorScheme colorScheme = ColorScheme.red();
    private EarlyWindowTextureLoader textureLoader;
    private String effectiveWindowTitle = "Minecraft";
    private EarlyWindowTextureLoader.LoadedTexture backgroundTexture;
    private EarlyWindowTextureLoader.LoadedTexture logoTexture;
    private EarlyWindowTextureLoader.LoadedTexture barBackgroundTexture;
    private EarlyWindowTextureLoader.LoadedTexture barProgressTexture;
    private EarlyWindowTextureLoader.LoadedTexture topLeftWatermarkTexture;
    private EarlyWindowTextureLoader.LoadedTexture topRightWatermarkTexture;
    private EarlyWindowTextureLoader.LoadedTexture bottomLeftWatermarkTexture;
    private EarlyWindowTextureLoader.LoadedTexture bottomRightWatermarkTexture;
    private boolean useBundledMojangLogo;
    private final ByteBuffer loggerVertexBuffer = BufferUtils.createByteBuffer((int)76800);
    private final List<DebugLoggerMessage> loggerDebugMessages = new ArrayList<DebugLoggerMessage>();
    private long lastDebugMessageNanos;
    private float displayedProgress;
    private boolean progressIndeterminate;
    private float indeterminateOffset;
    private long lastProgressSampleNanos;
    private long currentFrameTimestampNanos;

    public String name() {
        return PROVIDER_NAME;
    }

    public Runnable initialize(String[] arguments) {
        this.gameDirectory = FMLPaths.GAMEDIR.get();
        this.textureLoader = new EarlyWindowTextureLoader(this.gameDirectory, DrippyEarlyWindowProvider.class.getClassLoader());
        Path configDir = FMLPaths.CONFIGDIR.get();
        this.drippyConfigDirectory = configDir.resolve("drippyloadingscreen");
        this.options = new EarlyLoadingOptionsLoader(configDir).load();
        this.effectiveWindowTitle = this.options.windowTitle();
        this.colorScheme = this.resolveColorScheme();
        this.setupWindow();
        this.startRenderThread();
        this.ticker = this::pollEvents;
        return this::periodicTick;
    }

    private void setupWindow() {
        GLFWErrorCallback.createPrint((PrintStream)System.err).set();
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("[DRIPPY LOADING SCREEN] Failed to initialize GLFW for Drippy early window!");
        }
        int configuredWidth = Math.max(1, FMLConfig.getIntConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_WIDTH));
        int configuredHeight = Math.max(1, FMLConfig.getIntConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_HEIGHT));
        if (this.options.windowWidthOverride() != -1) {
            configuredWidth = Math.max(1, this.options.windowWidthOverride());
        }
        if (this.options.windowHeightOverride() != -1) {
            configuredHeight = Math.max(1, this.options.windowHeightOverride());
        }
        this.windowWidth = configuredWidth;
        this.windowHeight = configuredHeight;
        this.baseWindowWidth = configuredWidth;
        this.baseWindowHeight = configuredHeight;
        EarlyWindowReferenceSizeStore.persist(this.drippyConfigDirectory, this.baseWindowWidth, this.baseWindowHeight);
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)131076, (int)1);
        GLFW.glfwWindowHint((int)131075, (int)1);
        GLFW.glfwWindowHint((int)139266, (int)3);
        GLFW.glfwWindowHint((int)139267, (int)2);
        GLFW.glfwWindowHint((int)139272, (int)204802);
        this.window = GLFW.glfwCreateWindow((int)this.windowWidth, (int)this.windowHeight, (CharSequence)this.effectiveWindowTitle, (long)0L, (long)0L);
        if (this.window == 0L) {
            throw new IllegalStateException("[DRIPPY LOADING SCREEN] Failed to create Drippy early window!");
        }
        this.centerWindow();
        GLFW.glfwMakeContextCurrent((long)this.window);
        this.updateFramebufferFromWindow();
        GLFW.glfwSetFramebufferSizeCallback((long)this.window, (handle, width, height) -> {
            this.framebufferWidth = Math.max(1, width);
            this.framebufferHeight = Math.max(1, height);
        });
        GLFW.glfwSetWindowSizeCallback((long)this.window, (handle, width, height) -> {
            this.windowWidth = Math.max(1, width);
            this.windowHeight = Math.max(1, height);
        });
        GLFW.glfwSetWindowPosCallback((long)this.window, (handle, x, y) -> {
            this.windowX = x;
            this.windowY = y;
        });
        GLFW.glfwShowWindow((long)this.window);
        GLFW.glfwMakeContextCurrent((long)0L);
        this.running = true;
    }

    private void centerWindow() {
        GLFWVidMode videoMode;
        long primaryMonitor = GLFW.glfwGetPrimaryMonitor();
        GLFWVidMode gLFWVidMode = videoMode = primaryMonitor != 0L ? GLFW.glfwGetVideoMode((long)primaryMonitor) : null;
        if (videoMode != null) {
            int x = Math.max(0, videoMode.width() - this.windowWidth) / 2;
            int y = Math.max(0, videoMode.height() - this.windowHeight) / 2;
            GLFW.glfwSetWindowPos((long)this.window, (int)x, (int)y);
            this.windowX = x;
            this.windowY = y;
        } else {
            try (MemoryStack stack = MemoryStack.stackPush();){
                IntBuffer posX = stack.mallocInt(1);
                IntBuffer posY = stack.mallocInt(1);
                GLFW.glfwGetWindowPos((long)this.window, (IntBuffer)posX, (IntBuffer)posY);
                this.windowX = posX.get(0);
                this.windowY = posY.get(0);
            }
        }
    }

    private void updateFramebufferFromWindow() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer fbw = stack.mallocInt(1);
            IntBuffer fbh = stack.mallocInt(1);
            GLFW.glfwGetFramebufferSize((long)this.window, (IntBuffer)fbw, (IntBuffer)fbh);
            this.framebufferWidth = Math.max(1, fbw.get(0));
            this.framebufferHeight = Math.max(1, fbh.get(0));
        }
    }

    private void startRenderThread() {
        this.renderThread = new Thread(this::renderLoop, "Drippy-EarlyWindow");
        this.renderThread.setDaemon(true);
        this.renderThread.start();
    }

    private void renderLoop() {
        GLFW.glfwMakeContextCurrent((long)this.window);
        this.renderCapabilities = GL.createCapabilities();
        GL.setCapabilities((GLCapabilities)this.renderCapabilities);
        this.glVersion = Optional.ofNullable(GL11.glGetString((int)7938)).orElse(this.glVersion);
        GLFW.glfwSwapInterval((int)1);
        this.loadTextures();
        this.lastProgressSampleNanos = System.nanoTime();
        try {
            while (this.running && !GLFW.glfwWindowShouldClose((long)this.window)) {
                GL.setCapabilities((GLCapabilities)this.renderCapabilities);
                this.drawFrame();
                GLFW.glfwSwapBuffers((long)this.window);
            }
        }
        finally {
            this.cleanupTextures();
            GL.setCapabilities(null);
            GLFW.glfwMakeContextCurrent((long)0L);
        }
    }

    public void updateFramebufferSize(IntConsumer width, IntConsumer height) {
        width.accept(this.framebufferWidth);
        height.accept(this.framebufferHeight);
    }

    public long setupMinecraftWindow(IntSupplier width, IntSupplier height, Supplier<String> title, LongSupplier monitor) {
        this.running = false;
        this.ticker = EMPTY_TICK;
        if (this.renderThread != null) {
            try {
                this.renderThread.join(2000L);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        }
        GLFW.glfwMakeContextCurrent((long)this.window);
        GL.createCapabilities();
        GLFW.glfwSetWindowTitle((long)this.window, (CharSequence)title.get());
        GLFW.glfwSwapInterval((int)0);
        GLFW.glfwMakeContextCurrent((long)0L);
        return this.window;
    }

    public boolean positionWindow(Optional<Object> monitor, IntConsumer widthSetter, IntConsumer heightSetter, IntConsumer xSetter, IntConsumer ySetter) {
        widthSetter.accept(this.windowWidth);
        heightSetter.accept(this.windowHeight);
        xSetter.accept(this.windowX);
        ySetter.accept(this.windowY);
        return true;
    }

    public <T> Supplier<T> loadingOverlay(Supplier<?> mc, Supplier<?> ri, Consumer<Optional<Throwable>> ex, boolean fade) {
        if (this.overlayConstructor == null) {
            throw new IllegalStateException("[DRIPPY LOADING SCREEN] Custom loading overlay is not available yet!");
        }
        return () -> {
            try {
                Object overlay;
                Object castOverlay = overlay = this.overlayConstructor.newInstance(mc.get(), ri.get(), ex, fade);
                return castOverlay;
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("[DRIPPY LOADING SCREEN] Failed to create Drippy loading overlay!", e);
            }
        };
    }

    public void updateModuleReads(ModuleLayer layer) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> overlayClass = Class.forName("de.keksuccino.drippyloadingscreen.neoforge.CustomLoadingOverlay", false, loader);
            Class<?> minecraftClass = Class.forName("net.minecraft.client.Minecraft", false, loader);
            Class<?> reloadClass = Class.forName("net.minecraft.server.packs.resources.ReloadInstance", false, loader);
            this.overlayConstructor = overlayClass.getConstructor(minecraftClass, reloadClass, Consumer.class, Boolean.TYPE);
        }
        catch (Exception e) {
            throw new IllegalStateException("[DRIPPY LOADING SCREEN] Custom loading overlay class missing!", e);
        }
    }

    public void periodicTick() {
        this.ticker.run();
    }

    private void pollEvents() {
        if (this.window != 0L) {
            GLFW.glfwPollEvents();
        }
    }

    public String getGLVersion() {
        return this.glVersion;
    }

    public void crash(String message) {
        LOGGER.error("Early window crash: {}", (Object)message);
        TinyFileDialogs.tinyfd_messageBox((CharSequence)"Drippy Loading Screen", (CharSequence)message, (CharSequence)"ok", (CharSequence)"error", (boolean)true);
    }

    private void drawFrame() {
        this.processPendingWebTextures();
        this.updateProgressMetrics();
        this.currentFrameTimestampNanos = System.nanoTime();
        GL11.glViewport((int)0, (int)0, (int)this.framebufferWidth, (int)this.framebufferHeight);
        GL11.glDisable((int)2929);
        GL11.glClearColor((float)this.colorScheme.background().r(), (float)this.colorScheme.background().g(), (float)this.colorScheme.background().b(), (float)1.0f);
        GL11.glClear((int)16384);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)this.windowWidth, (double)this.windowHeight, (double)0.0, (double)-1.0, (double)1.0);
        GL11.glMatrixMode((int)5888);
        GL11.glLoadIdentity();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        float uiScale = this.computeUiScale();
        this.renderBackgroundLayer();
        float logoBottom = this.renderLogoLayer(uiScale);
        this.renderProgressBar(logoBottom, uiScale);
        this.renderWatermarks(uiScale);
        this.renderLoggerOverlay(uiScale);
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void renderBackgroundLayer() {
        this.drawSolidQuad(0.0f, 0.0f, this.windowWidth, this.windowHeight, this.colorScheme.background(), 1.0f);
        if (this.backgroundTexture == null) {
            return;
        }
        float drawWidth = this.windowWidth;
        float drawHeight = this.windowHeight;
        float x = 0.0f;
        float y = 0.0f;
        if (this.options.backgroundPreserveAspectRatio() && this.backgroundTexture.width() > 0 && this.backgroundTexture.height() > 0) {
            float windowRatio = (float)this.windowWidth / (float)this.windowHeight;
            float textureRatio = (float)this.backgroundTexture.width() / (float)this.backgroundTexture.height();
            if (windowRatio > textureRatio) {
                drawWidth = this.windowWidth;
                drawHeight = drawWidth / textureRatio;
                y = ((float)this.windowHeight - drawHeight) / 2.0f;
            } else {
                drawHeight = this.windowHeight;
                drawWidth = drawHeight * textureRatio;
                x = ((float)this.windowWidth - drawWidth) / 2.0f;
            }
        }
        this.drawTexturedQuad(x, y, drawWidth, drawHeight, this.backgroundTexture, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    private float renderLogoLayer(float uiScale) {
        float scaledOffsetY = (float)this.options.logoOffsetY() * uiScale;
        if (this.options.hideLogo()) {
            return (float)this.windowHeight / 2.0f + scaledOffsetY;
        }
        if (this.logoTexture == null) {
            return (float)this.windowHeight / 2.0f + scaledOffsetY;
        }
        float baseWidth = this.options.logoWidth() > 0 ? (float)this.options.logoWidth() : (float)this.logoTexture.width();
        float baseHeight = this.options.logoHeight() > 0 ? (float)this.options.logoHeight() : (float)this.logoTexture.height();
        float width = Math.max(1.0f, baseWidth * uiScale);
        float height = Math.max(1.0f, baseHeight * uiScale);
        float offsetX = (float)this.options.logoOffsetX() * uiScale;
        float x = ((float)this.windowWidth - width) / 2.0f + offsetX;
        float baseline = (float)this.windowHeight * 0.35f;
        float y = baseline + scaledOffsetY;
        if (this.useBundledMojangLogo) {
            this.drawBundledMojangLogo(x, y, width, height, this.logoTexture);
        } else {
            this.drawTexturedQuad(x, y, width, height, this.logoTexture, 0.0f, 0.0f, 1.0f, 1.0f);
        }
        return y + height;
    }

    private void renderProgressBar(float logoBottom, float uiScale) {
        ProgressFrameMetrics frameMetrics;
        if (this.options.hideBar()) {
            return;
        }
        int configuredWidth = Math.max(32, this.options.barWidth());
        int configuredHeight = Math.max(6, this.options.barHeight());
        float targetWidth = (float)configuredWidth * uiScale;
        float targetHeight = (float)configuredHeight * uiScale;
        float minWidth = 32.0f * uiScale;
        float minHeight = 6.0f * uiScale;
        float maxWidth = Math.max(minWidth, (float)this.windowWidth - 40.0f);
        float maxHeight = Math.max(minHeight, (float)this.windowHeight / 6.0f);
        float width = Math.max(minWidth, Math.min(targetWidth, maxWidth));
        float height = Math.max(minHeight, Math.min(targetHeight, maxHeight));
        float offsetX = (float)this.options.barOffsetX() * uiScale;
        float offsetY = (float)this.options.barOffsetY() * uiScale;
        float baseX = ((float)this.windowWidth - width) / 2.0f + offsetX;
        float spacing = 32.0f * uiScale;
        float fallbackSpacing = 20.0f * uiScale;
        float defaultY = logoBottom > 0.0f ? logoBottom + spacing : (float)this.windowHeight / 2.0f + fallbackSpacing;
        float minY = 10.0f * uiScale;
        float maxY = Math.max(minY, (float)this.windowHeight - height - minY);
        float baseY = DrippyEarlyWindowProvider.clamp(defaultY + offsetY, minY, maxY);
        float minX = 10.0f * uiScale;
        float maxX = Math.max(minX, (float)this.windowWidth - width - minX);
        baseX = DrippyEarlyWindowProvider.clamp(baseX, minX, maxX);
        boolean vanillaBar = this.barBackgroundTexture == null && this.barProgressTexture == null;
        ProgressFrameMetrics progressFrameMetrics = frameMetrics = vanillaBar ? this.computeProgressFrameMetrics(width, height, this.computeGuiPixelScale()) : null;
        if (this.barBackgroundTexture != null) {
            this.drawTexturedQuad(baseX, baseY, width, height, this.barBackgroundTexture, 0.0f, 0.0f, 1.0f, 1.0f);
        } else if (vanillaBar && frameMetrics != null) {
            this.drawVanillaProgressFrame(baseX, baseY, width, height, frameMetrics);
        } else {
            this.drawSolidQuad(baseX, baseY, width, height, this.colorScheme.background().withBrightness(0.5f), 0.9f);
            this.drawRectangleOutline(baseX, baseY, width, height, this.colorScheme.foreground(), 1.0f);
        }
        if (this.progressIndeterminate) {
            this.drawIndeterminateProgress(baseX, baseY, width, height, frameMetrics);
        } else {
            float clampedProgress = Math.max(0.0f, Math.min(1.0f, this.displayedProgress));
            this.drawProgressSegment(baseX, baseY, width, height, 0.0f, clampedProgress, frameMetrics);
        }
    }

    private void renderWatermarks(float uiScale) {
        this.renderWatermark(this.topLeftWatermarkTexture, this.options.topLeftWatermarkWidth(), this.options.topLeftWatermarkHeight(), this.options.topLeftWatermarkOffsetX(), this.options.topLeftWatermarkOffsetY(), WatermarkAnchor.TOP_LEFT, uiScale);
        this.renderWatermark(this.topRightWatermarkTexture, this.options.topRightWatermarkWidth(), this.options.topRightWatermarkHeight(), this.options.topRightWatermarkOffsetX(), this.options.topRightWatermarkOffsetY(), WatermarkAnchor.TOP_RIGHT, uiScale);
        this.renderWatermark(this.bottomLeftWatermarkTexture, this.options.bottomLeftWatermarkWidth(), this.options.bottomLeftWatermarkHeight(), this.options.bottomLeftWatermarkOffsetX(), this.options.bottomLeftWatermarkOffsetY(), WatermarkAnchor.BOTTOM_LEFT, uiScale);
        this.renderWatermark(this.bottomRightWatermarkTexture, this.options.bottomRightWatermarkWidth(), this.options.bottomRightWatermarkHeight(), this.options.bottomRightWatermarkOffsetX(), this.options.bottomRightWatermarkOffsetY(), WatermarkAnchor.BOTTOM_RIGHT, uiScale);
    }

    private void renderWatermark(EarlyWindowTextureLoader.LoadedTexture texture, int configuredWidth, int configuredHeight, int offsetX, int offsetY, WatermarkAnchor anchor, float uiScale) {
        float x;
        if (texture == null) {
            return;
        }
        int fallbackWidth = texture.width() > 0 ? texture.width() : 1;
        int fallbackHeight = texture.height() > 0 ? texture.height() : 1;
        float width = Math.max(1.0f, (float)(configuredWidth > 0 ? configuredWidth : fallbackWidth) * uiScale);
        float height = Math.max(1.0f, (float)(configuredHeight > 0 ? configuredHeight : fallbackHeight) * uiScale);
        float scaledOffsetX = (float)offsetX * uiScale;
        float scaledOffsetY = (float)offsetY * uiScale;
        this.drawTexturedQuad(x, switch (anchor.ordinal()) {
            case 0 -> {
                x = scaledOffsetX;
                yield scaledOffsetY;
            }
            case 1 -> {
                x = (float)this.windowWidth - width + scaledOffsetX;
                yield scaledOffsetY;
            }
            case 2 -> {
                x = scaledOffsetX;
                yield (float)this.windowHeight - height + scaledOffsetY;
            }
            case 3 -> {
                x = (float)this.windowWidth - width + scaledOffsetX;
                yield (float)this.windowHeight - height + scaledOffsetY;
            }
            default -> {
                x = scaledOffsetX;
                yield scaledOffsetY;
            }
        }, width, height, texture, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    private void renderLoggerOverlay(float uiScale) {
        float margin;
        if (this.options.hideLogger()) {
            return;
        }
        List<StartupNotificationManager.AgeMessage> rawMessages = this.collectLoggerMessages();
        if (rawMessages.isEmpty()) {
            return;
        }
        ArrayList<LoggerLine> lines = new ArrayList<LoggerLine>();
        for (int i = rawMessages.size() - 1; i >= 0; --i) {
            String sanitized;
            StartupNotificationManager.AgeMessage ageMessage = rawMessages.get(i);
            float fade = DrippyEarlyWindowProvider.computeLoggerFade(ageMessage.age(), i);
            if (fade <= 0.01f || (sanitized = DrippyEarlyWindowProvider.sanitizeLogMessage(ageMessage.message().getText())).isEmpty()) continue;
            lines.add(new LoggerLine(sanitized, fade));
        }
        if (lines.isEmpty()) {
            return;
        }
        int visible = Math.min(lines.size(), 6);
        int startIndex = lines.size() - visible;
        float effectiveUiScale = Math.max(0.75f, uiScale);
        float textScale = 1.35f * effectiveUiScale;
        float lineHeight = 12.0f * textScale;
        float totalHeight = (float)visible * lineHeight;
        float startY = (float)this.windowHeight - totalHeight - (margin = 10.0f * textScale);
        if (startY < margin) {
            startY = margin;
        }
        float x = margin;
        for (int idx = 0; idx < visible; ++idx) {
            LoggerLine line = (LoggerLine)lines.get(startIndex + idx);
            float y = startY + (float)idx * lineHeight;
            this.drawLoggerLine(line.text(), x, y, line.alpha(), textScale);
        }
    }

    private void drawLoggerLine(String text, float x, float y, float alpha, float textScale) {
        if (text == null || text.isEmpty()) {
            return;
        }
        this.loggerVertexBuffer.clear();
        int quadCount = STBEasyFont.stb_easy_font_print((float)0.0f, (float)0.0f, (CharSequence)text, null, (ByteBuffer)this.loggerVertexBuffer);
        if (quadCount <= 0) {
            return;
        }
        this.loggerVertexBuffer.limit(this.loggerVertexBuffer.capacity());
        this.loggerVertexBuffer.position(0);
        boolean texturesEnabled = GL11.glIsEnabled((int)3553);
        GL11.glDisable((int)3553);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)textScale, (float)textScale, (float)1.0f);
        GL11.glEnableClientState((int)32884);
        GL11.glVertexPointer((int)2, (int)5126, (int)16, (ByteBuffer)this.loggerVertexBuffer);
        Color foreground = this.colorScheme.foreground();
        GL11.glColor4f((float)foreground.r(), (float)foreground.g(), (float)foreground.b(), (float)DrippyEarlyWindowProvider.clamp(alpha, 0.0f, 1.0f));
        GL11.glDrawArrays((int)7, (int)0, (int)(quadCount * 4));
        GL11.glDisableClientState((int)32884);
        GL11.glPopMatrix();
        if (texturesEnabled) {
            GL11.glEnable((int)3553);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private List<StartupNotificationManager.AgeMessage> collectLoggerMessages() {
        ArrayList<StartupNotificationManager.AgeMessage> messages = new ArrayList<StartupNotificationManager.AgeMessage>(StartupNotificationManager.getMessages());
        return messages;
    }

    private void injectDebugLoggerMessage() {
        long now = System.nanoTime();
        if (now - this.lastDebugMessageNanos < 2000000000L) {
            return;
        }
        this.lastDebugMessageNanos = now;
        ThreadLocalRandom random = ThreadLocalRandom.current();
        String message = LOGGER_DEBUG_MESSAGE_POOL[random.nextInt(LOGGER_DEBUG_MESSAGE_POOL.length)];
        this.loggerDebugMessages.add(new DebugLoggerMessage(message, now));
        if (this.loggerDebugMessages.size() > 12) {
            this.loggerDebugMessages.remove(0);
        }
    }

    private List<StartupNotificationManager.AgeMessage> buildDebugLoggerAgeMessages() {
        long now = System.nanoTime();
        ArrayList<StartupNotificationManager.AgeMessage> debugMessages = new ArrayList<StartupNotificationManager.AgeMessage>();
        for (DebugLoggerMessage message : this.loggerDebugMessages) {
            int ageMillis = (int)((now - message.createdAtNanos()) / 1000000L);
            debugMessages.add(new StartupNotificationManager.AgeMessage(ageMillis, new Message(message.text(), null)));
        }
        return debugMessages;
    }

    private void drawIndeterminateProgress(float x, float y, float width, float height, ProgressFrameMetrics frameMetrics) {
        float start = this.indeterminateOffset;
        float end = start + 0.3f;
        if (end <= 1.0f) {
            this.drawProgressSegment(x, y, width, height, start, end, frameMetrics);
        } else {
            this.drawProgressSegment(x, y, width, height, start, 1.0f, frameMetrics);
            this.drawProgressSegment(x, y, width, height, 0.0f, end - 1.0f, frameMetrics);
        }
    }

    private void drawProgressSegment(float baseX, float baseY, float width, float height, float start, float end, ProgressFrameMetrics frameMetrics) {
        if (end <= start) {
            return;
        }
        float segmentWidth = width * (end - start);
        float segmentX = baseX + width * start;
        if (this.barProgressTexture != null) {
            this.drawTexturedQuad(segmentX, baseY, segmentWidth, height, this.barProgressTexture, start, 0.0f, end, 1.0f);
        } else if (frameMetrics != null) {
            this.drawVanillaProgressSegment(baseX, baseY, width, height, start, end, frameMetrics);
        } else {
            this.drawSolidQuad(segmentX, baseY, segmentWidth, height, this.colorScheme.foreground(), 1.0f);
        }
    }

    private ProgressFrameMetrics computeProgressFrameMetrics(float width, float height, float pixelScale) {
        float fallbackInset;
        float safeWidth = Math.max(1.0f, width);
        float safeHeight = Math.max(1.0f, height);
        float maxBorder = Math.min(safeWidth, safeHeight) / 2.0f;
        float scaledBorder = Math.min(maxBorder, Math.max(1.0f, pixelScale));
        float scaledHorizontalInset = Math.min(safeWidth / 2.0f, Math.max(scaledBorder, pixelScale * 2.0f));
        float scaledVerticalInset = Math.min(safeHeight / 2.0f, Math.max(scaledBorder, pixelScale * 2.0f));
        if (safeWidth - scaledHorizontalInset * 2.0f < 1.0f) {
            fallbackInset = Math.max(scaledBorder, (safeWidth - 1.0f) / 2.0f);
            scaledHorizontalInset = Math.min(safeWidth / 2.0f, fallbackInset);
        }
        if (safeHeight - scaledVerticalInset * 2.0f < 1.0f) {
            fallbackInset = Math.max(scaledBorder, (safeHeight - 1.0f) / 2.0f);
            scaledVerticalInset = Math.min(safeHeight / 2.0f, fallbackInset);
        }
        return new ProgressFrameMetrics(scaledBorder, scaledHorizontalInset, scaledVerticalInset);
    }

    private void drawVanillaProgressFrame(float baseX, float baseY, float width, float height, ProgressFrameMetrics metrics) {
        if (metrics == null) {
            return;
        }
        Color color = this.colorScheme.foreground();
        float border = Math.max(0.0f, metrics.borderThickness());
        float horizontalWidth = Math.max(border, width - border * 2.0f);
        this.drawSolidQuad(baseX, baseY, border, height, color, 1.0f);
        this.drawSolidQuad(baseX + width - border, baseY, border, height, color, 1.0f);
        this.drawSolidQuad(baseX + border, baseY, horizontalWidth, border, color, 1.0f);
        this.drawSolidQuad(baseX + border, baseY + height - border, horizontalWidth, border, color, 1.0f);
    }

    private void drawVanillaProgressSegment(float baseX, float baseY, float width, float height, float start, float end, ProgressFrameMetrics metrics) {
        if (metrics == null) {
            return;
        }
        float clampedStart = DrippyEarlyWindowProvider.clamp(start, 0.0f, 1.0f);
        float clampedEnd = DrippyEarlyWindowProvider.clamp(end, 0.0f, 1.0f);
        if (clampedEnd <= clampedStart) {
            return;
        }
        float innerLeft = baseX + metrics.horizontalInset();
        float innerRight = baseX + width - metrics.horizontalInset();
        float innerWidth = Math.max(0.0f, innerRight - innerLeft);
        if (innerWidth <= 0.0f) {
            return;
        }
        float x0 = innerLeft + innerWidth * clampedStart;
        float x1 = innerLeft + innerWidth * clampedEnd;
        float segmentWidth = Math.max(0.0f, x1 - x0);
        float innerTop = baseY + metrics.verticalInset();
        float innerHeight = Math.max(0.0f, height - metrics.verticalInset() * 2.0f);
        if (segmentWidth <= 0.0f || innerHeight <= 0.0f) {
            return;
        }
        this.drawSolidQuad(x0, innerTop, segmentWidth, innerHeight, this.colorScheme.foreground(), 1.0f);
    }

    private void drawSolidQuad(float x, float y, float width, float height, Color color, float alpha) {
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)color.r(), (float)color.g(), (float)color.b(), (float)alpha);
        GL11.glBegin((int)7);
        GL11.glVertex2f((float)x, (float)y);
        GL11.glVertex2f((float)(x + width), (float)y);
        GL11.glVertex2f((float)(x + width), (float)(y + height));
        GL11.glVertex2f((float)x, (float)(y + height));
        GL11.glEnd();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawRectangleOutline(float x, float y, float width, float height, Color color, float alpha) {
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)color.r(), (float)color.g(), (float)color.b(), (float)alpha);
        GL11.glBegin((int)2);
        GL11.glVertex2f((float)x, (float)y);
        GL11.glVertex2f((float)(x + width), (float)y);
        GL11.glVertex2f((float)(x + width), (float)(y + height));
        GL11.glVertex2f((float)x, (float)(y + height));
        GL11.glEnd();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawTexturedQuad(float x, float y, float width, float height, EarlyWindowTextureLoader.LoadedTexture texture, float u0, float v0, float u1, float v1) {
        GL11.glEnable((int)3553);
        int textureId = texture.currentTextureId(this.currentFrameTimestampNanos);
        GL11.glBindTexture((int)3553, (int)textureId);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)u0, (float)v0);
        GL11.glVertex2f((float)x, (float)y);
        GL11.glTexCoord2f((float)u1, (float)v0);
        GL11.glVertex2f((float)(x + width), (float)y);
        GL11.glTexCoord2f((float)u1, (float)v1);
        GL11.glVertex2f((float)(x + width), (float)(y + height));
        GL11.glTexCoord2f((float)u0, (float)v1);
        GL11.glVertex2f((float)x, (float)(y + height));
        GL11.glEnd();
        GL11.glBindTexture((int)3553, (int)0);
        GL11.glDisable((int)3553);
    }

    private void drawBundledMojangLogo(float x, float y, float width, float height, EarlyWindowTextureLoader.LoadedTexture texture) {
        if (texture == null) {
            return;
        }
        float leftWidth = width * 0.5f;
        float rightWidth = width - leftWidth;
        float texWidth = Math.max(1.0f, (float)texture.width());
        float texHeight = Math.max(1.0f, (float)texture.height());
        float margin = 0.0625f / texWidth;
        float halfV = (float)texture.height() * 0.5f / texHeight;
        this.drawTexturedQuad(x, y, leftWidth, height, texture, -margin, 0.0f, 1.0f - margin, halfV);
        this.drawTexturedQuad(x + leftWidth, y, rightWidth, height, texture, margin, halfV, 1.0f + margin, 1.0f);
    }

    private void loadTextures() {
        if (this.textureLoader == null) {
            this.textureLoader = new EarlyWindowTextureLoader(this.gameDirectory, DrippyEarlyWindowProvider.class.getClassLoader());
        }
        this.useBundledMojangLogo = false;
        TexturePathOrigin logoOrigin = this.loadConfiguredTexture(this.options.logoTexturePath(), true, texture -> {
            this.logoTexture = texture;
        }, "logo texture");
        if (this.logoTexture == null && logoOrigin != TexturePathOrigin.REMOTE) {
            this.logoTexture = this.textureLoader.loadBundledTexture(MOJANG_LOGO_PATH);
            this.useBundledMojangLogo = this.logoTexture != null;
        }
        this.loadConfiguredTexture(this.options.backgroundTexturePath(), true, texture -> {
            this.backgroundTexture = texture;
        }, "background texture");
        this.loadConfiguredTexture(this.options.barBackgroundTexturePath(), true, texture -> {
            this.barBackgroundTexture = texture;
        }, "bar background texture");
        this.loadConfiguredTexture(this.options.barProgressTexturePath(), true, texture -> {
            this.barProgressTexture = texture;
        }, "bar progress texture");
        this.loadConfiguredTexture(this.options.topLeftWatermarkTexturePath(), true, texture -> {
            this.topLeftWatermarkTexture = texture;
        }, "top-left watermark texture");
        this.loadConfiguredTexture(this.options.topRightWatermarkTexturePath(), true, texture -> {
            this.topRightWatermarkTexture = texture;
        }, "top-right watermark texture");
        this.loadConfiguredTexture(this.options.bottomLeftWatermarkTexturePath(), true, texture -> {
            this.bottomLeftWatermarkTexture = texture;
        }, "bottom-left watermark texture");
        this.loadConfiguredTexture(this.options.bottomRightWatermarkTexturePath(), true, texture -> {
            this.bottomRightWatermarkTexture = texture;
        }, "bottom-right watermark texture");
    }

    private TexturePathOrigin loadConfiguredTexture(String configuredPath, boolean supportApng, Consumer<EarlyWindowTextureLoader.LoadedTexture> setter, String label) {
        if (setter == null) {
            return TexturePathOrigin.NONE;
        }
        if (configuredPath == null || configuredPath.isBlank()) {
            setter.accept(null);
            return TexturePathOrigin.NONE;
        }
        if (this.isWebSource(configuredPath)) {
            setter.accept(null);
            this.enqueueWebTexture(configuredPath, supportApng, setter, label);
            return TexturePathOrigin.REMOTE;
        }
        EarlyWindowTextureLoader.LoadedTexture texture = this.textureLoader.loadUserTexture(configuredPath, supportApng);
        setter.accept(texture);
        return TexturePathOrigin.LOCAL;
    }

    private void cleanupTextures() {
        this.deleteTexture(this.backgroundTexture);
        this.deleteTexture(this.logoTexture);
        this.deleteTexture(this.barBackgroundTexture);
        this.deleteTexture(this.barProgressTexture);
        this.deleteTexture(this.topLeftWatermarkTexture);
        this.deleteTexture(this.topRightWatermarkTexture);
        this.deleteTexture(this.bottomLeftWatermarkTexture);
        this.deleteTexture(this.bottomRightWatermarkTexture);
        this.pendingWebTextures.clear();
    }

    private void deleteTexture(EarlyWindowTextureLoader.LoadedTexture texture) {
        if (texture != null) {
            texture.delete();
        }
    }

    private void enqueueWebTexture(String source, boolean supportApng, Consumer<EarlyWindowTextureLoader.LoadedTexture> setter, String label) {
        URI uri;
        try {
            uri = URI.create(source.trim());
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warn("[DRIPPY LOADING SCREEN] Ignoring invalid URL '{}' for {}", (Object)source, (Object)label);
            LOGGER.debug("[DRIPPY LOADING SCREEN] Detailed invalid URL reason for {}", (Object)label, (Object)ex);
            return;
        }
        HttpRequest request = HttpRequest.newBuilder(uri).timeout(WEB_TEXTURE_TIMEOUT).header("Accept", "image/apng,image/png,image/jpeg,image/gif,image/*;q=0.8,*/*;q=0.5").GET().build();
        this.httpClient().sendAsync(request, HttpResponse.BodyHandlers.ofByteArray()).whenComplete((response, throwable) -> {
            if (throwable != null) {
                LOGGER.warn("[DRIPPY LOADING SCREEN] Failed to fetch web texture {} from {}", (Object)label, (Object)source);
                LOGGER.debug("[DRIPPY LOADING SCREEN] Detailed fetch failure for {}", (Object)label, throwable);
                return;
            }
            if (response == null) {
                LOGGER.warn("[DRIPPY LOADING SCREEN] Missing response while fetching web texture {} from {}", (Object)label, (Object)source);
                return;
            }
            int status = response.statusCode();
            if (status < 200 || status >= 300) {
                LOGGER.warn("[DRIPPY LOADING SCREEN] Web texture {} returned HTTP {} from {}", (Object)label, (Object)status, (Object)source);
                return;
            }
            byte[] body = (byte[])response.body();
            if (body == null || body.length == 0) {
                LOGGER.warn("[DRIPPY LOADING SCREEN] Web texture {} from {} returned empty body", (Object)label, (Object)source);
                return;
            }
            this.pendingWebTextures.add(new PendingTextureUpload(body, supportApng, setter, label));
        });
    }

    private HttpClient httpClient() {
        if (this.httpClient == null) {
            this.httpClient = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(WEB_TEXTURE_TIMEOUT).build();
        }
        return this.httpClient;
    }

    private boolean isWebSource(String configuredPath) {
        if (configuredPath == null) {
            return false;
        }
        String trimmed = configuredPath.trim();
        if (trimmed.isEmpty()) {
            return false;
        }
        String lower = trimmed.toLowerCase(Locale.ROOT);
        return lower.startsWith("http://") || lower.startsWith("https://");
    }

    private void processPendingWebTextures() {
        PendingTextureUpload pending;
        if (this.pendingWebTextures.isEmpty()) {
            return;
        }
        if (this.textureLoader == null) {
            this.textureLoader = new EarlyWindowTextureLoader(this.gameDirectory, DrippyEarlyWindowProvider.class.getClassLoader());
        }
        while ((pending = this.pendingWebTextures.poll()) != null) {
            try {
                EarlyWindowTextureLoader.LoadedTexture texture = this.textureLoader.loadTextureFromBytes(pending.data(), pending.supportsApng(), pending.label());
                if (texture == null) continue;
                pending.setter().accept(texture);
            }
            catch (Exception ex) {
                LOGGER.warn("[DRIPPY LOADING SCREEN] Failed to create web texture {}", (Object)pending.label());
                LOGGER.debug("[DRIPPY LOADING SCREEN] Detailed web texture failure for {}", (Object)pending.label(), (Object)ex);
            }
        }
    }

    private void updateProgressMetrics() {
        long now = System.nanoTime();
        if (this.lastProgressSampleNanos == 0L) {
            this.lastProgressSampleNanos = now;
        }
        float deltaSeconds = (float)(now - this.lastProgressSampleNanos) / 1.0E9f;
        this.lastProgressSampleNanos = now;
        ProgressSample sample = ProgressSample.capture();
        if (sample.indeterminate()) {
            this.progressIndeterminate = true;
            this.indeterminateOffset = (this.indeterminateOffset + deltaSeconds * 0.4f) % 1.0f;
            this.displayedProgress = 0.0f;
        } else {
            this.progressIndeterminate = false;
            float target = sample.progress();
            float lerpFactor = Math.min(1.0f, deltaSeconds * 6.0f);
            this.displayedProgress += (target - this.displayedProgress) * lerpFactor;
            this.indeterminateOffset = 0.0f;
        }
    }

    private ColorScheme resolveColorScheme() {
        if (System.getenv("FML_EARLY_WINDOW_DARK") != null) {
            return ColorScheme.dark();
        }
        if (this.gameDirectory == null) {
            return ColorScheme.red();
        }
        Path optionsFile = this.gameDirectory.resolve("options.txt");
        if (!Files.isRegularFile(optionsFile, new LinkOption[0])) {
            return ColorScheme.red();
        }
        try {
            List<String> lines = Files.readAllLines(optionsFile, StandardCharsets.UTF_8);
            for (String line : lines) {
                String key;
                int idx = line.indexOf(58);
                if (idx <= 0 || !"darkMojangStudiosBackground".equals(key = line.substring(0, idx).trim())) continue;
                String value = line.substring(idx + 1).trim();
                return Boolean.parseBoolean(value) ? ColorScheme.dark() : ColorScheme.red();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ColorScheme.red();
    }

    private static float computeLoggerFade(int ageMillis, int reverseIndex) {
        float fade = (4000.0f - (float)ageMillis - (float)(reverseIndex - 4) * 1000.0f) / 5000.0f;
        return DrippyEarlyWindowProvider.clamp(fade, 0.0f, 1.0f);
    }

    private static String sanitizeLogMessage(String raw) {
        if (raw == null) {
            return "";
        }
        String trimmed = raw.strip();
        if (trimmed.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder(Math.min(256, trimmed.length()));
        boolean truncated = false;
        for (int i = 0; i < trimmed.length(); ++i) {
            if (builder.length() >= 256) {
                truncated = true;
                break;
            }
            char ch = trimmed.charAt(i);
            if (ch == '\r' || ch == '\n') {
                if (builder.length() == 0 || builder.charAt(builder.length() - 1) == ' ') continue;
                builder.append(' ');
                continue;
            }
            if (ch < ' ' || ch > '~') {
                builder.append('?');
                continue;
            }
            builder.append(ch);
        }
        if (truncated) {
            builder.setLength(253);
            builder.append("...");
        }
        return builder.toString();
    }

    private float computeUiScale() {
        float baseW = Math.max(1.0f, (float)this.baseWindowWidth);
        float baseH = Math.max(1.0f, (float)this.baseWindowHeight);
        float scaleX = (float)this.windowWidth / baseW;
        float scaleY = (float)this.windowHeight / baseH;
        float scale = Math.min(scaleX, scaleY);
        return Math.max(0.1f, scale);
    }

    private float computeGuiPixelScale() {
        int scale;
        int safeWidth = Math.max(1, this.framebufferWidth);
        int safeHeight = Math.max(1, this.framebufferHeight);
        int maxScale = 8;
        for (scale = 1; scale < maxScale && safeWidth / (scale + 1) >= 320 && safeHeight / (scale + 1) >= 240; ++scale) {
        }
        return scale;
    }

    private static float clamp(float value, float min, float max) {
        if (max < min) {
            return min;
        }
        return Math.max(min, Math.min(value, max));
    }

    private record ColorScheme(Color background, Color foreground) {
        private static ColorScheme red() {
            return new ColorScheme(new Color(0.9372549f, 0.19607843f, 0.23921569f), new Color(1.0f, 1.0f, 1.0f));
        }

        private static ColorScheme dark() {
            return new ColorScheme(new Color(0.0f, 0.0f, 0.0f), new Color(1.0f, 1.0f, 1.0f));
        }
    }

    private record Color(float r, float g, float b) {
        private Color withBrightness(float factor) {
            return new Color(Math.min(1.0f, this.r * factor), Math.min(1.0f, this.g * factor), Math.min(1.0f, this.b * factor));
        }
    }

    private record ProgressFrameMetrics(float borderThickness, float horizontalInset, float verticalInset) {
    }

    private static enum WatermarkAnchor {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }

    private record LoggerLine(String text, float alpha) {
    }

    private record DebugLoggerMessage(String text, long createdAtNanos) {
    }

    private static enum TexturePathOrigin {
        NONE,
        LOCAL,
        REMOTE;

    }

    private static final class PendingTextureUpload {
        private final byte[] data;
        private final boolean supportsApng;
        private final Consumer<EarlyWindowTextureLoader.LoadedTexture> setter;
        private final String label;

        private PendingTextureUpload(byte[] data, boolean supportsApng, Consumer<EarlyWindowTextureLoader.LoadedTexture> setter, String label) {
            this.data = data;
            this.supportsApng = supportsApng;
            this.setter = setter;
            this.label = label;
        }

        private byte[] data() {
            return this.data;
        }

        private boolean supportsApng() {
            return this.supportsApng;
        }

        private Consumer<EarlyWindowTextureLoader.LoadedTexture> setter() {
            return this.setter;
        }

        private String label() {
            return this.label;
        }
    }

    private record ProgressSample(float progress, boolean indeterminate) {
        private static ProgressSample capture() {
            List meters = StartupNotificationManager.getCurrentProgress();
            for (ProgressMeter meter : meters) {
                if (meter.steps() <= 0) continue;
                return new ProgressSample(Math.max(0.0f, Math.min(1.0f, meter.progress())), false);
            }
            return new ProgressSample(0.0f, true);
        }
    }
}

