/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.earlywindow.shadow.japng.reader;

import de.keksuccino.drippyloadingscreen.earlywindow.shadow.japng.PngColourType;
import de.keksuccino.drippyloadingscreen.earlywindow.shadow.japng.PngConstants;
import de.keksuccino.drippyloadingscreen.earlywindow.shadow.japng.error.PngException;
import de.keksuccino.drippyloadingscreen.earlywindow.shadow.japng.reader.PngReader;
import de.keksuccino.drippyloadingscreen.earlywindow.shadow.japng.reader.PngStreamSource;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class PngReadHelper {
    public static boolean readSignature(InputStream is) throws IOException {
        for (int i = 0; i < 8; ++i) {
            int b = is.read();
            if (b < 0) {
                throw new EOFException();
            }
            if ((byte)b == PngConstants.BYTES_SIGNATURE[i]) continue;
            return false;
        }
        return true;
    }

    public static <ResultT> ResultT read(InputStream is, PngReader<ResultT> reader) throws PngException {
        try {
            if (!PngReadHelper.readSignature(is)) {
                throw new PngException(1, "Failed to read PNG signature");
            }
            PngStreamSource source = new PngStreamSource(is);
            boolean finished = false;
            while (!finished) {
                int length = source.readInt();
                int code = source.readInt();
                finished = reader.readChunk(source, code, length);
            }
            if (source.available() > 0) {
                throw new PngException(3, String.format("Completed IEND but %d byte(s) remain", source.available()));
            }
            reader.finishedChunks(source);
            return reader.getResult();
        }
        catch (EOFException e) {
            throw new PngException(2, "Unexpected EOF", e);
        }
        catch (IOException e) {
            throw new PngException(4, e.getMessage(), e);
        }
    }

    public static int calculateBytesPerRow(int pixelsPerRow, byte bitDepth, PngColourType colourType, byte interlaceMethod) {
        if (interlaceMethod != 0) {
            throw new IllegalStateException("Interlaced images not yet supported");
        }
        int numComponentsPerPixel = colourType.componentsPerPixel;
        byte bitsPerComponent = bitDepth;
        int bitsPerPixel = bitsPerComponent * numComponentsPerPixel;
        int bitsPerRow = bitsPerPixel * pixelsPerRow;
        int bytesPerRow = bitsPerRow / 8 + (0 == bitsPerRow % 8 ? 0 : 8 - bitsPerRow % 8);
        return 1 + bytesPerRow;
    }
}

