/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.earlywindow.shadow.japng.argb8888;

import de.keksuccino.drippyloadingscreen.earlywindow.shadow.japng.error.PngException;
import de.keksuccino.drippyloadingscreen.earlywindow.shadow.japng.error.PngIntegrityException;

public class Argb8888Palette {
    protected static Argb8888Palette monochromePalette = null;
    protected static Argb8888Palette greyPalette2 = null;
    protected static Argb8888Palette greyPalette4 = null;
    protected static Argb8888Palette greyPalette8 = null;
    public final int[] argbArray;

    public Argb8888Palette(int[] argbArray) {
        this.argbArray = argbArray;
    }

    public int get(int index) {
        return this.argbArray[index];
    }

    public int size() {
        return this.argbArray.length;
    }

    public static Argb8888Palette fromPaletteBytes(byte[] bytes, int position, int length) throws PngException {
        int numColours = length / 3;
        int[] argbArray = new int[numColours];
        int srcIndex = position;
        int alpha = -16777216;
        for (int destIndex = 0; destIndex < numColours; ++destIndex) {
            int r = bytes[srcIndex++] & 0xFF;
            int g = bytes[srcIndex++] & 0xFF;
            int b = bytes[srcIndex++] & 0xFF;
            argbArray[destIndex] = alpha | r << 16 | g << 8 | b;
        }
        return new Argb8888Palette(argbArray);
    }

    public static Argb8888Palette forGreyscale(int numEntries, int step) {
        int[] array = new int[numEntries];
        int alpha = -16777216;
        int grey = 0;
        for (int i = 0; i < numEntries; ++i) {
            array[i] = alpha | grey << 16 | grey << 8 | grey;
            grey = grey + step & 0xFF;
        }
        return new Argb8888Palette(array);
    }

    public static Argb8888Palette forGreyscale(int bitDepth) throws PngException {
        switch (bitDepth) {
            case 1: {
                if (null == monochromePalette) {
                    monochromePalette = Argb8888Palette.forGreyscale(2, 255);
                }
                return monochromePalette;
            }
            case 2: {
                if (null == greyPalette2) {
                    greyPalette2 = Argb8888Palette.forGreyscale(4, 85);
                }
                return greyPalette2;
            }
            case 4: {
                if (null == greyPalette4) {
                    greyPalette4 = Argb8888Palette.forGreyscale(16, 17);
                }
                return greyPalette4;
            }
            case 8: {
                if (null == greyPalette8) {
                    greyPalette8 = Argb8888Palette.forGreyscale(256, 1);
                }
                return greyPalette8;
            }
        }
        throw new PngIntegrityException(String.format("Valid greyscale bit depths are 1, 2, 4, 8, not %d", bitDepth));
    }
}

