/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.earlywindow.bootstrap;

import java.util.Objects;
import java.util.UUID;
import net.neoforged.fml.loading.FMLConfig;
import net.neoforged.neoforgespi.earlywindow.GraphicsBootstrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DrippyEarlyWindowBootstrapper
implements GraphicsBootstrapper {
    private static final Logger LOGGER = LogManager.getLogger();

    public String name() {
        return "drippy_early_window_bootstrap";
    }

    public void bootstrap(String[] arguments) {
        String sessionToken = UUID.randomUUID().toString();
        System.setProperty("drippyloadingscreen.earlywindow.session", sessionToken);
        if (!FMLConfig.getBoolConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_CONTROL)) {
            return;
        }
        String currentProvider = FMLConfig.getConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_PROVIDER);
        if ("drippy_early_window".equals(currentProvider)) {
            return;
        }
        if (!Objects.equals(currentProvider, "fmlearlywindow")) {
            LOGGER.debug("[DRIPPY LOADING SCREEN] Leaving user-selected early window provider {} unchanged.", (Object)currentProvider);
            return;
        }
        FMLConfig.updateConfig((FMLConfig.ConfigValue)FMLConfig.ConfigValue.EARLY_WINDOW_PROVIDER, (Object)"drippy_early_window");
        LOGGER.info("[DRIPPY LOADING SCREEN] Configured NeoForge to use the {} early window provider.", (Object)"drippy_early_window");
    }
}

