/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.jei;

import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.equipment.goggles.GogglesItem;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import com.tom.createores.jei.AnimatedBlock;
import com.tom.createores.jei.JeiPlatform;
import com.tom.createores.jei.Vein;
import com.tom.createores.jei.VeinIngredient;
import com.tom.createores.recipe.ExcavatingRecipe;
import com.tom.createores.recipe.VeinRecipe;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.createmod.catnip.lang.LangBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;

public abstract class ExcavatingCategory<T extends ExcavatingRecipe>
implements IRecipeCategory<RecipeHolder<T>> {
    protected AnimatedBlock block;
    protected IDrawable icon;

    public int getWidth() {
        return 177;
    }

    public int getHeight() {
        return 100;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<T> recipe, IFocusGroup focuses) {
        RecipeManager mngr = Minecraft.getInstance().getConnection().getRecipeManager();
        builder.addSlot(RecipeIngredientRole.INPUT, 51, 3).setBackground(CreateRecipeCategory.getRenderedSlot(), -1, -1).addIngredients(((ExcavatingRecipe)recipe.value()).getDrill());
        mngr.byKey(((ExcavatingRecipe)recipe.value()).veinId).ifPresent(rec -> {
            Recipe patt0$temp = rec.value();
            if (patt0$temp instanceof VeinRecipe) {
                VeinRecipe r = (VeinRecipe)patt0$temp;
                builder.addSlot(RecipeIngredientRole.CATALYST, 100, 3).addIngredient(VeinIngredient.VEIN, (Object)new Vein((RecipeHolder<VeinRecipe>)rec));
            }
        });
        ((ExcavatingRecipe)recipe.value()).getDrillingFluid().ifPresent(fluid -> ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 69, 3).setBackground(CreateRecipeCategory.getRenderedSlot(), -1, -1).addIngredients(JeiPlatform.FLUID_STACK, JeiPlatform.wrapFluid(fluid.getMatchingFluidStacks()))).setFluidRenderer((long)fluid.getRequiredAmount(), false, 16, 16));
    }

    public void draw(RecipeHolder<T> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        this.block.draw(stack, 48, 35);
    }

    public void getTooltip(ITooltipBuilder tooltip, RecipeHolder<T> recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX > 40.0 && mouseX < 80.0 && mouseY > 25.0 && mouseY < 60.0) {
            tooltip.add((FormattedText)Component.translatable((String)"tooltip.coe.processTime", (Object[])new Object[]{((ExcavatingRecipe)recipe.value()).getTicks()}));
            boolean hasGoggles = GogglesItem.isWearingGoggles((Player)Minecraft.getInstance().player);
            if (hasGoggles) {
                LangBuilder rpmUnit = CreateLang.translate((String)"generic.unit.rpm", (Object[])new Object[0]);
                tooltip.add((FormattedText)CreateLang.translate((String)"tooltip.stressImpact", (Object[])new Object[0]).style(ChatFormatting.GRAY).component());
                int impact = ((ExcavatingRecipe)recipe.value()).getStress();
                IRotate.StressImpact impactId = IRotate.StressImpact.HIGH;
                LangBuilder builder = CreateLang.builder().add(CreateLang.text((String)TooltipHelper.makeProgressBar((int)3, (int)(impactId.ordinal() + 1))).style(impactId.getAbsoluteColor()));
                tooltip.add((FormattedText)builder.add(CreateLang.number((double)impact)).text("x ").add(rpmUnit).component());
            }
        }
    }
}

