/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tom.createores.Config;
import com.tom.createores.OreVeinGenerator;
import com.tom.createores.block.entity.IDrill;
import com.tom.createores.recipe.VeinRecipe;
import com.tom.createores.util.ThreeState;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;

public class OreData {
    private ResourceLocation recipe;
    private boolean loaded;
    private long extractedAmount;
    private float randomMul;
    private Set<BlockPos> extractors;
    public static final Codec<OreData> CODEC = Serialized.CODEC.xmap(OreData::new, OreData::save);

    public OreData() {
    }

    public OreData(Serialized data) {
        this.load(data);
    }

    public void load(Serialized data) {
        this.loaded = data.loaded();
        this.recipe = data.recipe().orElse(null);
        this.extractedAmount = data.extracted();
        this.randomMul = data.random();
    }

    public Serialized save() {
        return new Serialized(this.loaded, Optional.ofNullable(this.recipe), this.extractedAmount, this.randomMul);
    }

    public void setRecipe(ResourceLocation recipe) {
        this.recipe = recipe;
    }

    public ResourceLocation getRecipeId() {
        return this.recipe;
    }

    public RecipeHolder<VeinRecipe> getRecipe(RecipeManager mngr) {
        return this.recipe != null ? (RecipeHolder)mngr.byKey(this.recipe).filter(r -> r.value() instanceof VeinRecipe).map(r -> r).orElse(null) : null;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public long getResourcesRemaining(VeinRecipe r) {
        if (r.isFinite() != ThreeState.NEVER) {
            if (r.isFinite() == ThreeState.DEFAULT && Config.defaultInfinite) {
                return 0L;
            }
            double mul = (r.getMaxAmount() - r.getMinAmount()) * this.randomMul + r.getMinAmount();
            long am = Math.round(mul * (double)Config.finiteAmountBase);
            if (this.extractedAmount >= am) {
                return -1L;
            }
            return am - this.extractedAmount;
        }
        return 0L;
    }

    public float getRandomMul() {
        return this.randomMul;
    }

    public void extract(int a) {
        this.extractedAmount += (long)a;
    }

    public boolean canExtract(Level lvl, BlockPos pos) {
        if (Config.maxExtractorsPerVein == 0) {
            return true;
        }
        if (this.extractors == null) {
            this.extractors = new HashSet<BlockPos>();
            this.extractors.add(pos);
            return true;
        }
        if (this.extractors.contains(pos)) {
            return true;
        }
        this.extractors.removeIf(p -> !(lvl.getBlockEntity(p) instanceof IDrill));
        if (this.extractors.size() < Config.maxExtractorsPerVein) {
            this.extractors.add(pos);
            return true;
        }
        return false;
    }

    public void setRandomMul(float randomMul) {
        this.randomMul = randomMul;
    }

    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public void setExtractedAmount(long extractedAmount) {
        this.extractedAmount = extractedAmount;
    }

    public void populate(LevelChunk chunk) {
        RecipeHolder<VeinRecipe> r = OreVeinGenerator.pick(chunk);
        if (r != null) {
            RandomSource rng = OreVeinGenerator.rngFromChunk(chunk);
            this.recipe = r.id();
            this.randomMul = rng.nextFloat();
        }
        this.loaded = true;
    }

    public record Serialized(boolean loaded, Optional<ResourceLocation> recipe, long extracted, float random) {
        public static final Codec<Serialized> CODEC = RecordCodecBuilder.mapCodec(b -> b.group((App)Codec.BOOL.fieldOf("loaded").forGetter(Serialized::loaded), (App)ResourceLocation.CODEC.optionalFieldOf("recipe").forGetter(Serialized::recipe), (App)Codec.LONG.fieldOf("extracted").forGetter(Serialized::extracted), (App)Codec.FLOAT.fieldOf("random").forGetter(Serialized::random)).apply((Applicative)b, Serialized::new)).codec();
    }
}

