/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.recipe;

import com.adonis.createfisheryindustry.CreateFisheryJeiPlugin;
import com.adonis.createfisheryindustry.block.MechanicalPeeler.AnimatedMechanicalPeeler;
import com.adonis.createfisheryindustry.recipe.PeelingRecipe;
import com.adonis.createfisheryindustry.registry.CreateFisheryBlocks;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

@ParametersAreNonnullByDefault
public class SimplePeelingCategory
implements IRecipeCategory<PeelingRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final AnimatedMechanicalPeeler peeler = new AnimatedMechanicalPeeler();
    private static final IDrawable BASIC_SLOT = SimplePeelingCategory.createSlotDrawable();

    public SimplePeelingCategory(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        this.background = guiHelper.createBlankDrawable(177, 90);
        this.icon = guiHelper.createDrawableItemStack(CreateFisheryBlocks.MECHANICAL_PEELER.asStack());
    }

    private static IDrawable createSlotDrawable() {
        return new IDrawable(){

            public int getWidth() {
                return AllGuiTextures.JEI_SLOT.getWidth();
            }

            public int getHeight() {
                return AllGuiTextures.JEI_SLOT.getHeight();
            }

            public void draw(GuiGraphics graphics, int xOffset, int yOffset) {
                AllGuiTextures.JEI_SLOT.render(graphics, xOffset, yOffset);
            }
        };
    }

    public RecipeType<PeelingRecipe> getRecipeType() {
        return CreateFisheryJeiPlugin.PEELING_TYPE_JEI;
    }

    public Component getTitle() {
        return Component.translatable((String)"recipe.createfisheryindustry.peeling");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PeelingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 27, 5).setBackground(BASIC_SLOT, -1, -1).addIngredients((Ingredient)recipe.getIngredients().get(0));
        ItemStack primaryOutputStack = recipe.getPrimaryOutput();
        if (!primaryOutputStack.isEmpty()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 132, 38).setBackground(BASIC_SLOT, -1, -1).addItemStack(primaryOutputStack);
        }
        List<ProcessingOutput> secondaryOutputs = recipe.getSecondaryOutputs();
        int maxDisplaySecondary = 4;
        for (int i = 0; i < Math.min(secondaryOutputs.size(), maxDisplaySecondary); ++i) {
            ProcessingOutput output = secondaryOutputs.get(i);
            int xOffset = i % 2 * 19;
            int yOffset = i / 2 * 19;
            builder.addSlot(RecipeIngredientRole.OUTPUT, 132 + xOffset, 5 + yOffset).setBackground(BASIC_SLOT, -1, -1).addItemStack(output.getStack());
        }
    }

    public void draw(PeelingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics gui, double mouseX, double mouseY) {
        AllGuiTextures.JEI_DOWN_ARROW.render(gui, 65, 10);
        AllGuiTextures.JEI_SHADOW.render(gui, 55, 55);
        this.peeler.draw(gui, 72, 42);
    }
}

