/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.recipe;

import com.adonis.createfisheryindustry.recipe.PeelingRecipeSerializer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeParams;
import java.util.Collection;
import java.util.function.Function;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecBuilders;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class PeelingRecipeParams
extends ProcessingRecipeParams {
    public static final MapCodec<PeelingRecipeParams> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PeelingRecipeSerializer.INGREDIENTS_MAP_CODEC.forGetter(p -> p.ingredients), (App)PeelingRecipeSerializer.RESULTS_MAP_CODEC.forGetter(p -> p.results), (App)HeatCondition.CODEC.optionalFieldOf("heatRequirement", (Object)HeatCondition.NONE).forGetter(p -> p.requiredHeat), (App)SizedFluidIngredient.FLAT_CODEC.listOf().xmap(list -> NonNullList.copyOf((Collection)list), Function.identity()).optionalFieldOf("fluidIngredients", (Object)NonNullList.create()).forGetter(p -> p.fluidIngredients), (App)FluidStack.CODEC.listOf().xmap(list -> NonNullList.copyOf((Collection)list), Function.identity()).optionalFieldOf("fluidResults", (Object)NonNullList.create()).forGetter(p -> p.fluidResults)).apply((Applicative)instance, PeelingRecipeParams::createFromCodec));
    public static final StreamCodec<RegistryFriendlyByteBuf, PeelingRecipeParams> STREAM_CODEC = StreamCodec.of(PeelingRecipeParams::encodeToBuffer, PeelingRecipeParams::decodeFromBuffer);

    public PeelingRecipeParams() {
        this.ingredients = NonNullList.create();
        this.results = NonNullList.create();
        this.processingDuration = 0;
        this.requiredHeat = HeatCondition.NONE;
        this.fluidIngredients = NonNullList.create();
        this.fluidResults = NonNullList.create();
    }

    public PeelingRecipeParams(NonNullList<Ingredient> ingredients, NonNullList<ProcessingOutput> results, HeatCondition requiredHeat, NonNullList<SizedFluidIngredient> fluidIngredients, NonNullList<FluidStack> fluidResults) {
        this.ingredients = ingredients;
        this.results = results;
        this.processingDuration = 0;
        this.requiredHeat = requiredHeat;
        this.fluidIngredients = fluidIngredients;
        this.fluidResults = fluidResults;
    }

    private static PeelingRecipeParams createFromCodec(NonNullList<Ingredient> ingredients, NonNullList<ProcessingOutput> results, HeatCondition requiredHeat, NonNullList<SizedFluidIngredient> fluidIngredients, NonNullList<FluidStack> fluidResults) {
        return new PeelingRecipeParams(ingredients, results, requiredHeat, fluidIngredients, fluidResults);
    }

    private static void encodeToBuffer(RegistryFriendlyByteBuf buffer, PeelingRecipeParams params) {
        CatnipStreamCodecBuilders.nonNullList((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC).encode((Object)buffer, (Object)params.ingredients);
        CatnipStreamCodecBuilders.nonNullList((StreamCodec)ProcessingOutput.STREAM_CODEC).encode((Object)buffer, (Object)params.results);
        HeatCondition.STREAM_CODEC.encode((Object)buffer, (Object)params.requiredHeat);
        CatnipStreamCodecBuilders.nonNullList((StreamCodec)SizedFluidIngredient.STREAM_CODEC).encode((Object)buffer, (Object)params.fluidIngredients);
        CatnipStreamCodecBuilders.nonNullList((StreamCodec)FluidStack.STREAM_CODEC).encode((Object)buffer, (Object)params.fluidResults);
    }

    private static PeelingRecipeParams decodeFromBuffer(RegistryFriendlyByteBuf buffer) {
        NonNullList ingredients = (NonNullList)CatnipStreamCodecBuilders.nonNullList((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC).decode((Object)buffer);
        NonNullList results = (NonNullList)CatnipStreamCodecBuilders.nonNullList((StreamCodec)ProcessingOutput.STREAM_CODEC).decode((Object)buffer);
        HeatCondition heat = (HeatCondition)HeatCondition.STREAM_CODEC.decode((Object)buffer);
        NonNullList fluidIngredients = (NonNullList)CatnipStreamCodecBuilders.nonNullList((StreamCodec)SizedFluidIngredient.STREAM_CODEC).decode((Object)buffer);
        NonNullList fluidResults = (NonNullList)CatnipStreamCodecBuilders.nonNullList((StreamCodec)FluidStack.STREAM_CODEC).decode((Object)buffer);
        return new PeelingRecipeParams((NonNullList<Ingredient>)ingredients, (NonNullList<ProcessingOutput>)results, heat, (NonNullList<SizedFluidIngredient>)fluidIngredients, (NonNullList<FluidStack>)fluidResults);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private NonNullList<Ingredient> ingredients = NonNullList.create();
        private NonNullList<ProcessingOutput> results = NonNullList.create();
        private HeatCondition requiredHeat = HeatCondition.NONE;
        private NonNullList<SizedFluidIngredient> fluidIngredients = NonNullList.create();
        private NonNullList<FluidStack> fluidResults = NonNullList.create();

        public Builder require(ItemLike item) {
            return this.require(Ingredient.of((ItemLike[])new ItemLike[]{item}));
        }

        public Builder require(Ingredient ingredient) {
            this.ingredients.add((Object)ingredient);
            return this;
        }

        public Builder output(ItemLike item) {
            return this.output(item, 1);
        }

        public Builder output(ItemLike item, int count) {
            this.results.add((Object)new ProcessingOutput(new ItemStack(item, count), 1.0f));
            return this;
        }

        public Builder output(ProcessingOutput output) {
            this.results.add((Object)output);
            return this;
        }

        public Builder withHeat(HeatCondition heat) {
            this.requiredHeat = heat;
            return this;
        }

        public PeelingRecipeParams build() {
            return new PeelingRecipeParams(this.ingredients, this.results, this.requiredHeat, this.fluidIngredients, this.fluidResults);
        }
    }
}

