/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.mixin;

import com.adonis.createfisheryindustry.CreateFisheryMod;
import com.adonis.createfisheryindustry.config.CreateFisheryCommonConfig;
import com.adonis.createfisheryindustry.item.CopperDivingLeggingsItem;
import com.adonis.createfisheryindustry.item.NetheriteDivingLeggingsItem;
import com.simibubi.create.content.equipment.armor.DivingBootsItem;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class}, priority=1000)
public abstract class UnderwaterSprintMixin {
    @Unique
    private int cfi_sprintToggleTimer = 0;
    @Unique
    private boolean cfi_wasSprintKeyDown = false;
    @Unique
    private boolean cfi_underwaterSprintActive = false;
    @Unique
    private int cfi_sprintHungerTimer = 0;
    @Unique
    private static final ResourceLocation SPRINT_BOOST_ID = CreateFisheryMod.asResource("underwater_sprint_boost");

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void cfi_handleUnderwaterSprint(CallbackInfo ci) {
        boolean isSprintKeyDown;
        Player player = (Player)this;
        if (!this.cfi_canUseUnderwaterSprint(player)) {
            if (this.cfi_underwaterSprintActive) {
                this.cfi_deactivateUnderwaterSprint(player);
            }
            return;
        }
        Player livingPlayer = player;
        float forwardInput = livingPlayer.zza;
        boolean bl = isSprintKeyDown = forwardInput > 0.8f;
        if (isSprintKeyDown && !this.cfi_wasSprintKeyDown) {
            if (this.cfi_sprintToggleTimer > 0 && !this.cfi_underwaterSprintActive) {
                int minHunger = CreateFisheryCommonConfig.getDivingMinHungerLevel();
                if (player.getFoodData().getFoodLevel() > minHunger || player.getAbilities().mayfly) {
                    this.cfi_activateUnderwaterSprint(player);
                }
            } else {
                this.cfi_sprintToggleTimer = CreateFisheryCommonConfig.getDivingSprintDoubleClickWindow();
            }
        }
        this.cfi_wasSprintKeyDown = isSprintKeyDown;
        if (this.cfi_sprintToggleTimer > 0) {
            --this.cfi_sprintToggleTimer;
        }
        if (this.cfi_underwaterSprintActive) {
            this.cfi_maintainUnderwaterSprint(player);
        }
    }

    @Unique
    private void cfi_activateUnderwaterSprint(Player player) {
        this.cfi_underwaterSprintActive = true;
        this.cfi_sprintToggleTimer = 0;
        player.setSprinting(true);
        AttributeInstance speedAttribute = player.getAttribute(Attributes.MOVEMENT_SPEED);
        if (speedAttribute != null && !speedAttribute.hasModifier(SPRINT_BOOST_ID)) {
            AttributeModifier sprintBoost = new AttributeModifier(SPRINT_BOOST_ID, 0.3, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
            speedAttribute.addTransientModifier(sprintBoost);
        }
        player.getPersistentData().putBoolean("CFI_UnderwaterSprint", true);
        player.getPersistentData().putBoolean("CFI_UnderwaterSprintActive", true);
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.DOLPHIN_SWIM, SoundSource.PLAYERS, 1.0f, 1.5f);
        if (!player.level().isClientSide) {
            player.displayClientMessage((Component)Component.literal((String)"\u00a7b[CFI] \u6c34\u4e0b\u75be\u8dd1\u5df2\u6fc0\u6d3b"), true);
        }
    }

    @Unique
    private void cfi_deactivateUnderwaterSprint(Player player) {
        this.cfi_underwaterSprintActive = false;
        AttributeInstance speedAttribute = player.getAttribute(Attributes.MOVEMENT_SPEED);
        if (speedAttribute != null) {
            speedAttribute.removeModifier(SPRINT_BOOST_ID);
        }
        player.getPersistentData().remove("CFI_UnderwaterSprint");
        player.getPersistentData().remove("CFI_UnderwaterSprintActive");
        player.setSprinting(false);
    }

    @Unique
    private boolean cfi_canUseUnderwaterSprint(Player player) {
        boolean hasDivingBoots = player.getItemBySlot(EquipmentSlot.FEET).getItem() instanceof DivingBootsItem;
        boolean hasDivingLeggings = player.getItemBySlot(EquipmentSlot.LEGS).getItem() instanceof CopperDivingLeggingsItem || player.getItemBySlot(EquipmentSlot.LEGS).getItem() instanceof NetheriteDivingLeggingsItem;
        boolean inFluid = player.isInWater() || player.isInLava();
        return hasDivingBoots && hasDivingLeggings && inFluid;
    }

    @Unique
    private void cfi_maintainUnderwaterSprint(Player player) {
        boolean hasEnoughHunger;
        Player livingPlayer = player;
        float forwardInput = livingPlayer.zza;
        int minHunger = CreateFisheryCommonConfig.getDivingMinHungerLevel();
        boolean bl = hasEnoughHunger = player.getFoodData().getFoodLevel() > minHunger || player.getAbilities().mayfly;
        if (!hasEnoughHunger || player.horizontalCollision || forwardInput <= 0.0f) {
            this.cfi_deactivateUnderwaterSprint(player);
            if (!player.level().isClientSide) {
                String reason = !hasEnoughHunger ? "\u9965\u997f\u5ea6\u4e0d\u8db3" : (player.horizontalCollision ? "\u78b0\u649e\u969c\u788d" : "\u505c\u6b62\u524d\u8fdb");
                player.displayClientMessage((Component)Component.literal((String)("\u00a7c[CFI] \u6c34\u4e0b\u75be\u8dd1\u5df2\u505c\u6b62 - " + reason)), true);
            }
            return;
        }
        player.setSprinting(true);
        this.cfi_applySprintSpeedBoost(player);
        ++this.cfi_sprintHungerTimer;
        if (this.cfi_sprintHungerTimer >= 20) {
            this.cfi_sprintHungerTimer = 0;
            if (!player.getAbilities().mayfly) {
                float hungerCost = (float)CreateFisheryCommonConfig.getDivingSprintHungerCost();
                player.causeFoodExhaustion(hungerCost);
            }
        }
    }

    @Unique
    private void cfi_applySprintSpeedBoost(Player player) {
        double speedMultiplier = CreateFisheryCommonConfig.getDivingCopperSprintSpeed();
        if (player.getItemBySlot(EquipmentSlot.LEGS).getItem() instanceof NetheriteDivingLeggingsItem) {
            speedMultiplier = CreateFisheryCommonConfig.getDivingNetheriteSprintSpeed();
        }
        Player livingPlayer = player;
        float forwardInput = livingPlayer.zza;
        float sideInput = livingPlayer.xxa;
        if ((double)Math.abs(forwardInput) > 0.01 || (double)Math.abs(sideInput) > 0.01) {
            float yaw = player.getYRot() * ((float)Math.PI / 180);
            float pitch = player.getXRot() * ((float)Math.PI / 180);
            double moveX = -Math.sin(yaw) * Math.cos(pitch) * speedMultiplier * (double)forwardInput;
            double moveY = -Math.sin(pitch) * speedMultiplier * (double)forwardInput * 0.5;
            double moveZ = Math.cos(yaw) * Math.cos(pitch) * speedMultiplier * (double)forwardInput;
            Vec3 currentMotion = player.getDeltaMovement();
            Vec3 newMotion = currentMotion.add(moveX += Math.cos(yaw) * speedMultiplier * (double)sideInput * 0.8, moveY, moveZ += Math.sin(yaw) * speedMultiplier * (double)sideInput * 0.8);
            double maxSpeed = 0.5;
            double horizontalSpeed = Math.sqrt(newMotion.x * newMotion.x + newMotion.z * newMotion.z);
            if (horizontalSpeed > maxSpeed) {
                double scale = maxSpeed / horizontalSpeed;
                newMotion = new Vec3(newMotion.x * scale, newMotion.y, newMotion.z * scale);
            }
            player.setDeltaMovement(newMotion);
        }
    }

    @Inject(method={"updatePlayerPose"}, at={@At(value="HEAD")}, cancellable=true)
    private void cfi_preventSwimmingPoseWhileSprinting(CallbackInfo ci) {
        if (this.cfi_underwaterSprintActive) {
            Player player = (Player)this;
            player.refreshDimensions();
            ci.cancel();
        }
    }
}

